/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.internal.aoi;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.aoi.AOIListener;
import net.refractions.udig.aoi.AOIProxy;
import net.refractions.udig.aoi.IAOIService;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.internal.ui.UiPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AOIServiceImpl
implements IAOIService {
    private static final String EXT_ID = "net.refractions.udig.ui.aoi";
    public static final String STRATEGY_ALL_ID = "net.refractions.udig.ui.aoiAll";
    protected List<AOIProxy> proxyList = new ArrayList<AOIProxy>();
    protected AOIListener watcher = new AOIListener(){

        @Override
        public void handleEvent(AOIListener.Event event) {
            AOIServiceImpl.this.notifyListeners(event);
        }
    };
    protected Set<AOIListener> listeners = new CopyOnWriteArraySet<AOIListener>();
    private AOIProxy currentProxy;

    @Override
    public void addListener(AOIListener listener) {
        if (listener == null) {
            throw new NullPointerException("AOIService listener required to be non null");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(AOIListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListeners(AOIListener.Event event) {
        if (event == null) {
            event = new AOIListener.Event(this.getProxy());
        }
        for (AOIListener listener : this.listeners) {
            try {
                if (listener == null) continue;
                listener.handleEvent(event);
            }
            catch (Exception e) {
                UiPlugin.log(this.getClass(), "notifyListeners", e);
            }
        }
    }

    public AOIServiceImpl() {
        ExtensionPointProcessor processAOIItems = new ExtensionPointProcessor(){

            public void process(IExtension extension, IConfigurationElement element) throws Exception {
                AOIProxy proxy = new AOIProxy(element);
                AOIServiceImpl.this.proxyList.add(proxy);
            }
        };
        ExtensionPointUtil.process((Plugin)UiPlugin.getDefault(), (String)EXT_ID, (ExtensionPointProcessor)processAOIItems);
        this.setProxy(this.getDefault());
    }

    @Override
    public ReferencedEnvelope getExtent() {
        return this.currentProxy.getExtent();
    }

    @Override
    public void setProxy(AOIProxy proxy) {
        if (this.currentProxy == proxy) {
            return;
        }
        if (this.currentProxy != null) {
            this.currentProxy.removeListener(this.watcher);
        }
        this.currentProxy = proxy;
        if (this.currentProxy != null) {
            this.currentProxy.addListener(this.watcher);
        }
        AOIListener.Event event = new AOIListener.Event(proxy);
        this.notifyListeners(event);
    }

    @Override
    public Geometry getGeometry() {
        return this.currentProxy.getGeometry();
    }

    @Override
    public CoordinateReferenceSystem getCrs() {
        return this.currentProxy.getCrs();
    }

    @Override
    public AOIProxy getProxy() {
        return this.currentProxy;
    }

    @Override
    public AOIProxy getDefault() {
        return this.findProxy(STRATEGY_ALL_ID);
    }

    @Override
    public List<AOIProxy> getProxyList() {
        return Collections.unmodifiableList(this.proxyList);
    }

    @Override
    public AOIProxy findProxy(String id) {
        for (AOIProxy aOIProxy : this.proxyList) {
            if (!aOIProxy.getId().equals(id)) continue;
            return aOIProxy;
        }
        return null;
    }
}

