/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.aoi;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.aoi.AOIListener;
import net.refractions.udig.internal.ui.UiPlugin;
import org.eclipse.ui.part.IPageBookViewPage;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class IAOIStrategy {
    protected Set<AOIListener> listeners = new CopyOnWriteArraySet<AOIListener>();

    public abstract ReferencedEnvelope getExtent();

    public abstract Geometry getGeometry();

    public abstract CoordinateReferenceSystem getCrs();

    public abstract String getName();

    public void addListener(AOIListener listener) {
        if (listener == null) {
            throw new NullPointerException("AOIService listener required to be non null");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(AOIListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners(AOIListener.Event event) {
        for (AOIListener listener : this.listeners) {
            if (event == null) {
                event = new AOIListener.Event(this);
            }
            try {
                if (listener == null) continue;
                listener.handleEvent(event);
            }
            catch (Exception e) {
                UiPlugin.trace("net.refractions.udig.ui", listener.getClass(), e.getMessage(), e);
            }
        }
    }

    public IPageBookViewPage createPage() {
        return null;
    }
}

