/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.wms;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.style.IStyleConfigurator;
import net.refractions.udig.style.wms.WMSStylePlugin;
import net.refractions.udig.style.wms.internal.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.wms.WebMapServer;
import org.geotools.styling.FeatureTypeStyle;

public class WMSStyleConfigurator
extends IStyleConfigurator {
    Combo styleCombo;
    private List<StyleImpl> styles = new ArrayList<StyleImpl>();
    private Text text;
    private SashForm sashForm;
    private Composite root;
    private net.refractions.udig.project.internal.Layer layer;

    public boolean canStyle(net.refractions.udig.project.internal.Layer aLayer) {
        return aLayer.hasResource(WebMapServer.class);
    }

    protected void refresh() {
        if (this.layer == this.getLayer()) {
            return;
        }
        this.layer = this.getLayer();
        List<StyleImpl> allStyles = WMSStyleConfigurator.getStyles(this.layer.findGeoResource(Layer.class));
        this.styles.clear();
        this.styleCombo.setItems(new String[0]);
        HashMap<String, StyleImpl> nameMap = new HashMap<String, StyleImpl>();
        for (StyleImpl styleImpl : allStyles) {
            StyleImpl wmsStyle = styleImpl;
            String name = this.getDisplayName(wmsStyle);
            if (nameMap.containsKey(name)) {
                StyleImpl oldStyle = (StyleImpl)nameMap.get(name);
                if (oldStyle != null) {
                    nameMap.put(name, null);
                    String oldStyleName = String.valueOf(name) + " (" + oldStyle.getName() + ")";
                    nameMap.put(oldStyleName, oldStyle);
                }
                name = String.valueOf(name) + " (" + wmsStyle.getName() + ")";
            }
            if (nameMap.containsKey(name)) continue;
            nameMap.put(name, wmsStyle);
        }
        for (Map.Entry entry : nameMap.entrySet()) {
            if (entry.getValue() == null) continue;
            this.styleCombo.add((String)entry.getKey());
            this.styles.add((StyleImpl)entry.getValue());
        }
        StyleImpl styleImpl = (StyleImpl)this.layer.getStyleBlackboard().get("net.refractions.udig.render.wmsStyle");
        boolean set = false;
        if (styleImpl != null) {
            int i = 0;
            while (i < this.styles.size()) {
                StyleImpl wmsStyle = this.styles.get(i);
                if (styleImpl.equals((Object)wmsStyle)) {
                    set = true;
                    this.styleCombo.select(i);
                    this.setDetails(wmsStyle);
                    break;
                }
                ++i;
            }
        }
        if (!set && this.styles.size() > 0) {
            this.styleCombo.select(0);
            this.setDetails(this.styles.get(0));
        }
    }

    static List<StyleImpl> getStyles(IGeoResource wmsResource) {
        Layer wmsLayer = null;
        try {
            wmsLayer = (Layer)wmsResource.resolve(Layer.class, null);
        }
        catch (IOException e) {
            Status status = new Status(4, "net.refractions.udig.style.wms", -1, e.getLocalizedMessage(), (Throwable)e);
            WMSStylePlugin.getDefault().getLog().log((IStatus)status);
        }
        if (wmsLayer != null) {
            return wmsLayer.getStyles();
        }
        return Collections.emptyList();
    }

    private String getDisplayName(StyleImpl wmsStyle) {
        String name = wmsStyle.getName();
        if (wmsStyle.getTitle() != null) {
            name = wmsStyle.getTitle().toString(Locale.getDefault());
        }
        return name;
    }

    public void createControl(Composite parent) {
        this.root = parent;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        parent.setLayout((Layout)gridLayout);
        this.createChooser(parent);
        this.createDetails(parent);
    }

    private void createDetails(Composite sashForm) {
        this.text = new Text(sashForm, 2632);
        this.text.setBackground(sashForm.getDisplay().getSystemColor(1));
        GridData gridData = new GridData(4, 4, true, true);
        this.text.setLayoutData((Object)gridData);
    }

    private void createChooser(Composite sashForm) {
        Composite chooserComposite = new Composite(sashForm, 0);
        chooserComposite.setLayout((Layout)new GridLayout(2, false));
        chooserComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        Label styleLabel = new Label(chooserComposite, 256);
        styleLabel.setText(Messages.WMSStyleConfigurator_style_label);
        this.styleCombo = new Combo(chooserComposite, 2060);
        this.styleCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = WMSStyleConfigurator.this.styleCombo.getSelectionIndex();
                if (i > -1) {
                    StyleImpl wmsStyle = (StyleImpl)WMSStyleConfigurator.this.styles.get(i);
                    StyleBlackboard bb = WMSStyleConfigurator.this.getLayer().getStyleBlackboard();
                    bb.put("net.refractions.udig.render.wmsStyle", (Object)wmsStyle);
                    bb.setSelected(new String[]{"net.refractions.udig.render.wmsStyle"});
                    WMSStyleConfigurator.this.setDetails(wmsStyle);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1;
        styleLabel.setLayoutData((Object)gridData);
        gridData = new GridData(4, 0, true, false);
        gridData.verticalAlignment = 1;
        this.styleCombo.setLayoutData((Object)gridData);
    }

    protected void setDetails(StyleImpl wmsStyle) {
        boolean detailsSet = false;
        if (wmsStyle.getAbstract() != null) {
            this.text.setText(MessageFormat.format(Messages.WMSStyleConfigurator_abstract_format, wmsStyle.getAbstract().toString(Locale.getDefault())));
            detailsSet = true;
        }
        if (wmsStyle.getFeatureStyles() != null) {
            StringBuffer buff = new StringBuffer();
            List fts = wmsStyle.getFeatureStyles();
            for (FeatureTypeStyle style : fts) {
                String name = style.getName();
                if (style.getTitle() != null) {
                    name = style.getTitle();
                }
                buff.append(name);
                buff.append("\n");
            }
            this.text.setText(MessageFormat.format(Messages.WMSStyleConfigurator_featureStyles_format, buff));
            detailsSet = true;
        }
        if (!detailsSet) {
            this.text.setText(Messages.WMSStyleConfigurator_no_info);
        }
    }
}

