/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.rasterings;

import java.io.File;
import java.io.IOException;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveAdapterFactory;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.rasterings.RasteringsPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;

public class ShpImageMoasicAdaptorFactory
implements IResolveAdapterFactory {
    static ImageMosaicFormat format = new ImageMosaicFormat();

    public <T> T adapt(IResolve resolve, Class<T> adapter, IProgressMonitor monitor) throws IOException {
        if (adapter.isAssignableFrom(ImageMosaicReader.class)) {
            AbstractGridCoverage2DReader reader = this.toGridCoverage2DReader(resolve, monitor);
            return adapter.cast(reader);
        }
        return null;
    }

    public boolean canAdapt(IResolve resolve, Class<? extends Object> adapter) {
        if (adapter.isAssignableFrom(ImageMosaicReader.class)) {
            File file = this.toShpFile(resolve);
            return file != null && format.accepts((Object)file);
        }
        return false;
    }

    private File toShpFile(IResolve resolve) {
        IGeoResource resource = (IGeoResource)resolve;
        try {
            IService service = resource.service((IProgressMonitor)new NullProgressMonitor());
            if (service.canResolve(ShapefileDataStore.class)) {
                return (File)service.resolve(File.class, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (IOException e) {
            RasteringsPlugin.log("Error obtaining shapefile file", e);
            return null;
        }
        return null;
    }

    AbstractGridCoverage2DReader toGridCoverage2DReader(IResolve resolve, IProgressMonitor monitor) throws IOException {
        File file = this.toShpFile(resolve);
        if (format.accepts((Object)file)) {
            return new ImageMosaicReader((Object)file, null);
        }
        return null;
    }
}

