/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.rasterings;

import java.io.IOException;
import net.refractions.udig.catalog.IGeoResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class GridCoverageLoader {
    protected IGeoResource resource;

    public GridCoverageLoader(IGeoResource resource) {
        this.resource = resource;
    }

    public GridCoverage load(GeneralGridGeometry geom, IProgressMonitor monitor) throws IOException {
        ParameterValueGroup group = (ParameterValueGroup)this.resource.resolve(ParameterValueGroup.class, monitor);
        AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)this.resource.resolve(AbstractGridCoverage2DReader.class, monitor);
        if (group == null) {
            group = reader.getFormat().getReadParameters();
        } else {
            try {
                ParameterValue tempParam = group.parameter(AbstractGridFormat.USE_JAI_IMAGEREAD.getName().toString());
                if (tempParam != null) {
                    tempParam.setValue(false);
                }
            }
            catch (ParameterNotFoundException parameterNotFoundException) {}
        }
        ParameterValue param = group.parameter(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString());
        param.setValue((Object)geom);
        GridCoverage2D coverage = reader.read((GeneralParameterValue[])group.values().toArray(new ParameterValue[0]));
        return coverage;
    }
}

