/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.rasterings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.rasterings.AbstractRasterGeoResource;
import net.refractions.udig.catalog.rasterings.AbstractRasterServiceInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;

public abstract class AbstractRasterService
extends IService {
    private ID id;
    protected Exception message = null;
    protected AbstractGridCoverage2DReader reader;
    private AbstractGridFormat format;
    private GridFormatFactorySpi factory;

    public AbstractRasterService(URL url, String typeQualifier, GridFormatFactorySpi factory) {
        this.id = new ID(url, typeQualifier);
        this.factory = factory;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        return adaptee != null && (adaptee.isAssignableFrom(AbstractGridCoverage2DReader.class) || super.canResolve(adaptee));
    }

    public IResolve.Status getStatus() {
        if (this.reader == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    public void dispose(IProgressMonitor monitor) {
        if (this.reader != null) {
            this.reader.dispose();
            this.reader = null;
        }
        super.dispose(monitor);
    }

    public Throwable getMessage() {
        return this.message;
    }

    public URL getIdentifier() {
        return this.id.toURL();
    }

    public ID getID() {
        return this.id;
    }

    public synchronized AbstractGridFormat getFormat() {
        if (this.format == null) {
            this.format = this.factory.createFormat();
        }
        return this.format;
    }

    public synchronized AbstractGridCoverage2DReader getReader(IProgressMonitor monitor) {
        if (this.reader == null) {
            try {
                AbstractGridFormat frmt = this.getFormat();
                ID id = this.getID();
                if (id.isFile()) {
                    File file = id.toFile();
                    if (file != null) {
                        this.reader = frmt.getReader((Object)file);
                        return this.reader;
                    }
                    throw new FileNotFoundException(id.toFile().toString());
                }
                this.reader = frmt.getReader((Object)id.toURL());
            }
            catch (Exception ex) {
                this.message = ex;
            }
        }
        return this.reader;
    }

    public String getDescription() {
        return this.getIdentifier().toString();
    }

    public String getHandle() {
        return this.getID().toBaseFile();
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isAssignableFrom(AbstractGridCoverage2DReader.class)) {
            return adaptee.cast(this.getReader(monitor));
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public abstract List<AbstractRasterGeoResource> resources(IProgressMonitor var1) throws IOException;

    public AbstractRasterServiceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (AbstractRasterServiceInfo)super.getInfo(monitor);
    }
}

