/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.rasterings;

import com.vividsolutions.jts.geom.Envelope;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.rasterings.AbstractRasterGeoResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class AbstractRasterGeoResourceInfo
extends IGeoResourceInfo {
    protected final AbstractRasterGeoResource resource;

    public AbstractRasterGeoResourceInfo(AbstractRasterGeoResource resource, String ... keywords) {
        this.resource = resource;
        this.keywords = keywords;
    }

    public String getTitle() {
        ID id = this.resource.getID();
        return id.toBaseFile();
    }

    public String getDescription() {
        return this.resource.getIdentifier().toString();
    }

    public synchronized ReferencedEnvelope getBounds() {
        if (this.bounds == null) {
            AbstractGridCoverage2DReader source;
            block5: {
                source = this.resource.service((IProgressMonitor)new NullProgressMonitor()).getReader(null);
                if (source != null) break block5;
                return null;
            }
            try {
                GeneralEnvelope ptBounds = source.getOriginalEnvelope();
                Envelope env = new Envelope(ptBounds.getMinimum(0), ptBounds.getMaximum(0), ptBounds.getMinimum(1), ptBounds.getMaximum(1));
                CoordinateReferenceSystem geomcrs = source.getCrs();
                if (geomcrs == null) {
                    geomcrs = DefaultEngineeringCRS.GENERIC_2D;
                }
                this.bounds = new ReferencedEnvelope(env, geomcrs);
            }
            catch (Exception e) {
                CatalogPlugin.getDefault().getLog().log((IStatus)new Status(2, "net.refractions.udig.catalog", 0, "Error while getting the bounds of a layer", (Throwable)e));
            }
        }
        return this.bounds;
    }
}

