/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.maskedconvolve;

import java.awt.image.renderable.ParameterBlock;
import java.util.Collection;
import javax.media.jai.KernelJAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ROI;
import org.jaitools.numeric.Range;

public class MaskedConvolveDescriptor
extends OperationDescriptorImpl {
    public static final String MIN_CELLS_ANY = "ANY";
    public static final String MIN_CELLS_ALL = "ALL";
    public static final Number DEFAULT_NIL_VALUE = 0;
    static final int KERNEL_ARG = 0;
    static final int ROI_ARG = 1;
    static final int MASKSRC_ARG = 2;
    static final int MASKDEST_ARG = 3;
    static final int NIL_VALUE_ARG = 4;
    static final int MIN_CELLS_ARG = 5;
    static final int NO_DATA_ARG = 6;
    static final int STRICT_NO_DATA_ARG = 7;
    private static final String[] paramNames = new String[]{"kernel", "roi", "maskSource", "maskDest", "nilValue", "minCells", "nodata", "strictNodata"};
    private static final Class[] paramClasses = new Class[]{KernelJAI.class, ROI.class, Boolean.class, Boolean.class, Number.class, Object.class, Collection.class, Boolean.class};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, NO_PARAMETER_DEFAULT, Boolean.TRUE, Boolean.TRUE, DEFAULT_NIL_VALUE, "ANY", null, Boolean.FALSE};

    public MaskedConvolveDescriptor() {
        super((String[][])new String[][]{{"GlobalName", "MaskedConvolve"}, {"LocalName", "MaskedConvolve"}, {"Vendor", "org.jaitools.media.jai"}, {"Description", "Convolve a rendered image masked by an associated ROI"}, {"DocURL", "http://code.google.com/p/jaitools/"}, {"Version", "1.0.0"}, {"arg0Desc", paramNames[0] + " - a JAI Kernel object"}, {"arg1Desc", paramNames[1] + " - an ROI object which must have the same " + "pixel bounds as the source iamge"}, {"arg2Desc", paramNames[2] + " (Boolean, default=true):" + "if TRUE (default) only the values of source pixels where" + "roi.contains is true contribute to the convolution"}, {"arg3Desc", paramNames[3] + " (Boolean): " + "if TRUE (default) convolution is only performed" + "for pixels where roi.contains is true"}, {"arg4Desc", paramNames[4] + " (Number): " + "the value to write to the destination image for pixels where " + "there is no convolution result"}, {"arg5Desc", paramNames[5] + " (String or Number, default=MIN_CELLS_ANY):" + "the minimum number of non-zero kernel cells that must overlap" + "unmasked source image cells for convolution to be performed"}, {"arg6Desc", paramNames[6] + " (Collection) " + "values to be treated as NO_DATA; elements can be Number and/or" + " Range"}, {"arg6Desc", paramNames[7] + " (Collection) " + "values to be treated as NO_DATA; elements can be Number and/or" + " Range"}}, new String[]{"rendered"}, 1, paramNames, paramClasses, paramDefaults, null);
    }

    protected boolean validateParameters(String modeName, ParameterBlock pb, StringBuffer msg) {
        String minCellsErrorMsg = "minCells must be ANY, ALL or a numeric value between 1 and the number of non-zero kernel cells";
        String nodataErrorMsg = "nodata parameter must be a Collection of Numbers and/or Ranges";
        boolean ok = super.validateParameters(modeName, pb, msg);
        if (ok) {
            KernelJAI kernel = (KernelJAI)pb.getObjectParameter(0);
            Object minCells = pb.getObjectParameter(5);
            int minCellsValue = this.parseMinCells(minCells, kernel);
            if (minCellsValue >= 1) {
                pb.set((Object)minCellsValue, 5);
            } else {
                msg.append("minCells must be ANY, ALL or a numeric value between 1 and the number of non-zero kernel cells");
                ok = false;
            }
            Object objc = pb.getObjectParameter(6);
            if (objc != null) {
                if (!(objc instanceof Collection)) {
                    msg.append("nodata parameter must be a Collection of Numbers and/or Ranges");
                    ok = false;
                } else {
                    Collection col = (Collection)objc;
                    for (Object oelem : col) {
                        if (oelem instanceof Number || oelem instanceof Range) continue;
                        msg.append("nodata parameter must be a Collection of Numbers and/or Ranges");
                        ok = false;
                        break;
                    }
                }
            }
        }
        return ok;
    }

    private int parseMinCells(Object minCells, KernelJAI kernel) {
        int n;
        int value = -1;
        int numActiveKernelCells = this.numActiveKernelCells(kernel);
        if (minCells instanceof String) {
            String s = (String)minCells;
            if (s.trim().equalsIgnoreCase(MIN_CELLS_ALL)) {
                value = numActiveKernelCells;
            }
            if (s.trim().equalsIgnoreCase(MIN_CELLS_ANY)) {
                value = 1;
            }
            if (value < 0) {
                try {
                    int n2 = Double.valueOf(s).intValue();
                    if (n2 > 0 && n2 <= numActiveKernelCells) {
                        value = n2;
                    }
                }
                catch (NumberFormatException ex) {}
            }
        } else if (minCells instanceof Number && (n = ((Number)minCells).intValue()) > 0 && n <= numActiveKernelCells) {
            value = n;
        }
        return value;
    }

    private int numActiveKernelCells(KernelJAI kernel) {
        float TOL = 1.0E-6f;
        float[] data = kernel.getKernelData();
        int n = 0;
        for (float cellValue : data) {
            if (!(Math.abs(cellValue) > 1.0E-6f)) continue;
            ++n;
        }
        return n;
    }
}

