/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0.xml;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.geotools.data.Query;
import org.geotools.data.wfs.v1_0_0.Action;
import org.geotools.data.wfs.v1_0_0.LockRequest;
import org.geotools.data.wfs.v1_0_0.LockResult;
import org.geotools.data.wfs.v1_0_0.TransactionResult;
import org.geotools.data.wfs.v1_0_0.WFSTransactionState;
import org.geotools.data.wfs.v1_0_0.xml.WFSBasicComplexTypes;
import org.geotools.data.wfs.v1_0_0.xml.WFSSchema;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.SchemaFactory;
import org.geotools.xml.filter.FilterSchema;
import org.geotools.xml.gml.GMLSchema;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeValue;
import org.geotools.xml.schema.Choice;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.schema.Sequence;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.impl.ChoiceGT;
import org.geotools.xml.schema.impl.FacetGT;
import org.geotools.xml.schema.impl.SequenceGT;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class WFSTransactionComplexTypes {

    private static class AllSomeType
    implements SimpleType {
        private static SimpleType instance = new AllSomeType();
        private static Facet[] facets = new Facet[]{new FacetGT(1, "ALL"), new FacetGT(1, "SOME")};

        private AllSomeType() {
        }

        public static SimpleType getInstance() {
            return instance;
        }

        @Override
        public int getFinal() {
            return 0;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public AttributeValue toAttribute(Attribute attribute, Object value, Map hints) {
            return null;
        }

        @Override
        public boolean canCreateAttributes(Attribute attribute, Object value, Map hints) {
            return false;
        }

        @Override
        public int getChildType() {
            return 4;
        }

        @Override
        public SimpleType[] getParents() {
            return new SimpleType[]{XSISimpleTypes.String.getInstance()};
        }

        @Override
        public Facet[] getFacets() {
            return facets;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (value == null || value.length != 1 || element == null || element.getType() == null) {
                throw new SAXNotSupportedException("invalid inputs");
            }
            if (value[0].getValue() instanceof String) {
                String t = (String)value[0].getValue();
                if ("ALL".equals(t) || "SOME".equals(t)) {
                    return t;
                }
                throw new SAXException("Invalid value: not ALL or NONE");
            }
            throw new SAXNotSupportedException("Invalid child value type.");
        }

        @Override
        public String getName() {
            return "AllSomeType";
        }

        @Override
        public URI getNamespace() {
            return WFSSchema.NAMESPACE;
        }

        @Override
        public Class getInstanceType() {
            return String.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return element != null && element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof String && ("ALL".equals(value) || "SOME".equals(value));
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException {
            if (this.canEncode(element, value, hints)) {
                output.startElement(element.getNamespace(), element.getName(), null);
            }
            output.characters((String)value);
            output.endElement(element.getNamespace(), element.getName());
        }

        @Override
        public Element findChildElement(String name) {
            return null;
        }
    }

    private static class WFSEmptyType
    extends WFSSchema.WFSComplexType {
        private static WFSSchema.WFSComplexType instance = new WFSEmptyType();

        private WFSEmptyType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return null;
        }

        @Override
        public ElementGrouping getChild() {
            return null;
        }

        @Override
        public Element[] getChildElements() {
            return null;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return null;
        }

        @Override
        public String getName() {
            return "EmptyType";
        }

        @Override
        public Class getInstanceType() {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return element != null;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException {
            output.element(element.getNamespace(), element.getName(), null);
        }
    }

    static class StatusType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new StatusType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement("SUCCESS", WFSEmptyType.getInstance()), new WFSSchema.WFSElement("FAILED", WFSEmptyType.getInstance()), new WFSSchema.WFSElement("FAILED", WFSEmptyType.getInstance())};
        private static Choice child = new ChoiceGT(elems);

        StatusType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return null;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null || element.getType() == null) {
                throw new SAXException("Invalid parameters : null found");
            }
            if (value.length < 1 || value.length > 1) {
                throw new SAXException("Invalid children: too few or too many");
            }
            if (!this.getName().equals(element.getType().getName())) {
                throw new SAXException("Invalid type name for element provided");
            }
            if (value[0].getElement() == null || value[0].getElement().getName() == null) {
                throw new SAXException("Invalid child element: no name was provided");
            }
            return new Integer(TransactionResult.parseStatus(value[0].getElement().getName()));
        }

        @Override
        public String getName() {
            return "StatusType";
        }

        @Override
        public Class getInstanceType() {
            return Integer.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class InsertResultType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new InsertResultType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement(FilterSchema.getInstance().getElements()[1].getName(), FilterSchema.getInstance().getElements()[1].getType(), FilterSchema.getInstance().getElements()[1].getSubstitutionGroup()){

            @Override
            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        }};
        private static Sequence child = new SequenceGT(null, elems, 1, Integer.MAX_VALUE);
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("handle", XSISimpleTypes.String.getInstance(), 0)};

        InsertResultType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return attrs;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null || element.getType() == null) {
                throw new SAXException("Invalid parameters : null found");
            }
            if (value.length < 1) {
                throw new SAXException("Invalid children: too few");
            }
            if (!this.getName().equals(element.getType().getName())) {
                throw new SAXException("Invalid type name for element provided");
            }
            ArrayList<String> fidList = new ArrayList<String>();
            for (int i = 0; i < value.length; ++i) {
                fidList.addAll(Arrays.asList(((FidFilter)value[i].getValue()).getFids()));
            }
            return fidList;
        }

        @Override
        public String getName() {
            return "InsertResultType";
        }

        @Override
        public Class getInstanceType() {
            return FidFilter.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class TransactionResultType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new TransactionResultType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement("Status", StatusType.getInstance()), new WFSSchema.WFSElement("Locator", XSISimpleTypes.String.getInstance(), 0, 1, true, null), new WFSSchema.WFSElement("Message", XSISimpleTypes.String.getInstance(), 0, 1, true, null)};
        private static Sequence child = new SequenceGT(elems);
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("handle", XSISimpleTypes.String.getInstance(), 0)};

        TransactionResultType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return attrs;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null || element.getType() == null) {
                throw new SAXException("Invalid parameters : null found");
            }
            if (value.length < 1) {
                throw new SAXException("Invalid children: too few");
            }
            if (!this.getName().equals(element.getType().getName())) {
                throw new SAXException("Invalid type name for element provided");
            }
            Object[] t = new Object[2];
            t[0] = value[0].getValue();
            String locator = null;
            String message = null;
            if (value.length > 1) {
                if (value[1].getElement() != null && elems[1].getName().equals(value[1].getElement().getName())) {
                    locator = (String)value[1].getValue();
                    if (value[2].getElement() != null && elems[2].getName().equals(value[2].getElement().getName())) {
                        message = (String)value[2].getValue();
                    }
                } else if (value[1].getElement() != null && elems[2].getName().equals(value[1].getElement().getName())) {
                    message = (String)value[1].getValue();
                }
            }
            t[1] = message == null ? (locator == null ? null : new SAXException(locator)) : (locator == null ? new SAXException(message) : new SAXException(message + ":" + locator));
            return t;
        }

        @Override
        public String getName() {
            return "TransactionResultType";
        }

        @Override
        public Class getInstanceType() {
            return Object[].class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class WFS_TransactionResponseType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new WFS_TransactionResponseType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement("InsertResult", InsertResultType.getInstance(), 0, Integer.MAX_VALUE, true, null), new WFSSchema.WFSElement("TransactionResult", TransactionResultType.getInstance())};
        private static Sequence child = new SequenceGT(elems);
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("version", XSISimpleTypes.String.getInstance(), 2){

            @Override
            public String getFixed() {
                return "1.0.0";
            }
        }};

        WFS_TransactionResponseType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return attrs;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null || element.getType() == null) {
                throw new SAXException("Invalid parameters : null found");
            }
            if (value.length < 1) {
                throw new SAXException("Invalid children: too few");
            }
            if (!this.getName().equals(element.getType().getName())) {
                throw new SAXException("Invalid type name for element provided");
            }
            ArrayList<String> fidSet = new ArrayList<String>();
            for (int i = 0; i < value.length - 1; ++i) {
                fidSet.addAll((Collection)value[i].getValue());
            }
            Object[] t = (Object[])value[value.length - 1].getValue();
            int status = (Integer)t[0];
            SAXException error = (SAXException)(t.length < 2 ? null : t[1]);
            return new TransactionResult(status, fidSet, error);
        }

        @Override
        public String getName() {
            return "WFS_TransactionResponseType";
        }

        @Override
        public Class getInstanceType() {
            return TransactionResult.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class FeaturesNotLockedType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new FeaturesNotLockedType();
        private static Element[] elems = new Element[]{FilterSchema.getInstance().getElements()[1]};
        private static Sequence child = new SequenceGT(null, elems, 1, Integer.MAX_VALUE);

        FeaturesNotLockedType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return null;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null || element.getType() == null) {
                throw new SAXException("Invalid parameters : null found");
            }
            if (value.length < 1) {
                throw new SAXException("Invalid children: too few");
            }
            if (!this.getName().equals(element.getType().getName())) {
                throw new SAXException("Invalid type name for element provided");
            }
            HashSet<String> fidSet = new HashSet<String>();
            for (int i = 0; i < value.length; ++i) {
                fidSet.addAll(Arrays.asList(((FidFilter)value[i].getValue()).getFids()));
            }
            FidFilter r = FilterFactoryFinder.createFilterFactory().createFidFilter();
            r.addAllFids(fidSet);
            return r;
        }

        @Override
        public String getName() {
            return "FeaturesNotLockedType";
        }

        @Override
        public Class getInstanceType() {
            return FidFilter.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class FeaturesLockedType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new FeaturesLockedType();
        private static Element[] elems = new Element[]{FilterSchema.getInstance().getElements()[1]};
        private static Sequence child = new SequenceGT(null, elems, 1, Integer.MAX_VALUE);

        FeaturesLockedType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return null;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null || element.getType() == null) {
                throw new SAXException("Invalid parameters : null found");
            }
            if (value.length < 1) {
                throw new SAXException("Invalid children: too few");
            }
            if (!this.getName().equals(element.getType().getName())) {
                throw new SAXException("Invalid type name for element provided");
            }
            HashSet<String> fidSet = new HashSet<String>();
            for (int i = 0; i < value.length; ++i) {
                fidSet.addAll(Arrays.asList(((FidFilter)value[i].getValue()).getFids()));
            }
            FidFilter r = FilterFactoryFinder.createFilterFactory().createFidFilter();
            r.addAllFids(fidSet);
            return r;
        }

        @Override
        public String getName() {
            return "FeaturesLockedType";
        }

        @Override
        public Class getInstanceType() {
            return FidFilter.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class WFS_LockFeatureResponseType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new WFS_LockFeatureResponseType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement("LockId", XSISimpleTypes.String.getInstance()), new WFSSchema.WFSElement("FeaturesLocked", FeaturesLockedType.getInstance(), 0, 1, true, null), new WFSSchema.WFSElement("FeaturesNotLocked", FeaturesNotLockedType.getInstance(), 0, 1, true, null)};
        private static Sequence child = new SequenceGT(elems);

        WFS_LockFeatureResponseType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return null;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null || element.getType() == null) {
                throw new SAXException("Invalid parameters : null found");
            }
            if (value.length < 1 || value.length > 3) {
                throw new SAXException("Invalid children: too few or too many");
            }
            if (!this.getName().equals(element.getType().getName())) {
                throw new SAXException("Invalid type name for element provided");
            }
            String lockId = (String)value[0].getValue();
            FidFilter in = null;
            FidFilter out = null;
            int i = 1;
            if (i < value.length && elems[1].getType().getName().equals(value[i].getElement().getType().getName())) {
                in = (FidFilter)((Object)value[i++]);
            }
            if (i < value.length && elems[2].getType().getName().equals(value[i].getElement().getType().getName())) {
                out = (FidFilter)((Object)value[i++]);
            }
            return new LockResult(lockId, in, out);
        }

        @Override
        public String getName() {
            return "WFS_LockFeatureResponseType";
        }

        @Override
        public Class getInstanceType() {
            return LockResult.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return false;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws OperationNotSupportedException {
            throw new OperationNotSupportedException();
        }
    }

    static class PropertyType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new PropertyType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement("Name", XSISimpleTypes.String.getInstance()), new WFSSchema.WFSElement("Value", WFSEmptyType.getInstance(), 0, 1, true, null){

            public boolean isMixed() {
                return true;
            }
        }};
        private static Sequence child = new SequenceGT(elems);

        PropertyType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return null;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, SAXNotSupportedException {
            throw new SAXNotSupportedException("");
        }

        @Override
        public String getName() {
            return "PropertyType";
        }

        @Override
        public Class getInstanceType() {
            return Object[].class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return element != null && element.getType() != null && this.getName().equals(element.getType().getName()) && value != null && value instanceof Object[] && ((Object[])value).length == 2;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new OperationNotSupportedException("Cannot encode " + element + " in PropertyType");
            }
            Object[] t = (Object[])value;
            output.startElement(element.getNamespace(), element.getName(), null);
            elems[0].getType().encode(elems[0], t[0], output, hints);
            if (t[1] != null) {
                output.startElement(elems[1].getNamespace(), elems[1].getName(), null);
                if (t[1] instanceof SimpleFeature) {
                    GMLSchema.getInstance().getElements()[0].getType().encode(GMLSchema.getInstance().getElements()[0], t[1], output, hints);
                } else if (t[1] instanceof Geometry) {
                    GMLSchema.getInstance().getElements()[29].getType().encode(GMLSchema.getInstance().getElements()[0], t[1], output, hints);
                } else {
                    output.characters(t[1].toString());
                }
                output.endElement(elems[1].getNamespace(), elems[1].getName());
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    static class NativeType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new NativeType();
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("vendorId", XSISimpleTypes.String.getInstance(), 2), new WFSSchema.WFSAttribute("safeToIgnore", XSISimpleTypes.Boolean.getInstance(), 2)};

        NativeType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return attrs;
        }

        @Override
        public ElementGrouping getChild() {
            return null;
        }

        @Override
        public Element[] getChildElements() {
            return null;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            throw new SAXNotSupportedException("");
        }

        @Override
        public String getName() {
            return "NativeType";
        }

        @Override
        public Class getInstanceType() {
            return Action.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return element != null && element.getType() != null && this.getName().equals(element.getType().getName()) && value != null && value instanceof Action && ((Action)value).getType() == 0;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[0].getName(), null, "string", "www.refractions.net");
            attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[1].getName(), null, "string", "true");
            output.element(element.getNamespace(), element.getName(), attributes);
        }
    }

    static class DeleteElementType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new DeleteElementType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement(FilterSchema.getInstance().getElements()[2].getName(), FilterSchema.getInstance().getElements()[2].getType(), 0, 1, false, FilterSchema.getInstance().getElements()[2].getSubstitutionGroup()){

            @Override
            public URI getNamespace() {
                return FilterSchema.NAMESPACE;
            }
        }};
        private static Sequence child = new SequenceGT(elems);
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("handler", XSISimpleTypes.String.getInstance(), 0), new WFSSchema.WFSAttribute("typeName", XSISimpleTypes.QName.getInstance(), 2)};

        DeleteElementType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return attrs;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            throw new SAXNotSupportedException("");
        }

        @Override
        public String getName() {
            return "DeleteElementType";
        }

        @Override
        public Class getInstanceType() {
            return Action.DeleteAction.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return element != null && element.getType() != null && this.getName().equals(element.getType().getName()) && value != null && value instanceof Action.DeleteAction;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            Action.DeleteAction a = (Action.DeleteAction)value;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[1].getName(), null, "string", a.getTypeName());
            output.startElement(element.getNamespace(), element.getName(), attributes);
            elems[0].getType().encode(elems[0], a.getFilter(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    static class UpdateElementType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new UpdateElementType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement("Property", PropertyType.getInstance(), 0, Integer.MAX_VALUE, true, null), new WFSSchema.WFSElement(FilterSchema.getInstance().getElements()[2].getName(), FilterSchema.getInstance().getElements()[2].getType(), 0, 1, false, FilterSchema.getInstance().getElements()[2].getSubstitutionGroup()){

            @Override
            public URI getNamespace() {
                return FilterSchema.NAMESPACE;
            }
        }};
        private static Sequence child = new SequenceGT(elems);
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("handler", XSISimpleTypes.String.getInstance(), 0), new WFSSchema.WFSAttribute("typeName", XSISimpleTypes.QName.getInstance(), 2)};

        UpdateElementType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return attrs;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            throw new SAXNotSupportedException("");
        }

        @Override
        public String getName() {
            return "UpdateElementType";
        }

        @Override
        public Class getInstanceType() {
            return Action.UpdateAction.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return element != null && element.getType() != null && this.getName().equals(element.getType().getName()) && value != null && value instanceof Action.UpdateAction;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            Action.UpdateAction a = (Action.UpdateAction)value;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[1].getName(), null, "string", a.getTypeName());
            output.startElement(element.getNamespace(), element.getName(), attributes);
            Object[] prop = new Object[2];
            String[] names = a.getPropertyNames();
            for (int i = 0; i < names.length; ++i) {
                prop[0] = names[i];
                prop[1] = a.getProperty(names[i]);
                elems[0].getType().encode(elems[0], prop, output, hints);
            }
            elems[1].getType().encode(elems[1], a.getFilter(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    static class InsertElementType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new InsertElementType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement(GMLSchema.getInstance().getElements()[0].getName(), GMLSchema.getInstance().getElements()[0].getType(), 1, Integer.MAX_VALUE, GMLSchema.getInstance().getElements()[0].isAbstract(), GMLSchema.getInstance().getElements()[0].getSubstitutionGroup()){

            @Override
            public URI getNamespace() {
                return GMLSchema.NAMESPACE;
            }
        }};
        private static Sequence child = new SequenceGT(elems);
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("handler", XSISimpleTypes.String.getInstance(), 0)};

        InsertElementType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return attrs;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            throw new SAXNotSupportedException("");
        }

        @Override
        public String getName() {
            return "InsertElementType";
        }

        @Override
        public Class getInstanceType() {
            return Action.InsertAction.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return element != null && element.getType() != null && this.getName().equals(element.getType().getName()) && value != null && value instanceof Action.InsertAction;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            output.startElement(element.getNamespace(), element.getName(), null);
            Action.InsertAction a = (Action.InsertAction)value;
            SimpleFeature f = a.getFeature();
            SimpleFeatureType featureType = f.getFeatureType();
            Name name = featureType.getName();
            Schema schema = SchemaFactory.getInstance(name.getNamespaceURI());
            Element[] els = schema.getElements();
            Element e = null;
            if (els != null) {
                for (int i = 0; i < els.length; ++i) {
                    String typeName = featureType.getTypeName();
                    if (typeName.indexOf(58) >= 0) {
                        typeName = typeName.substring(typeName.indexOf(58) + 1);
                    }
                    if (!typeName.equals(els[i].getName())) continue;
                    e = els[i];
                    i = els.length;
                }
            }
            elems[0].getType().encode(e, f, output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    static class LockType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new LockType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement(FilterSchema.getInstance().getElements()[2].getName(), FilterSchema.getInstance().getElements()[2].getType(), 0, 1, false, FilterSchema.getInstance().getElements()[2].getSubstitutionGroup()){

            @Override
            public URI getNamespace() {
                return FilterSchema.NAMESPACE;
            }
        }};
        private static Sequence child = new SequenceGT(elems);
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("handle", XSISimpleTypes.String.getInstance(), 0), new WFSSchema.WFSAttribute("typeName", XSISimpleTypes.QName.getInstance(), 2)};

        LockType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return attrs;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            throw new SAXNotSupportedException("");
        }

        @Override
        public String getName() {
            return "LockType";
        }

        @Override
        public Class getInstanceType() {
            return Object[].class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return element != null && element.getType() != null && this.getName().equals(element.getType().getName()) && value != null && value instanceof Object[] && ((Object[])value).length == 2;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new IOException("Cannot encode");
            }
            Object[] t = (Object[])value;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[1].getName(), null, "string", (String)t[0]);
            LockRequest lockRequest = (LockRequest)value;
            if (lockRequest != null && lockRequest.getDuration() > 0L) {
                attributes.addAttribute(WFSSchema.NAMESPACE.toString(), elems[2].getName(), null, "integer", "" + lockRequest.getDuration());
            }
            output.startElement(element.getNamespace(), element.getName(), attributes);
            elems[0].getType().encode(elems[0], t[1], output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    static class LockFeatureType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new WFSBasicComplexTypes.FeatureCollectionType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement("Lock", LockType.getInstance(), 1, Integer.MAX_VALUE, false, null)};
        private Sequence child = new SequenceGT(elems);
        private Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("version", XSISimpleTypes.String.getInstance(), 2){

            @Override
            public String getFixed() {
                return "1.0.0";
            }
        }, new WFSSchema.WFSAttribute("service", XSISimpleTypes.String.getInstance(), 2){

            @Override
            public String getFixed() {
                return "WFS";
            }
        }, new WFSSchema.WFSAttribute("expiry", XSISimpleTypes.PositiveInteger.getInstance(), 0), new WFSSchema.WFSAttribute("lockAction", AllSomeType.getInstance(), 0)};

        LockFeatureType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return this.attrs;
        }

        @Override
        public ElementGrouping getChild() {
            return this.child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            throw new SAXNotSupportedException("");
        }

        @Override
        public String getName() {
            return "LockFeatureType";
        }

        @Override
        public Class getInstanceType() {
            return LockRequest.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return element != null && element.getType() != null && this.getName().equals(element.getType().getName()) && value != null && value instanceof LockRequest;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new IOException("Cannot encode");
            }
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(WFSSchema.NAMESPACE.toString(), this.attrs[0].getName(), null, "string", this.attrs[0].getFixed());
            attributes.addAttribute(WFSSchema.NAMESPACE.toString(), this.attrs[1].getName(), null, "string", this.attrs[1].getFixed());
            attributes.addAttribute(WFSSchema.NAMESPACE.toString(), this.attrs[3].getName(), null, "string", "ALL");
            LockRequest lockRequest = (LockRequest)value;
            if (lockRequest != null && lockRequest.getDuration() > 0L) {
                attributes.addAttribute(WFSSchema.NAMESPACE.toString(), elems[2].getName(), null, "integer", "" + lockRequest.getDuration());
            }
            output.startElement(element.getNamespace(), element.getName(), attributes);
            Object[] t = new Object[2];
            for (int i = 0; i < lockRequest.getTypeNames().length; ++i) {
                t[0] = lockRequest.getTypeNames()[i];
                t[1] = lockRequest.getFilters()[i];
                elems[0].getType().encode(elems[0], t, output, hints);
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    static class GetFeatureWithLockType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new WFSBasicComplexTypes.FeatureCollectionType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement("Query", WFSBasicComplexTypes.QueryType.getInstance(), 1, Integer.MAX_VALUE, false, null)};
        private static Sequence child = new SequenceGT(elems);
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("version", XSISimpleTypes.String.getInstance(), 2){

            @Override
            public String getFixed() {
                return "1.0.0";
            }
        }, new WFSSchema.WFSAttribute("service", XSISimpleTypes.String.getInstance(), 2){

            @Override
            public String getFixed() {
                return "WFS";
            }
        }, new WFSSchema.WFSAttribute("handle", XSISimpleTypes.String.getInstance(), 0), new WFSSchema.WFSAttribute("outputFormat", XSISimpleTypes.String.getInstance(), 0, "GML2"), new WFSSchema.WFSAttribute("maxFeatures", XSISimpleTypes.PositiveInteger.getInstance(), 0)};

        GetFeatureWithLockType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return attrs;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            throw new SAXNotSupportedException("");
        }

        @Override
        public String getName() {
            return "GetFeatureWithLockType";
        }

        @Override
        public Class getInstanceType() {
            return Query.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            if (element.getType() != null && this.getName().equals(element.getType().getName())) {
                return value == null || value instanceof Query;
            }
            return false;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            AttributesImpl attributes;
            if (this.canEncode(element, value, hints)) {
                String lockId;
                attributes = new AttributesImpl();
                attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[0].getName(), null, "string", attrs[0].getFixed());
                attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[1].getName(), null, "string", attrs[1].getFixed());
                attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[2].getName(), null, "string", attrs[3].getDefault());
                Query query = (Query)value;
                if (query != null && query.getMaxFeatures() != Integer.MAX_VALUE) {
                    attributes.addAttribute(WFSSchema.NAMESPACE.toString(), elems[3].getName(), null, "integer", "" + query.getMaxFeatures());
                }
                if (hints != null && (lockId = (String)hints.get("WFSBasicComplexTypes.LOCKID.KEY")) != null) {
                    attributes.addAttribute(WFSSchema.NAMESPACE.toString(), elems[2].getName(), null, "string", lockId);
                }
            } else {
                throw new OperationNotSupportedException("not a valid value/element for a DescribeFeatureTypeType.");
            }
            output.startElement(element.getNamespace(), element.getName(), attributes);
            elems[0].getType().encode(elems[0], value, output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    static class TransactionType
    extends WFSSchema.WFSComplexType {
        private static final WFSSchema.WFSComplexType instance = new TransactionType();
        private static Element[] elems = new Element[]{new WFSSchema.WFSElement("LockId", XSISimpleTypes.String.getInstance(), 0, 1, false, null), new WFSSchema.WFSElement("Insert", InsertElementType.getInstance()), new WFSSchema.WFSElement("Update", UpdateElementType.getInstance()), new WFSSchema.WFSElement("Delete", DeleteElementType.getInstance()), new WFSSchema.WFSElement("Native", NativeType.getInstance())};
        private static Sequence child = new SequenceGT(new ElementGrouping[]{elems[0], new ChoiceGT(null, 0, Integer.MAX_VALUE, new Element[]{elems[1], elems[2], elems[3], elems[4]})});
        private static Attribute[] attrs = new Attribute[]{new WFSSchema.WFSAttribute("version", XSISimpleTypes.String.getInstance(), 2){

            @Override
            public String getFixed() {
                return "1.0.0";
            }
        }, new WFSSchema.WFSAttribute("service", XSISimpleTypes.String.getInstance(), 2){

            @Override
            public String getFixed() {
                return "WFS";
            }
        }, new WFSSchema.WFSAttribute("handle", XSISimpleTypes.String.getInstance(), 0), new WFSSchema.WFSAttribute("lockAction", AllSomeType.getInstance(), 0)};

        TransactionType() {
        }

        public static WFSSchema.WFSComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return attrs;
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            throw new SAXNotSupportedException("");
        }

        @Override
        public String getName() {
            return "TransactionType";
        }

        @Override
        public Class getInstanceType() {
            return WFSTransactionState.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map hints) {
            return element != null && element.getType() != null && this.getName().equals(element.getType().getName()) && value != null && value instanceof WFSTransactionState;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                throw new IOException("Cannot encode");
            }
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[0].getName(), null, "string", attrs[0].getFixed());
            attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[1].getName(), null, "string", attrs[1].getFixed());
            attributes.addAttribute(WFSSchema.NAMESPACE.toString(), attrs[3].getName(), null, "string", "ALL");
            String handle = (String)hints.get("handle");
            if (handle != null) {
                attributes.addAttribute(WFSSchema.NAMESPACE.toASCIIString(), "handle", null, "string", handle);
            }
            WFSTransactionState transactionRequest = (WFSTransactionState)value;
            output.startElement(element.getNamespace(), element.getName(), attributes);
            if (transactionRequest.getLockId() != null) {
                elems[0].getType().encode(elems[0], transactionRequest.getLockId(), output, hints);
            }
            block5: for (Action a : transactionRequest.getAllActions()) {
                switch (a.getType()) {
                    case 4: {
                        elems[3].getType().encode(elems[3], a, output, hints);
                        continue block5;
                    }
                    case 1: {
                        elems[1].getType().encode(elems[1], a, output, hints);
                        continue block5;
                    }
                    case 2: {
                        elems[2].getType().encode(elems[2], a, output, hints);
                        continue block5;
                    }
                }
                elems[4].getType().encode(elems[4], a, output, hints);
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }
}

