/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.protocol.wfs;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import org.eclipse.emf.ecore.EObject;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.protocol.wfs.WFSResponse;
import org.geotools.data.wfs.protocol.wfs.WFSResponseParser;
import org.geotools.data.wfs.protocol.wfs.WFSResponseParserFactory;
import org.geotools.data.wfs.v1_1_0.WFS_1_1_0_DataStore;
import org.geotools.factory.FactoryNotFoundException;

public class WFSExtensions {
    private static Set<WFSResponseParserFactory> registry;

    public static Object process(WFS_1_1_0_DataStore wfs, WFSResponse response) throws IOException {
        EObject originatingRequest = response.getOriginatingRequest();
        WFSResponseParserFactory pf = WFSExtensions.findParserFactory(originatingRequest);
        WFSResponseParser parser = pf.createParser(wfs, response);
        Object result = parser.parse(wfs, response);
        return result;
    }

    static WFSResponseParserFactory findParserFactory(EObject request) {
        Iterator<WFSResponseParserFactory> serviceProviders = WFSExtensions.getServiceProviders();
        while (serviceProviders.hasNext()) {
            WFSResponseParserFactory factory = serviceProviders.next();
            if (!factory.isAvailable() || !factory.canProcess(request)) continue;
            return factory;
        }
        throw new FactoryNotFoundException("Can't find a response parser factory for " + request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Iterator<WFSResponseParserFactory> getServiceProviders() {
        if (registry != null) return registry.iterator();
        Class<WFSExtensions> clazz = WFSExtensions.class;
        synchronized (WFSExtensions.class) {
            if (registry != null) return registry.iterator();
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader tempClassLoader = WFSDataStore.class.getClassLoader();
                Thread.currentThread().setContextClassLoader(tempClassLoader);
                Iterator<WFSResponseParserFactory> providers = ServiceRegistry.lookupProviders(WFSResponseParserFactory.class);
                registry = new HashSet<WFSResponseParserFactory>();
                while (providers.hasNext()) {
                    WFSResponseParserFactory provider = providers.next();
                    registry.add(provider);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry.iterator();
        }
    }
}

