/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.wmsc.basic;

import java.io.IOException;
import net.refractions.udig.catalog.wmsc.server.TileSet;
import net.refractions.udig.catalog.wmsc.server.TiledWebMapServer;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderMetricsFactory;
import net.refractions.udig.project.render.IRenderer;
import net.refractions.udig.render.internal.wmsc.basic.BasicWMSCRenderMetrics;
import net.refractions.udig.render.internal.wmsc.basic.BasicWMSCRenderer;
import net.refractions.udig.render.wms.basic.WMSPlugin;
import org.geotools.data.wms.WebMapServer;

public class BasicWMSCMetricsFactory
implements IRenderMetricsFactory {
    public boolean canRender(IRenderContext context) throws IOException {
        if (context.getLayer().hasResource(TiledWebMapServer.class)) {
            return true;
        }
        return context.getLayer().hasResource(TileSet.class) && context.getLayer().hasResource(WebMapServer.class);
    }

    public AbstractRenderMetrics createMetrics(IRenderContext context) {
        TileSet tileset = null;
        try {
            tileset = (TileSet)context.getLayer().getResource(TileSet.class, null);
        }
        catch (IOException e) {
            WMSPlugin.log("Cannot create render metrics from wmsc", e);
        }
        return new BasicWMSCRenderMetrics(context, this, tileset);
    }

    public Class<? extends IRenderer> getRendererType() {
        return BasicWMSCRenderer.class;
    }
}

