/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.stream.NcStreamProto;

public class NcStream {
    static final byte[] MAGIC_START = new byte[]{67, 68, 70, 83};
    static final byte[] MAGIC_HEADER = new byte[]{-83, -20, -50, -38};
    static final byte[] MAGIC_DATA = new byte[]{-85, -20, -50, -70};

    static NcStreamProto.Group.Builder encodeGroup(Group g, int sizeToCache) throws IOException {
        NcStreamProto.Group.Builder groupBuilder = NcStreamProto.Group.newBuilder();
        groupBuilder.setName(g.getShortName());
        for (Dimension dim : g.getDimensions()) {
            groupBuilder.addDims(NcStream.encodeDim(dim));
        }
        for (Attribute att : g.getAttributes()) {
            groupBuilder.addAtts(NcStream.encodeAtt(att));
        }
        for (Variable var : g.getVariables()) {
            if (var instanceof Structure) {
                groupBuilder.addStructs(NcStream.encodeStructure((Structure)var));
                continue;
            }
            groupBuilder.addVars(NcStream.encodeVar(var, sizeToCache));
        }
        return groupBuilder;
    }

    static NcStreamProto.Attribute.Builder encodeAtt(Attribute att) {
        NcStreamProto.Attribute.Builder attBuilder = NcStreamProto.Attribute.newBuilder();
        attBuilder.setName(att.getName());
        attBuilder.setType(NcStream.encodeAttributeType(att.getDataType()));
        attBuilder.setLen(att.getLength());
        attBuilder.setData(NcStream.getAttData(att));
        return attBuilder;
    }

    static NcStreamProto.Dimension.Builder encodeDim(Dimension dim) {
        NcStreamProto.Dimension.Builder dimBuilder = NcStreamProto.Dimension.newBuilder();
        dimBuilder.setName(dim.getName());
        dimBuilder.setLength(dim.getLength());
        if (!dim.isShared()) {
            dimBuilder.setIsPrivate(true);
        }
        if (dim.isVariableLength()) {
            dimBuilder.setIsVlen(true);
        }
        if (dim.isUnlimited()) {
            dimBuilder.setIsUnlimited(true);
        }
        return dimBuilder;
    }

    static NcStreamProto.Variable.Builder encodeVar(Variable var, int sizeToCache) throws IOException {
        NcStreamProto.Variable.Builder builder = NcStreamProto.Variable.newBuilder();
        builder.setName(var.getShortName());
        builder.setDataType(NcStream.encodeDataType(var.getDataType()));
        for (Dimension dim : var.getDimensions()) {
            builder.addShape(NcStream.encodeDim(dim));
        }
        for (Attribute att : var.getAttributes()) {
            builder.addAtts(NcStream.encodeAtt(att));
        }
        if (var.isCaching() && (var.isCoordinateVariable() || var.getSize() * (long)var.getElementSize() < (long)sizeToCache)) {
            Array data = var.read();
            ByteBuffer bb = data.getDataAsByteBuffer();
            builder.setData(new ByteString(bb.array()));
        }
        return builder;
    }

    static NcStreamProto.Structure.Builder encodeStructure(Structure s) throws IOException {
        NcStreamProto.Structure.Builder builder = NcStreamProto.Structure.newBuilder();
        builder.setName(s.getShortName());
        builder.setDataType(NcStream.encodeDataType(s.getDataType()));
        for (Dimension dim : s.getDimensions()) {
            builder.addShape(NcStream.encodeDim(dim));
        }
        for (Attribute att : s.getAttributes()) {
            builder.addAtts(NcStream.encodeAtt(att));
        }
        for (Variable v : s.getVariables()) {
            if (v instanceof Structure) {
                builder.addStructs(NcStream.encodeStructure((Structure)v));
                continue;
            }
            builder.addVars(NcStream.encodeVar(v, -1));
        }
        return builder;
    }

    static NcStreamProto.Data encodeDataProto(Variable var, Section section) {
        NcStreamProto.Data.Builder builder = NcStreamProto.Data.newBuilder();
        builder.setVarName(var.getName());
        builder.setDataType(NcStream.encodeDataType(var.getDataType()));
        builder.setSection(NcStream.encodeSection(section));
        return builder.build();
    }

    public static NcStreamProto.Section encodeSection(Section section) {
        NcStreamProto.Section.Builder sbuilder = NcStreamProto.Section.newBuilder();
        for (Range r : section.getRanges()) {
            NcStreamProto.Range.Builder rbuilder = NcStreamProto.Range.newBuilder();
            rbuilder.setSize(r.length());
            sbuilder.addRange(rbuilder);
        }
        return sbuilder.build();
    }

    static void show(NcStreamProto.Header proto) throws InvalidProtocolBufferException {
        NcStreamProto.Group root = proto.getRoot();
        for (NcStreamProto.Dimension dim : root.getDimsList()) {
            System.out.println("dim= " + dim);
        }
        for (NcStreamProto.Attribute att : root.getAttsList()) {
            System.out.println("att= " + att);
        }
        for (NcStreamProto.Variable var : root.getVarsList()) {
            System.out.println("var= " + var);
        }
    }

    static ByteString getAttData(Attribute att) {
        if (att.getDataType().isString()) {
            String val = att.getStringValue();
            return ByteString.copyFromUtf8(val);
        }
        Array data = att.getValues();
        ByteBuffer bb = data.getDataAsByteBuffer();
        return new ByteString(bb.array());
    }

    static int writeByte(OutputStream out, byte b) throws IOException {
        out.write(b);
        return 1;
    }

    static int writeBytes(OutputStream out, byte[] b, int offset, int length) throws IOException {
        out.write(b, offset, length);
        return length;
    }

    static int writeBytes(OutputStream out, byte[] b) throws IOException {
        return NcStream.writeBytes(out, b, 0, b.length);
    }

    public static int writeVInt(OutputStream out, int i) throws IOException {
        int count = 0;
        while ((i & 0xFFFFFF80) != 0) {
            NcStream.writeByte(out, (byte)(i & 0x7F | 0x80));
            i >>>= 7;
            ++count;
        }
        NcStream.writeByte(out, (byte)i);
        return count + 1;
    }

    static int writeVLong(OutputStream out, long i) throws IOException {
        int count = 0;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            NcStream.writeByte(out, (byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
            ++count;
        }
        NcStream.writeByte(out, (byte)i);
        return count + 1;
    }

    public static int readVInt(InputStream is) throws IOException {
        byte b = (byte)is.read();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = (byte)is.read();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public static int readFully(InputStream is, byte[] b) throws IOException {
        int bytesRead;
        int done = 0;
        for (int want = b.length; want > 0 && (bytesRead = is.read(b, done, want)) != -1; want -= bytesRead) {
            done += bytesRead;
        }
        return done;
    }

    static boolean readAndTest(InputStream is, byte[] test) throws IOException {
        byte[] b = new byte[test.length];
        is.read(b);
        if (b.length != test.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == test[i]) continue;
            return false;
        }
        return true;
    }

    static Dimension decodeDim(NcStreamProto.Dimension dim) {
        return new Dimension(dim.getName(), dim.getLength(), !dim.getIsPrivate(), dim.getIsUnlimited(), dim.getIsVlen());
    }

    static Attribute decodeAtt(NcStreamProto.Attribute att) {
        ByteString bs = att.getData();
        if (att.getType() == NcStreamProto.Attribute.Type.STRING) {
            return new Attribute(att.getName(), bs.toStringUtf8());
        }
        ByteBuffer bb = ByteBuffer.wrap(bs.toByteArray());
        return new Attribute(att.getName(), Array.factory(NcStream.decodeAttributeType(att.getType()), null, bb));
    }

    static Variable decodeVar(NetcdfFile ncfile, Group g, Structure parent, NcStreamProto.Variable var) {
        Variable ncvar = new Variable(ncfile, g, parent, var.getName());
        DataType varType = NcStream.decodeDataType(var.getDataType());
        ncvar.setDataType(NcStream.decodeDataType(var.getDataType()));
        StringBuilder sbuff = new StringBuilder();
        for (NcStreamProto.Dimension dim : var.getShapeList()) {
            sbuff.append(dim.getName());
            sbuff.append(" ");
        }
        ncvar.setDimensions(sbuff.toString());
        for (NcStreamProto.Attribute att : var.getAttsList()) {
            ncvar.addAttribute(NcStream.decodeAtt(att));
        }
        if (var.hasData()) {
            ByteBuffer bb = ByteBuffer.wrap(var.getData().toByteArray());
            Array data = Array.factory(varType, ncvar.getShape(), bb);
            ncvar.setCachedData(data, false);
        }
        return ncvar;
    }

    static Structure decodeStructure(NetcdfFile ncfile, Group g, Structure parent, NcStreamProto.Structure s) {
        Structure ncvar = s.getDataType() == NcStreamProto.DataType.SEQUENCE ? new Sequence(ncfile, g, parent, s.getName()) : new Structure(ncfile, g, parent, s.getName());
        ncvar.setDataType(NcStream.decodeDataType(s.getDataType()));
        StringBuilder sbuff = new StringBuilder();
        for (NcStreamProto.Dimension dim : s.getShapeList()) {
            sbuff.append(dim.getName());
            sbuff.append(" ");
        }
        ncvar.setDimensions(sbuff.toString());
        for (NcStreamProto.Attribute att : s.getAttsList()) {
            ncvar.addAttribute(NcStream.decodeAtt(att));
        }
        for (NcStreamProto.Variable vp : s.getVarsList()) {
            ncvar.addMemberVariable(NcStream.decodeVar(ncfile, g, ncvar, vp));
        }
        for (NcStreamProto.Structure sp : s.getStructsList()) {
            ncvar.addMemberVariable(NcStream.decodeStructure(ncfile, g, ncvar, sp));
        }
        return ncvar;
    }

    public static Section decodeSection(NcStreamProto.Section proto) {
        Section section = new Section();
        for (NcStreamProto.Range pr : proto.getRangeList()) {
            try {
                section.appendRange((int)pr.getStart(), (int)(pr.getStart() + pr.getSize() - 1L));
            }
            catch (InvalidRangeException e) {
                throw new RuntimeException(e);
            }
        }
        return section;
    }

    static NcStreamProto.Attribute.Type encodeAttributeType(DataType dtype) {
        switch (dtype) {
            case CHAR: 
            case STRING: {
                return NcStreamProto.Attribute.Type.STRING;
            }
            case BYTE: {
                return NcStreamProto.Attribute.Type.BYTE;
            }
            case SHORT: {
                return NcStreamProto.Attribute.Type.SHORT;
            }
            case INT: {
                return NcStreamProto.Attribute.Type.INT;
            }
            case LONG: {
                return NcStreamProto.Attribute.Type.LONG;
            }
            case FLOAT: {
                return NcStreamProto.Attribute.Type.FLOAT;
            }
            case DOUBLE: {
                return NcStreamProto.Attribute.Type.DOUBLE;
            }
        }
        throw new IllegalStateException("illegal att type " + (Object)((Object)dtype));
    }

    public static NcStreamProto.DataType encodeDataType(DataType dtype) {
        switch (dtype) {
            case CHAR: {
                return NcStreamProto.DataType.CHAR;
            }
            case BYTE: {
                return NcStreamProto.DataType.BYTE;
            }
            case SHORT: {
                return NcStreamProto.DataType.SHORT;
            }
            case INT: {
                return NcStreamProto.DataType.INT;
            }
            case LONG: {
                return NcStreamProto.DataType.LONG;
            }
            case FLOAT: {
                return NcStreamProto.DataType.FLOAT;
            }
            case DOUBLE: {
                return NcStreamProto.DataType.DOUBLE;
            }
            case STRING: {
                return NcStreamProto.DataType.STRING;
            }
            case STRUCTURE: {
                return NcStreamProto.DataType.STRUCTURE;
            }
            case SEQUENCE: {
                return NcStreamProto.DataType.SEQUENCE;
            }
        }
        throw new IllegalStateException("illegal data type " + (Object)((Object)dtype));
    }

    static DataType decodeAttributeType(NcStreamProto.Attribute.Type dtype) {
        switch (dtype) {
            case STRING: {
                return DataType.STRING;
            }
            case BYTE: {
                return DataType.BYTE;
            }
            case SHORT: {
                return DataType.SHORT;
            }
            case INT: {
                return DataType.INT;
            }
            case LONG: {
                return DataType.LONG;
            }
            case FLOAT: {
                return DataType.FLOAT;
            }
            case DOUBLE: {
                return DataType.DOUBLE;
            }
        }
        throw new IllegalStateException("illegal att type " + (Object)((Object)dtype));
    }

    public static DataType decodeDataType(NcStreamProto.DataType dtype) {
        switch (dtype) {
            case CHAR: {
                return DataType.CHAR;
            }
            case BYTE: {
                return DataType.BYTE;
            }
            case SHORT: {
                return DataType.SHORT;
            }
            case INT: {
                return DataType.INT;
            }
            case LONG: {
                return DataType.LONG;
            }
            case FLOAT: {
                return DataType.FLOAT;
            }
            case DOUBLE: {
                return DataType.DOUBLE;
            }
            case STRING: {
                return DataType.STRING;
            }
            case STRUCTURE: {
                return DataType.STRUCTURE;
            }
            case SEQUENCE: {
                return DataType.SEQUENCE;
            }
        }
        throw new IllegalStateException("illegal data type " + (Object)((Object)dtype));
    }
}

