/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.misc;

import java.io.IOException;
import java.nio.ByteBuffer;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Nldn
extends AbstractIOServiceProvider {
    private static final String MAGIC = "NLDN";
    private Structure seq;
    private StructureMembers sm;
    private static final int recHeader = 84;
    private static final int recSize = 28;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        int n = MAGIC.length();
        byte[] b = new byte[n];
        raf.read(b);
        String got = new String(b);
        return got.equals(MAGIC);
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.raf = raf;
        this.seq = new Sequence(ncfile, null, null, "record");
        ncfile.addVariable(null, this.seq);
        Variable v = new Variable(ncfile, null, this.seq, "tsec");
        v.setDataType(DataType.INT);
        v.setDimensions("");
        v.addAttribute(new Attribute("long_name", "date of strike"));
        v.addAttribute(new Attribute("units", "seconds since 1970-01-01 00:00:00"));
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        this.seq.addMemberVariable(v);
        v = new Variable(ncfile, null, this.seq, "nsec");
        v.setDataType(DataType.INT);
        v.setDimensions("");
        v.addAttribute(new Attribute("long_name", "nanoseconds since tsec"));
        v.addAttribute(new Attribute("units", "1.0e-9 s"));
        this.seq.addMemberVariable(v);
        v = new Variable(ncfile, null, this.seq, "lat");
        v.setDataType(DataType.INT);
        v.setDimensions("");
        v.addAttribute(new Attribute("long_name", "latitude"));
        v.addAttribute(new Attribute("units", "degrees_north"));
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        v.addAttribute(new Attribute("scale_factor", new Float(0.001)));
        this.seq.addMemberVariable(v);
        v = new Variable(ncfile, null, this.seq, "lon");
        v.setDataType(DataType.INT);
        v.setDimensions("");
        v.addAttribute(new Attribute("long_name", "longitude"));
        v.addAttribute(new Attribute("units", "degrees_east"));
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        v.addAttribute(new Attribute("scale_factor", new Float(0.001)));
        this.seq.addMemberVariable(v);
        v = new Variable(ncfile, null, this.seq, "signal");
        v.setDataType(DataType.SHORT);
        v.setDimensions("");
        v.addAttribute(new Attribute("long_name", "signal strength * 10 [150 NLDN measures ~= 30 kAmps]"));
        v.addAttribute(new Attribute("units", ""));
        this.seq.addMemberVariable(v);
        v = new Variable(ncfile, null, this.seq, "multiplicity");
        v.setDataType(DataType.BYTE);
        v.setDimensions("");
        v.addAttribute(new Attribute("long_name", "multiplicity [#strokes per flash]"));
        v.addAttribute(new Attribute("units", ""));
        this.seq.addMemberVariable(v);
        v = new Variable(ncfile, null, this.seq, "fill");
        v.setDataType(DataType.BYTE);
        v.setDimensions("");
        this.seq.addMemberVariable(v);
        v = new Variable(ncfile, null, this.seq, "semimaj");
        v.setDataType(DataType.BYTE);
        v.setDimensions("");
        v.addAttribute(new Attribute("long_name", "semi-major axis"));
        v.addAttribute(new Attribute("units", ""));
        this.seq.addMemberVariable(v);
        v = new Variable(ncfile, null, this.seq, "eccent");
        v.setDataType(DataType.BYTE);
        v.setDimensions("");
        v.addAttribute(new Attribute("long_name", "eccentricity"));
        v.addAttribute(new Attribute("units", ""));
        this.seq.addMemberVariable(v);
        v = new Variable(ncfile, null, this.seq, "angle");
        v.setDataType(DataType.BYTE);
        v.setDimensions("");
        v.addAttribute(new Attribute("long_name", "ellipse angle"));
        v.addAttribute(new Attribute("units", ""));
        this.seq.addMemberVariable(v);
        v = new Variable(ncfile, null, this.seq, "chisqr");
        v.setDataType(DataType.BYTE);
        v.setDimensions("");
        v.addAttribute(new Attribute("long_name", "chi-square"));
        v.addAttribute(new Attribute("units", ""));
        this.seq.addMemberVariable(v);
        ncfile.addAttribute(null, new Attribute("title", "NLDN Lightning Data"));
        ncfile.addAttribute(null, new Attribute("history", "Read directly by Netcdf Java IOSP"));
        ncfile.addAttribute(null, new Attribute("Conventions", "CF-1"));
        ncfile.addAttribute(null, new Attribute("CFfeatureType", "point"));
        ncfile.finish();
        this.sm = this.seq.makeStructureMembers();
        this.sm.findMember("tsec").setDataParam(0);
        this.sm.findMember("nsec").setDataParam(4);
        this.sm.findMember("lat").setDataParam(8);
        this.sm.findMember("lon").setDataParam(12);
        this.sm.findMember("signal").setDataParam(18);
        this.sm.findMember("multiplicity").setDataParam(22);
        this.sm.findMember("fill").setDataParam(23);
        this.sm.findMember("semimaj").setDataParam(24);
        this.sm.findMember("eccent").setDataParam(25);
        this.sm.findMember("angle").setDataParam(26);
        this.sm.findMember("chisqr").setDataParam(27);
        this.sm.setStructureSize(28);
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        return new ArraySequence(this.sm, new SeqIter(), 0);
    }

    public StructureDataIterator getStructureIterator(Structure s, int bufferSize) throws IOException {
        return new SeqIter();
    }

    private class SeqIter
    implements StructureDataIterator {
        private int done = 0;
        private int alreadyRead = 0;
        private int nextIndex = 0;
        private ArrayStructureBB asbb = null;
        private long totalBytes;
        private long bytesRead;

        SeqIter() throws IOException {
            this.totalBytes = (int)Nldn.this.raf.length();
            Nldn.this.raf.seek(0L);
        }

        public StructureDataIterator reset() {
            this.done = 0;
            this.alreadyRead = 0;
            this.bytesRead = 0L;
            this.nextIndex = 0;
            try {
                Nldn.this.raf.seek(0L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this;
        }

        public boolean hasNext() throws IOException {
            if (this.done < this.alreadyRead) {
                return true;
            }
            return this.readHeader();
        }

        public StructureData next() throws IOException {
            ++this.done;
            return this.asbb.getStructureData(this.nextIndex++);
        }

        private boolean readHeader() throws IOException {
            if (this.bytesRead + 84L > this.totalBytes) {
                return false;
            }
            byte[] b = new byte[84];
            Nldn.this.raf.readFully(b);
            this.bytesRead += 84L;
            ByteBuffer bb = ByteBuffer.wrap(b);
            int count = bb.getInt(8);
            if (count == 0) {
                return this.readHeader();
            }
            if (this.bytesRead + (long)(count * 28) > this.totalBytes) {
                return false;
            }
            byte[] data = new byte[count * 28];
            Nldn.this.raf.read(data);
            this.bytesRead += (long)(count * 28);
            this.alreadyRead += count;
            this.nextIndex = 0;
            ByteBuffer bbdata = ByteBuffer.wrap(data);
            this.asbb = new ArrayStructureBB(Nldn.this.sm, new int[]{count}, bbdata, 0);
            return true;
        }

        public void setBufferSize(int bytes) {
        }
    }
}

