/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import ucar.unidata.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareTableD {
    String bmt = "file:C:\\docs\\bufr\\britishMet\\WORKING\\bufr\\Code Tables 2007\\edited/BUFR_Tab_D_6.xml";
    String robbt = "C:\\dev\\tds\\bufr\\resources\\resources\\source\\wmo\\verified\\B4M-000-013-D";
    String robbxml = "file:C:\\dev\\tds\\bufr\\resources\\resources\\source\\wmo\\xml/B4M-000-013-D.xml";
    static Map<Integer, Sequence> bmTable = new TreeMap<Integer, Sequence>();
    static Map<Integer, Sequence> map = new TreeMap<Integer, Sequence>();

    public void readBmt() throws IOException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(this.bmt);
            Element root = doc.getRootElement();
            int count = this.makeBmtTable(root.getChildren("featureCatalogue"));
            System.out.println(" bmt count= " + count);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int makeBmtTable(List<Element> featureCatList) {
        int count = 0;
        for (Element featureCat : featureCatList) {
            List featureCollectList = featureCat.getChildren("featureCollection");
            count += featureCollectList.size();
            for (Element featureCollect : featureCollectList) {
                int f = Integer.parseInt(featureCollect.getChildText("F"));
                int x = Integer.parseInt(featureCollect.getChildText("X"));
                int y = Integer.parseInt(featureCollect.getChildText("Y"));
                String name = featureCollect.getChild("annotation").getChildTextNormalize("documentation");
                int fxy = (f << 16) + (x << 8) + y;
                Sequence seq = new Sequence(fxy, name);
                bmTable.put(fxy, seq);
                List features = featureCollect.getChildren("feature");
                for (Element feature : features) {
                    f = Integer.parseInt(feature.getChildText("F"));
                    x = Integer.parseInt(feature.getChildText("X"));
                    y = Integer.parseInt(feature.getChildText("Y"));
                    name = feature.getChild("annotation").getChildTextNormalize("documentation");
                    fxy = (f << 16) + (x << 8) + y;
                    Feature feat = new Feature(fxy, name);
                    seq.features.add(feat);
                }
            }
        }
        return count;
    }

    String clean(String s) {
        return StringUtil.remove(s, 32);
    }

    public void readTable() throws IOException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(this.robbxml);
            Element root = doc.getRootElement();
            int count = this.makeTable(root.getChildren("sequence"));
            System.out.println(" robb count= " + count);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int makeTable(List<Element> seqList) {
        int count = 0;
        for (Element seqElem : seqList) {
            int f = Integer.parseInt(seqElem.getAttributeValue("F"));
            int x = Integer.parseInt(seqElem.getAttributeValue("X"));
            int y = Integer.parseInt(seqElem.getAttributeValue("Y"));
            String name = "";
            int fxy = (f << 16) + (x << 8) + y;
            Sequence seq = new Sequence(fxy, name);
            map.put(fxy, seq);
            List elemList = seqElem.getChildren("element");
            for (Element elem : elemList) {
                f = Integer.parseInt(elem.getAttributeValue("F"));
                x = Integer.parseInt(elem.getAttributeValue("X"));
                y = Integer.parseInt(elem.getAttributeValue("Y"));
                name = elem.getChildTextNormalize("name");
                fxy = (f << 16) + (x << 8) + y;
                Feature feat = new Feature(fxy, name);
                seq.features.add(feat);
            }
            ++count;
        }
        return count;
    }

    public void compare(Map<Integer, Sequence> thisMap, Map<Integer, Sequence> thatMap) {
        for (Integer key : thisMap.keySet()) {
            Sequence seq1 = thisMap.get(key);
            Sequence seq2 = thatMap.get(key);
            if (seq2 == null) {
                System.out.printf(" No key %s %n", this.fxy(key));
                continue;
            }
            if (seq1.features.size() != seq2.features.size()) {
                System.out.printf(" key %s size %d != %d %n", this.fxy(key), seq1.features.size(), seq2.features.size());
                continue;
            }
            for (int i = 0; i < seq1.features.size(); ++i) {
                Feature f1 = seq1.features.get(i);
                Feature f2 = seq2.features.get(i);
                if (f1.fxy == f2.fxy) continue;
                System.out.printf("  key %s feature %s != %s %n", this.fxy(key), this.fxy(f1.fxy), this.fxy(f2.fxy));
            }
        }
    }

    String fxy(int fxy) {
        int f = fxy >> 16;
        int x = (fxy & 0xFF00) >> 8;
        int y = fxy & 0xFF;
        return f + "-" + x + "-" + y;
    }

    public static void main(String[] args) throws IOException {
        CompareTableD ct = new CompareTableD();
        ct.readBmt();
        ct.readTable();
        System.out.printf("Compare britMet to ours %n", new Object[0]);
        ct.compare(bmTable, map);
        System.out.printf("%nCompare ours to britMet %n", new Object[0]);
        ct.compare(map, bmTable);
    }

    class Feature {
        int fxy;
        String name;

        Feature(int fxy, String name) {
            this.fxy = fxy;
            this.name = name.trim();
        }
    }

    class Sequence {
        int fxy;
        String name;
        List<Feature> features;

        Sequence(int fxy, String name) {
            this.fxy = fxy;
            this.name = name.trim();
            this.features = new ArrayList<Feature>(10);
        }
    }
}

