/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.nc2.iosp.bufr.BitCounterCompressed;
import ucar.nc2.iosp.bufr.BitCounterUncompressed;
import ucar.nc2.iosp.bufr.BitReader;
import ucar.nc2.iosp.bufr.BufrDataDescriptionSection;
import ucar.nc2.iosp.bufr.BufrDataSection;
import ucar.nc2.iosp.bufr.BufrIdentificationSection;
import ucar.nc2.iosp.bufr.BufrIndicatorSection;
import ucar.nc2.iosp.bufr.BufrNumbers;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.DataDescriptorTreeConstructor;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.TableLookup;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableCenters;
import ucar.unidata.io.RandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message {
    private static final Pattern wmoPattern = Pattern.compile(".*([IJ]..... ....) .*");
    public BufrIndicatorSection is;
    public BufrIdentificationSection ids;
    public BufrDataDescriptionSection dds;
    public BufrDataSection dataSection;
    private RandomAccessFile raf;
    private TableLookup lookup;
    private DataDescriptor root;
    private String header;
    private long startPos;
    private byte[] raw;
    private BitCounterUncompressed[] counterDatasets;
    private BitCounterCompressed[] counterFlds;
    private int msg_nbits;
    private String blanks = "                      ";

    public Message(RandomAccessFile raf, BufrIndicatorSection is, BufrIdentificationSection ids, BufrDataDescriptionSection dds, BufrDataSection dataSection) throws IOException {
        this.raf = raf;
        this.is = is;
        this.ids = ids;
        this.dds = dds;
        this.dataSection = dataSection;
        this.lookup = new TableLookup(is, ids);
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    public int getNumberDatasets() {
        return this.dds.getNumberDatasets();
    }

    public String getCategoryName() throws IOException {
        return this.lookup.getDataCategory(this.ids.getCategory());
    }

    public String getCategoryNo() throws IOException {
        String result = this.ids.getCategory() + "." + this.ids.getSubCategory();
        if (this.ids.getLocalSubCategory() >= 0) {
            result = result + "." + this.ids.getLocalSubCategory();
        }
        return result;
    }

    public String getCenterName() {
        String name = this.ids.getCenterId() == 7 ? TableCenters.getNCEPSubCenterName(this.ids.getSubCenterId()) : TableCenters.getCenterName(this.ids.getCenterId());
        return this.ids.getCenterId() + "." + this.ids.getSubCenterId() + " (" + name + ")";
    }

    public String getCenterNo() {
        return this.ids.getCenterId() + "." + this.ids.getSubCenterId();
    }

    public String getTableName() {
        return this.ids.getMasterTableId() + "." + this.ids.getMasterTableVersion() + "." + this.ids.getLocalTableVersion();
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    public void setStartPos(long startPos) {
        this.startPos = startPos;
    }

    public long getStartPos() {
        return this.startPos;
    }

    public void setRawBytes(byte[] raw) {
        this.raw = raw;
    }

    public byte[] getRawBytes() {
        return this.raw;
    }

    public String extractWMO() {
        Matcher matcher = wmoPattern.matcher(this.header);
        if (!matcher.matches()) {
            return "";
        }
        return matcher.group(1);
    }

    public long getMessageSize() {
        return this.is.getBufrLength();
    }

    public DataDescriptor getRootDataDescriptor() throws IOException {
        if (this.root == null) {
            this.root = new DataDescriptorTreeConstructor().factory(this.lookup, this.dds);
        }
        return this.root;
    }

    public boolean usesLocalTable() throws IOException {
        DataDescriptor root = this.getRootDataDescriptor();
        return this.usesLocalTable(root);
    }

    private boolean usesLocalTable(DataDescriptor dds) throws IOException {
        for (DataDescriptor key : dds.getSubKeys()) {
            if (key.isLocal()) {
                return true;
            }
            if (key.getSubKeys() == null || !this.usesLocalTable(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isTablesComplete() throws IOException {
        DataDescriptor root = this.getRootDataDescriptor();
        return !root.isBad;
    }

    public void showMissingFields(Formatter out) throws IOException {
        this.showMissingFields(this.dds.getDataDescriptors(), out);
    }

    private void showMissingFields(List<Short> ddsList, Formatter out) throws IOException {
        for (short fxy : ddsList) {
            TableB.Descriptor b;
            int f = (fxy & 0xC000) >> 14;
            if (f == 3) {
                List<Short> sublist = this.lookup.getDescriptorsTableD(fxy);
                if (sublist == null) {
                    out.format("%s, ", Descriptor.makeString(fxy));
                    continue;
                }
                this.showMissingFields(sublist, out);
                continue;
            }
            if (f != 0 || (b = this.lookup.getDescriptorTableB(fxy)) != null) continue;
            out.format("%s, ", Descriptor.makeString(fxy));
        }
    }

    TableLookup getTableLookup() {
        return this.lookup;
    }

    public boolean isBitCountOk() throws IOException {
        this.getRootDataDescriptor();
        int nbitsCounted = this.getTotalBits();
        int nbitsGiven = 8 * (this.dataSection.getDataLength() - 4);
        int nbytesCounted = this.getCountedDataBytes();
        int nbytesGiven = this.dataSection.getDataLength();
        return Math.abs(nbytesCounted - nbytesGiven) <= 1;
    }

    public int getCountedDataBytes() {
        int msg_nbytes = this.msg_nbits / 8;
        if (this.msg_nbits % 8 != 0) {
            ++msg_nbytes;
        }
        if ((msg_nbytes += 4) % 2 != 0) {
            ++msg_nbytes;
        }
        return msg_nbytes;
    }

    public BitCounterUncompressed getBitCounterUncompressed(int obsOffsetInMessage) {
        if (this.dds.isCompressed()) {
            throw new IllegalArgumentException("cant call BufrMessage.getBitOffset() on compressed message");
        }
        this.getTotalBits();
        return this.counterDatasets[obsOffsetInMessage];
    }

    public int getTotalBits() {
        if (this.msg_nbits == 0) {
            this.calcTotalBits(null);
        }
        return this.msg_nbits;
    }

    public int calcTotalBits(Formatter out) {
        boolean compressed = this.dds.isCompressed();
        try {
            this.getRootDataDescriptor();
            if (compressed) {
                return this.countBitsCompressed(out);
            }
            return this.countBitsUncompressed(out);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private int countBitsUncompressed(Formatter out) throws IOException {
        BitReader reader = new BitReader(this.raf, this.dataSection.getDataPos() + 4L);
        int n = this.getNumberDatasets();
        this.counterDatasets = new BitCounterUncompressed[n];
        this.msg_nbits = 0;
        for (int i = 0; i < n; ++i) {
            if (out != null) {
                out.format("Count bits in observation %d\n", i);
            }
            this.counterDatasets[i] = new BitCounterUncompressed(this.root, 1, 0);
            String where = out == null ? null : "obs " + i;
            this.countBitsUncompressed(out, reader, this.root.subKeys, this.counterDatasets[i], 0, where, 0, 1);
            this.msg_nbits += this.counterDatasets[i].countBits(this.msg_nbits);
        }
        return this.msg_nbits;
    }

    private int countBitsUncompressed(Formatter out, BitReader reader, List<DataDescriptor> dkeys, BitCounterUncompressed tc, int row, String where, int indent, int fldno) throws IOException {
        for (DataDescriptor dkey : dkeys) {
            if (!dkey.isOkForVariable()) continue;
            if (dkey.replication == 0) {
                int count = reader.bits2UInt(dkey.replicationCountSize);
                if (out != null) {
                    out.format("%4d delayed replication %d %n", fldno++, count);
                }
                if (out != null && count > 0) {
                    out.format("%4d %s read sequence %s count= %d bitSize=%d start at=0x%x %n", fldno++, this.blank(indent), dkey.getFxyName(), count, dkey.replicationCountSize, reader.getPos());
                }
                BitCounterUncompressed nested = tc.makeNested(dkey, count, row, dkey.replicationCountSize);
                for (int i = 0; i < count; ++i) {
                    String whereNested = null;
                    if (out != null) {
                        out.format("%s read row %d (seq %s) of %s %n", this.blank(indent), i, dkey.getFxyName(), where);
                        whereNested = out == null ? null : where + " row " + i + "( seq " + dkey.getFxyName() + ")";
                    }
                    fldno = this.countBitsUncompressed(out, reader, dkey.subKeys, nested, i, whereNested, indent + 2, fldno);
                }
                continue;
            }
            if (dkey.type == 3) {
                BitCounterUncompressed nested = tc.makeNested(dkey, dkey.replication, row, 0);
                if (out != null) {
                    out.format("%4d %s read structure %s count= %d\n", fldno++, this.blank(indent), dkey.getFxyName(), dkey.replication);
                }
                for (int i = 0; i < dkey.replication; ++i) {
                    if (out != null) {
                        out.format("%s read row %d (struct %s) of %s %n", this.blank(indent), i, dkey.getFxyName(), where);
                    }
                    String whereNested = out == null ? null : where + " row " + i + "( struct " + dkey.getFxyName() + ")";
                    fldno = this.countBitsUncompressed(out, reader, dkey.subKeys, nested, i, whereNested, indent + 2, fldno);
                }
                continue;
            }
            if (dkey.type == 1) {
                String val = new String(this.readCharData(dkey, reader));
                if (out == null) continue;
                out.format("%4d %s read char %s bitWidth=%d end at= 0x%x val=%s\n", fldno++, this.blank(indent), dkey.getFxyName(), dkey.bitWidth, reader.getPos(), val);
                continue;
            }
            int val = reader.bits2UInt(dkey.bitWidth);
            if (out == null) continue;
            out.format("%4d %s read %s bitWidth=%d end at= 0x%x raw=%d convert=%f\n", fldno++, this.blank(indent), dkey.getFxyName(), dkey.bitWidth, reader.getPos(), val, Float.valueOf(this.convert(dkey, val)));
        }
        return fldno;
    }

    private String blank(int indent) {
        return this.blanks.substring(0, indent + 1);
    }

    private byte[] readCharData(DataDescriptor dkey, BitReader reader) throws IOException {
        int nchars = dkey.getByteWidthCDM();
        byte[] b = new byte[nchars];
        for (int i = 0; i < nchars; ++i) {
            b[i] = (byte)reader.bits2UInt(8);
        }
        return b;
    }

    private Number readNumericData(DataDescriptor dkey, BitReader reader) throws IOException {
        int val = reader.bits2UInt(dkey.bitWidth);
        if (dkey.scale == 0) {
            return val + dkey.refVal;
        }
        return Float.valueOf(this.convert(dkey, val));
    }

    private float convert(DataDescriptor dkey, int raw) {
        float scale = (float)Math.pow(10.0, -dkey.scale);
        float fval = raw + dkey.refVal;
        return scale * fval;
    }

    private int countBitsCompressed(Formatter out) throws IOException {
        BitReader reader = new BitReader(this.raf, this.dataSection.getDataPos() + 4L);
        this.counterFlds = new BitCounterCompressed[this.root.subKeys.size()];
        this.countBitsCompressed(out, reader, this.counterFlds, 0, this.getNumberDatasets(), this.root);
        this.msg_nbits = 0;
        for (BitCounterCompressed counter : this.counterFlds) {
            if (counter == null) continue;
            this.msg_nbits += counter.getTotalBits();
        }
        return this.msg_nbits;
    }

    public BitCounterCompressed[] getCounterFlds() throws IOException {
        if (this.counterFlds == null) {
            this.countBitsCompressed(null);
        }
        return this.counterFlds;
    }

    private int countBitsCompressed(Formatter out, BitReader reader, BitCounterCompressed[] counters, int bitOffset, int n, DataDescriptor parent) throws IOException {
        for (int fldidx = 0; fldidx < parent.getSubKeys().size(); ++fldidx) {
            BitCounterCompressed counter;
            DataDescriptor dkey = parent.getSubKeys().get(fldidx);
            if (!dkey.isOkForVariable()) continue;
            counters[fldidx] = counter = new BitCounterCompressed(dkey, n, bitOffset);
            if (dkey.replication == 0) {
                reader.setBitOffset(bitOffset);
                int count = reader.bits2UInt(dkey.replicationCountSize);
                int extra = reader.bits2UInt(6);
                System.out.printf("EXTRA bits %d at %d %n", extra, bitOffset += dkey.replicationCountSize);
                if (null != out) {
                    out.format("--sequence %s bitOffset=%d replication=%s %n", dkey.getFxyName(), bitOffset, count);
                }
                bitOffset += 6;
                counter.addNestedCounters(count);
                for (int i = 0; i < count; ++i) {
                    if (null != out) {
                        out.format("%n", new Object[0]);
                    }
                    BitCounterCompressed[] nested = counter.getNestedCounters(i);
                    bitOffset = this.countBitsCompressed(out, reader, nested, bitOffset, n, dkey);
                }
                if (null == out) continue;
                out.format("--back %s %d %n", dkey.getFxyName(), bitOffset);
                continue;
            }
            if (dkey.type == 3) {
                if (null != out) {
                    out.format("--nested %s bitOffset=%d replication=%s %n", dkey.getFxyName(), bitOffset, dkey.replication);
                }
                counter.addNestedCounters(dkey.replication);
                for (int i = 0; i < dkey.replication; ++i) {
                    if (null != out) {
                        out.format("%n", new Object[0]);
                    }
                    BitCounterCompressed[] nested = counter.getNestedCounters(i);
                    bitOffset = this.countBitsCompressed(out, reader, nested, bitOffset, n, dkey);
                }
                if (null == out) continue;
                out.format("--back %s %d %n", dkey.getFxyName(), bitOffset);
                continue;
            }
            reader.setBitOffset(bitOffset);
            int dataMin = reader.bits2UInt(dkey.bitWidth);
            int dataWidth = reader.bits2UInt(6);
            if (dataWidth > dkey.bitWidth && null != out) {
                out.format(" BAD WIDTH ", new Object[0]);
            }
            if (dkey.type == 1) {
                dataWidth *= 8;
            }
            counter.setDataWidth(dataWidth);
            int totalWidth = dkey.bitWidth + 6 + dataWidth * n;
            bitOffset += totalWidth;
            if (null != out) {
                out.format("  read %s (%s) bitWidth=%d dataMin=%d dataWidth=%d n=%d bitOffset=%d %n", dkey.name, dkey.getFxyName(), dkey.bitWidth, dataMin, dataWidth, n, bitOffset);
            }
            if (null == out) continue;
            if (dataWidth > 0) {
                if (dkey.type == 1) {
                    int nchars = dataWidth / 8;
                    for (int i = 0; i < n; ++i) {
                        byte[] b = new byte[nchars];
                        for (int j = 0; j < nchars; ++j) {
                            b[j] = (byte)reader.bits2UInt(8);
                        }
                        out.format(" %s,", new String(b));
                    }
                    out.format("%n", new Object[0]);
                    continue;
                }
                double scale = Math.pow(10.0, -dkey.scale);
                for (int i = 0; i < n; ++i) {
                    int val = reader.bits2UInt(dataWidth);
                    if (val == BufrNumbers.missing_value[dataWidth]) {
                        out.format(" %d (MISSING)", val);
                        continue;
                    }
                    float fval = dataMin + val + dkey.refVal;
                    out.format(" %d (%f)", val, scale * (double)fval);
                }
                out.format("%n", new Object[0]);
                continue;
            }
            double scale = Math.pow(10.0, -dkey.scale);
            float fval = dataMin + dkey.refVal;
            out.format(" all values= %d (%f) %n", dataMin, scale * (double)fval);
        }
        return bitOffset;
    }

    public Object[][] readValues(List<Integer> indexFlds) throws IOException {
        this.getRootDataDescriptor();
        BitReader reader = new BitReader(this.raf, this.dataSection.getDataPos() + 4L);
        int n = this.getNumberDatasets();
        Object[][] result = new Object[n][indexFlds.size()];
        if (this.dds.isCompressed()) {
            this.readDataCompressed(reader, indexFlds, result);
        } else {
            this.readDataUncompressed(reader, indexFlds, result);
        }
        return result;
    }

    private void readDataCompressed(BitReader reader, List<Integer> indexFlds, Object[][] result) throws IOException {
        int nobs = this.getNumberDatasets();
        BitCounterCompressed[] bitCounter = this.getCounterFlds();
        int count = 0;
        for (int index : indexFlds) {
            if (index < 0) {
                ++count;
                continue;
            }
            DataDescriptor dkey = this.root.getSubKeys().get(index);
            BitCounterCompressed counter = bitCounter[index];
            reader.setBitOffset(counter.getStartingBitPos());
            if (dkey.type == 1) {
                int n = dkey.bitWidth / 8;
                byte[] defValue = new byte[n];
                for (int i = 0; i < n; ++i) {
                    defValue[i] = (byte)reader.bits2UInt(8);
                }
                int dataWidth = reader.bits2UInt(6);
                if (dataWidth == 0) {
                    for (int obs = 0; obs < nobs; ++obs) {
                        result[obs][count] = defValue;
                    }
                } else {
                    int nt = Math.min(n, dataWidth);
                    for (int obs = 0; obs < nobs; ++obs) {
                        byte[] bval = new byte[nt];
                        for (int i = 0; i < nt; ++i) {
                            int cval = reader.bits2UInt(8);
                            if (cval < 32 || cval > 126) continue;
                            bval[i] = (byte)cval;
                        }
                        result[obs][count] = bval;
                    }
                }
                ++count;
                continue;
            }
            int minValue = reader.bits2UInt(dkey.bitWidth);
            int dataWidth = reader.bits2UInt(6);
            for (int obs = 0; obs < nobs; ++obs) {
                int value = dataWidth > 0 ? minValue + reader.bits2UInt(dataWidth) : minValue;
                result[obs][count] = dkey.scale == 0 ? (Number)(value + dkey.refVal) : (Number)Float.valueOf(this.convert(dkey, value));
            }
            ++count;
        }
    }

    private void readDataUncompressed(BitReader reader, List<Integer> indexFlds, Object[][] result) throws IOException {
        List<DataDescriptor> dkeyList = this.root.getSubKeys();
        for (int obs = 0; obs < this.getNumberDatasets(); ++obs) {
            BitCounterUncompressed bitCounter = this.getBitCounterUncompressed(obs);
            int bitOffset = 0;
            for (int index = 0; index < dkeyList.size(); ++index) {
                DataDescriptor dkey = dkeyList.get(index);
                int count = indexFlds.indexOf(index);
                if (count >= 0) {
                    reader.setBitOffset(bitCounter.getStartBit(0) + bitOffset);
                    if (dkey.type == 0) {
                        result[obs][count] = this.readNumericData(dkey, reader);
                    } else if (dkey.type == 1) {
                        result[obs][count] = this.readCharData(dkey, reader);
                    }
                }
                bitOffset += dkey.getBitWidth();
            }
        }
    }

    public int hashCode() {
        int result = 17;
        result += 37 * result + ((Object)this.dds.getDataDescriptors()).hashCode();
        result += 37 * result + this.ids.getCenterId();
        result += 37 * result + this.ids.getCategory();
        result += 37 * result + this.ids.getSubCategory();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Message)) {
            return false;
        }
        Message o = (Message)obj;
        if (!((Object)this.dds.getDataDescriptors()).equals(o.dds.getDataDescriptors())) {
            return false;
        }
        if (this.ids.getCenterId() != o.ids.getCenterId()) {
            return false;
        }
        if (this.ids.getCategory() != o.ids.getCategory()) {
            return false;
        }
        return this.ids.getSubCategory() == o.ids.getSubCategory();
    }

    public void dump(Formatter out) throws IOException {
        out.format(" BUFR edition %d time= %s wmoHeader=%s hash=[0x%x] %n", this.is.getBufrEdition(), this.ids.getReferenceTime(), this.getHeader(), this.hashCode());
        out.format("   Category= %s %s %n", this.getCategoryNo(), this.getCategoryName());
        out.format("   Center= %s %n", this.getCenterName());
        out.format("   Table= %s wmoTable= %s localTable= %s%n", this.getTableName(), this.lookup.getWmoTableName(), this.lookup.getLocalTableName());
        out.format("  DDS nsubsets=%d type=0x%x isObs=%b isCompressed=%b\n", this.dds.getNumberDatasets(), this.dds.getDataType(), this.dds.isObserved(), this.dds.isCompressed());
        long startPos = this.is.getStartPos();
        long startData = this.dataSection.getDataPos();
        out.format("  startPos=%d len=%d endPos=%d dataStart=%d dataLen=%d dataEnd=%d %n", startPos, this.is.getBufrLength(), startPos + (long)this.is.getBufrLength(), startData, this.dataSection.getDataLength(), startData + (long)this.dataSection.getDataLength());
        this.dumpDesc(out, this.dds.getDataDescriptors(), this.lookup, 4);
        out.format("%n  CDM Nested Table=\n", new Object[0]);
        DataDescriptor root = new DataDescriptorTreeConstructor().factory(this.lookup, this.dds);
        this.dumpKeys(out, root, 4);
    }

    private void dumpDesc(Formatter out, List<Short> desc, TableLookup table, int indent) {
        if (desc == null) {
            return;
        }
        for (Short fxy : desc) {
            for (int i = 0; i < indent; ++i) {
                out.format(" ", new Object[0]);
            }
            Descriptor.show(out, fxy, table);
            out.format("%n", new Object[0]);
            int f = (fxy & 0xC000) >> 14;
            if (f != 3) continue;
            List<Short> sublist = table.getDescriptorsTableD(fxy);
            this.dumpDesc(out, sublist, table, indent + 2);
        }
    }

    private void dumpKeys(Formatter out, DataDescriptor tree, int indent) {
        for (DataDescriptor key : tree.subKeys) {
            for (int i = 0; i < indent; ++i) {
                out.format(" ", new Object[0]);
            }
            out.format("%s\n", key);
            if (key.getSubKeys() == null) continue;
            this.dumpKeys(out, key, indent + 2);
        }
    }

    public String getCategoryFullName() throws IOException {
        try {
            boolean hasSubName;
            String catName = this.lookup.getDataCategory(this.ids.getCategory());
            String subcatName = this.lookup.getSubCategory(this.ids.getCategory(), this.ids.getSubCategory());
            boolean bl = hasSubName = !subcatName.equalsIgnoreCase("Unknown");
            if (hasSubName) {
                return catName + " / " + subcatName + " (" + this.ids.getCategory() + "." + this.ids.getSubCategory() + "." + this.ids.getLocalSubCategory() + ")";
            }
            return catName + " (" + this.ids.getCategory() + "." + this.ids.getSubCategory() + "." + this.ids.getLocalSubCategory() + ")";
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("***BAD getMasterTableFilename=" + this.lookup.getWmoTableName());
            return " (" + this.ids.getCategory() + "." + this.ids.getSubCategory() + ")";
        }
    }

    public void dumpHeader(Formatter out) throws IOException {
        out.format(" BUFR edition %d time= %s wmoHeader=%s %n", this.is.getBufrEdition(), this.ids.getReferenceTime(), this.getHeader());
        out.format("   Category= %d %s %s %n", this.ids.getCategory(), this.getCategoryName(), this.getCategoryNo());
        out.format("   Center= %s %s %n", this.getCenterName(), this.getCenterNo());
        out.format("   Table= %d.%d local= %d wmoTable= %s localTable= %s %n", this.ids.getMasterTableId(), this.ids.getMasterTableVersion(), this.ids.getLocalTableVersion(), this.lookup.getWmoTableName(), this.lookup.getLocalTableName());
        out.format("  DDS nsubsets=%d type=0x%x isObs=%b isCompressed=%b\n", this.dds.getNumberDatasets(), this.dds.getDataType(), this.dds.isObserved(), this.dds.isCompressed());
    }

    public void dumpHeaderShort(Formatter out) throws IOException {
        out.format(" %s, Cat= %s, Center= %s (%s), Table= %d.%d.%d %n", this.getHeader(), this.getCategoryName(), this.getCenterName(), this.getCenterNo(), this.ids.getMasterTableId(), this.ids.getMasterTableVersion(), this.ids.getLocalTableVersion());
    }
}

