/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.util.Formatter;
import java.util.StringTokenizer;
import ucar.nc2.Structure;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class BufrCdm
extends TableConfigurerImpl {
    private final String BufrConvention = "BUFR/CDM";

    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        if (conv.equals("BUFR/CDM")) {
            return true;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equals("BUFR/CDM")) continue;
            return true;
        }
        return false;
    }

    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) {
        String ftypeS = ds.findAttValueIgnoreCase(null, "CF:featureType", null);
        CF.FeatureType ftype = ftypeS == null ? CF.FeatureType.point : CF.FeatureType.valueOf(ftypeS);
        switch (ftype) {
            case trajectory: {
                return this.getTrajectoryConfig(ds, errlog);
            }
            case stationProfile: {
                return this.getStationProfileConfig(ds, errlog);
            }
        }
        throw new IllegalStateException("invalid ftype= " + (Object)((Object)ftype));
    }

    protected TableConfig getTrajectoryConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig obsTable = new TableConfig(Table.Type.Structure, "obsRecord");
        Structure obsStruct = (Structure)ds.findVariable("obsRecord");
        obsTable.structName = obsStruct.getName();
        obsTable.nestedTableName = obsStruct.getShortName();
        obsTable.lat = Evaluator.getVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Lat.toString());
        obsTable.lon = Evaluator.getVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Lon.toString());
        obsTable.elev = Evaluator.getVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Height.toString());
        obsTable.time = Evaluator.getVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Time.toString());
        return obsTable;
    }

    protected TableConfig getStationProfileConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig stnTable = new TableConfig(Table.Type.Construct, "station");
        stnTable.featureType = FeatureType.STATION_PROFILE;
        stnTable.structName = "obsRecord";
        Structure stnStruct = (Structure)ds.findVariable("obsRecord");
        stnTable.lat = Evaluator.getVariableWithAttribute(stnStruct, "_CoordinateAxisType", AxisType.Lat.toString());
        stnTable.lon = Evaluator.getVariableWithAttribute(stnStruct, "_CoordinateAxisType", AxisType.Lon.toString());
        stnTable.stnAlt = Evaluator.getVariableWithAttribute(stnStruct, "_CoordinateAxisType", AxisType.Height.toString());
        stnTable.stnId = Evaluator.getVariableWithAttribute(stnStruct, "standard_name", "station_name");
        stnTable.stnWmoId = Evaluator.getVariableWithAttribute(stnStruct, "standard_name", "wmo_station");
        if (stnTable.stnId == null) {
            stnTable.stnId = stnTable.stnWmoId;
        }
        TableConfig timeseriesTable = new TableConfig(Table.Type.Structure, "obsRecord");
        timeseriesTable.time = Evaluator.getVariableWithAttribute(stnStruct, "_CoordinateAxisType", AxisType.Time.toString());
        timeseriesTable.structName = "obsRecord";
        stnTable.addChild(timeseriesTable);
        TableConfig obsTable = new TableConfig(Table.Type.NestedStructure, "seq1");
        Structure obsStruct = (Structure)stnStruct.findVariable("seq1");
        obsTable.structName = obsStruct.getName();
        obsTable.nestedTableName = obsStruct.getShortName();
        obsTable.elev = Evaluator.getVariableWithAttribute(obsStruct, "_CoordinateAxisType", AxisType.Height.toString());
        timeseriesTable.addChild(obsTable);
        return stnTable;
    }
}

