/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;

public class PointIteratorAdapter
implements PointFeatureIterator {
    private PointFeatureCollectionIterator fiter;
    private LatLonRect filter_bb;
    private DateRange filter_date;
    private PointFeatureIterator pfiter;
    private PointFeature pointFeature;
    private boolean done = false;

    PointIteratorAdapter(PointFeatureCollectionIterator fiter, LatLonRect filter_bb, DateRange filter_date) {
        this.fiter = fiter;
        this.filter_bb = filter_bb;
        this.filter_date = filter_date;
    }

    public void setBufferSize(int bytes) {
        this.fiter.setBufferSize(bytes);
    }

    public void cancel() {
    }

    public boolean hasNext() throws IOException {
        if (this.done) {
            return false;
        }
        this.pointFeature = this.nextFilteredDataPoint();
        if (this.pointFeature != null) {
            return true;
        }
        PointFeatureCollection feature = this.nextFilteredCollection();
        if (feature == null) {
            this.done = true;
            return false;
        }
        this.pfiter = feature.getPointFeatureIterator(-1);
        return this.hasNext();
    }

    public PointFeature next() throws IOException {
        return this.done ? null : this.pointFeature;
    }

    private PointFeatureCollection nextFilteredCollection() throws IOException {
        if (!this.fiter.hasNext()) {
            return null;
        }
        PointFeatureCollection f = this.fiter.next();
        if (this.filter_bb == null) {
            return f;
        }
        return f;
    }

    private PointFeature nextFilteredDataPoint() throws IOException {
        if (this.pfiter == null) {
            return null;
        }
        if (!this.pfiter.hasNext()) {
            return null;
        }
        PointFeature pdata = this.pfiter.next();
        if (this.filter_date == null) {
            return pdata;
        }
        while (!this.filter_date.included(pdata.getObservationTimeAsDate())) {
            if (!this.pfiter.hasNext()) {
                return null;
            }
            pdata = this.pfiter.next();
        }
        return pdata;
    }
}

