/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordTransBuilderIF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

public abstract class AbstractCoordTransBuilder
implements CoordTransBuilderIF {
    private static Logger log = LoggerFactory.getLogger(AbstractCoordTransBuilder.class);
    protected Formatter errBuffer = null;

    public void setErrorBuffer(Formatter errBuffer) {
        this.errBuffer = errBuffer;
    }

    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        throw new UnsupportedOperationException();
    }

    protected double readAttributeDouble(Variable v, String attname, double defValue) {
        Attribute att = v.findAttributeIgnoreCase(attname);
        if (att == null) {
            return defValue;
        }
        if (att.isString()) {
            return Double.parseDouble(att.getStringValue());
        }
        return att.getNumericValue().doubleValue();
    }

    protected double[] readAttributeDouble2(Attribute att) {
        if (att == null) {
            return null;
        }
        double[] val = new double[2];
        if (att.isString()) {
            StringTokenizer stoke = new StringTokenizer(att.getStringValue());
            val[0] = Double.parseDouble(stoke.nextToken());
            val[1] = stoke.hasMoreTokens() ? Double.parseDouble(stoke.nextToken()) : val[0];
        } else {
            val[0] = att.getNumericValue().doubleValue();
            val[1] = att.getLength() > 1 ? att.getNumericValue(1).doubleValue() : val[0];
        }
        return val;
    }

    protected boolean addParameter(CoordinateTransform rs, String paramName, NetcdfFile ds, String varNameEscaped) {
        if (null == ds.findVariable(varNameEscaped)) {
            if (null != this.errBuffer) {
                this.errBuffer.format("CoordTransBuilder %s: no Variable named %s\n", this.getTransformName(), varNameEscaped);
            }
            return false;
        }
        rs.addParameter(new Parameter(paramName, varNameEscaped));
        return true;
    }

    protected String getFormula(NetcdfDataset ds, Variable ctv) {
        String formula = ds.findAttValueIgnoreCase(ctv, "formula_terms", null);
        if (null == formula) {
            if (null != this.errBuffer) {
                this.errBuffer.format("CoordTransBuilder %s: needs attribute 'formula_terms' on Variable %s\n", this.getTransformName(), ctv.getName());
            }
            return null;
        }
        return formula;
    }

    public String[] parseFormula(String formula_terms, String termString) {
        String[] formulaTerms = formula_terms.split("[\\s:]+");
        String[] terms = termString.split("[\\s]+");
        String[] values = new String[terms.length];
        block0: for (int i = 0; i < terms.length; ++i) {
            for (int j = 0; j < formulaTerms.length; j += 2) {
                if (!terms[i].equals(formulaTerms[j])) continue;
                values[i] = formulaTerms[j + 1];
                continue block0;
            }
        }
        boolean ok = true;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            log.warn("Missing term=" + terms[i] + " in the formula '" + formula_terms + "' for the vertical transform= " + this.getTransformName());
            ok = false;
        }
        return ok ? values : null;
    }

    public static double getFalseEastingScaleFactor(NetcdfDataset ds, Variable ctv) {
        String units = ds.findAttValueIgnoreCase(ctv, "units", null);
        if (units == null) {
            List<CoordinateAxis> axes = ds.getCoordinateAxes();
            for (CoordinateAxis axis : axes) {
                if (axis.getAxisType() != AxisType.GeoX) continue;
                Variable v = axis.getOriginalVariable();
                units = v.getUnitsString();
                break;
            }
        }
        if (units != null) {
            try {
                SimpleUnit unit = SimpleUnit.factoryWithExceptions(units);
                return unit.convertTo(1.0, SimpleUnit.kmUnit);
            }
            catch (Exception e) {
                log.error(units + " not convertible to km");
            }
        }
        return 1.0;
    }
}

