/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.util.ArrayList;
import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.Enhancements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EnhancementsImpl
implements Enhancements {
    private Variable forVar;
    private String desc;
    private String units;
    private List<CoordinateSystem> coordSys;

    public EnhancementsImpl(Variable forVar, String units, String desc) {
        this.forVar = forVar;
        this.units = units;
        this.desc = desc;
    }

    public EnhancementsImpl(Variable forVar) {
        this.forVar = forVar;
    }

    @Override
    public List<CoordinateSystem> getCoordinateSystems() {
        return this.coordSys == null ? new ArrayList(0) : this.coordSys;
    }

    @Override
    public void addCoordinateSystem(CoordinateSystem cs) {
        if (this.coordSys == null) {
            this.coordSys = new ArrayList<CoordinateSystem>(5);
        }
        this.coordSys.add(cs);
    }

    @Override
    public void removeCoordinateSystem(CoordinateSystem p0) {
        if (this.coordSys != null) {
            this.coordSys.remove(p0);
        }
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    @Override
    public String getDescription() {
        if (this.desc == null && this.forVar != null) {
            Attribute att = this.forVar.findAttributeIgnoreCase("long_name");
            if (att != null && att.isString()) {
                this.desc = att.getStringValue().trim();
            }
            if (this.desc == null && (att = this.forVar.findAttributeIgnoreCase("description")) != null && att.isString()) {
                this.desc = att.getStringValue().trim();
            }
            if (this.desc == null && (att = this.forVar.findAttributeIgnoreCase("title")) != null && att.isString()) {
                this.desc = att.getStringValue().trim();
            }
            if (this.desc == null && (att = this.forVar.findAttributeIgnoreCase("standard_name")) != null && att.isString()) {
                this.desc = att.getStringValue().trim();
            }
        }
        return this.desc == null ? "" : this.desc;
    }

    public void setUnitsString(String units) {
        this.units = units;
        this.forVar.addAttribute(new Attribute("units", units));
    }

    @Override
    public String getUnitsString() {
        Attribute att;
        if (this.units == null && this.forVar != null && (att = this.forVar.findAttributeIgnoreCase("units")) != null && att.isString()) {
            return att.getStringValue().trim();
        }
        return this.units;
    }
}

