/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.MFile;
import ucar.nc2.units.DateFromString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MCollection {
    private static Logger logger = LoggerFactory.getLogger(MCollection.class);
    private List<MFile> list = new ArrayList<MFile>();
    private Date last = null;
    private Date first = null;
    private String dirName;

    public MCollection(String dirName, FileFilter ff, String dateFormatString) {
        File[] files;
        this.dirName = dirName;
        File dir = new File(dirName);
        for (File f : files = dir.listFiles(ff)) {
            Date d = DateFromString.getDateUsingSimpleDateFormat(f.getName(), dateFormatString);
            this.add(f, d);
        }
    }

    public String toString() {
        return this.dirName;
    }

    public List<MFile> getList() {
        return this.list;
    }

    public Date getLast() {
        return this.last;
    }

    public Date getFirst() {
        return this.first;
    }

    public void add(File file, Date d) {
        MFile m = new MFile(file);
        this.list.add(m);
        m.setAttribute("date", d);
        if (this.last == null || d.after(this.last)) {
            this.last = d;
        }
        if (this.first == null || d.before(this.first)) {
            this.first = d;
        }
    }

    public boolean remove(MFile file) {
        return this.list.remove(file);
    }
}

