/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.feature.shapefile;

import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderMetricsFactory;
import net.refractions.udig.project.render.IRenderer;
import net.refractions.udig.render.internal.feature.shapefile.ShapefileFeatureMetrics;
import net.refractions.udig.render.internal.feature.shapefile.ShapefileFeatureRenderer;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.view.DefaultView;

public class ShapefileFeatureMetricsFactory
implements IRenderMetricsFactory {
    public ShapefileFeatureMetrics createMetrics(IRenderContext context) {
        return new ShapefileFeatureMetrics(context, this);
    }

    public boolean canRender(IRenderContext context) {
        try {
            IGeoResource geoResource = context.getGeoResource();
            if (geoResource.canResolve(ShapefileDataStore.class)) {
                FeatureSource featureSource = (FeatureSource)geoResource.resolve(FeatureSource.class, null);
                boolean notAView = !(featureSource instanceof DefaultView);
                boolean isAShapefile = featureSource.getDataStore() instanceof ShapefileDataStore;
                return notAView && featureSource != null && isAShapefile;
            }
        }
        catch (Throwable throwable) {}
        return false;
    }

    public Class<? extends IRenderer> getRendererType() {
        return ShapefileFeatureRenderer.class;
    }
}

