/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.style.ui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.project.ILayerListener;
import net.refractions.udig.project.LayerEvent;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.style.IStyleConfigurator;
import net.refractions.udig.style.StylePlugin;
import net.refractions.udig.style.internal.Messages;
import net.refractions.udig.style.internal.StyleLayer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;

public class StyleView
extends ViewPart {
    public static final String VIEW_ID = "net.refractions.udig.style.styleView";
    private static final String STYLE_MENU_GROUP = "style";
    private static final String CONFIG_MENU_GROUP = "config";
    private static final String CHOOSER_MENU_GROUP = "chooser";
    Combo configChooser;
    PageBook book;
    Label pleaseSelectLayer;
    private Action applyAction;
    private Action cancelAction;
    private StyleLayer currentLayer;
    List<StyleViewSite> sites;
    private IStyleConfigurator currentConfig;
    private ISelectionListener workbenchWatcher = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part == StyleView.this) {
                return;
            }
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection sselection = (IStructuredSelection)selection;
                for (Object obj : sselection) {
                    if (!(obj instanceof Layer)) continue;
                    Layer layer = (Layer)obj;
                    StyleView.this.setCurrentLayer(layer);
                    return;
                }
            }
        }
    };
    SelectionListener chooserListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StyleView.this.configChooser != null && StyleView.this.configChooser.getSelectionIndex() > -1) {
                int index = StyleView.this.configChooser.getSelectionIndex();
                IStyleConfigurator config = new ArrayList<IStyleConfigurator>(StyleView.this.getStyleConfigurators()).get(index);
                StyleView.this.setStyleConfigurator(config);
                return;
            }
            StyleView.this.book.showPage((Control)StyleView.this.pleaseSelectLayer);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    ILayerListener layerListener = new ILayerListener(){

        public void refresh(LayerEvent event) {
            StyleView.this.refresh();
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (this.sites != null) {
            throw new IllegalStateException("StyleView init called twice!");
        }
        this.sites = new ArrayList<StyleViewSite>();
        ExtensionPointUtil.process((Plugin)StylePlugin.getDefault(), (String)"net.refractions.udig.style.styleConfigurator", (ExtensionPointProcessor)new ExtensionPointProcessor(){

            public void process(IExtension extension, IConfigurationElement element) throws Exception {
                IStyleConfigurator config = (IStyleConfigurator)element.createExecutableExtension("class");
                String id = element.getAttribute("styleId");
                String label = element.getAttribute("label");
                config.setStyleId(id);
                config.setLabel(label);
                StyleViewSite styleSite = new StyleViewSite(extension, element, config);
                try {
                    config.init(styleSite);
                    StyleView.this.sites.add(styleSite);
                }
                catch (Exception e) {
                    Status status = new Status(4, element.getNamespaceIdentifier(), 0, null, (Throwable)e);
                    StylePlugin.getDefault().getLog().log((IStatus)status);
                }
                catch (Throwable t) {
                    Status status = new Status(4, element.getNamespaceIdentifier(), 0, "Could not create " + element.getName(), t);
                    StylePlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.createActions();
        this.createToolBar();
        parent.setLayout((Layout)new FormLayout());
        FormData layout = new FormData();
        layout.top = new FormAttachment(null, 0);
        layout.left = new FormAttachment(null, 1);
        layout.width = 200;
        this.book = new PageBook(parent, 0);
        layout = new FormData();
        layout.top = new FormAttachment(0);
        layout.left = new FormAttachment(0);
        layout.right = new FormAttachment(100);
        layout.bottom = new FormAttachment(100);
        this.book.setLayoutData((Object)layout);
        this.pleaseSelectLayer = new Label((Composite)this.book, -1);
        this.pleaseSelectLayer.setAlignment(16384);
        this.pleaseSelectLayer.setText(Messages.StyleView_label_selectLayer_text);
        this.book.showPage((Control)this.pleaseSelectLayer);
        for (StyleViewSite site : this.sites) {
            Composite page = new Composite((Composite)this.book, 0);
            page.setLayout((Layout)new FillLayout());
            try {
                site.createControl(page);
            }
            catch (Throwable t) {
                t.printStackTrace();
                page.dispose();
                site.dispose();
                this.sites.remove((Object)this);
            }
        }
        IWorkbenchPage page2 = this.getSite().getPage();
        page2.addSelectionListener(this.workbenchWatcher);
        IWorkbenchPage page = this.getViewSite().getPage();
        this.workbenchWatcher.selectionChanged(page.getActivePart(), page.getSelection());
        ISelection sel = page2.getSelection();
        if (this.findLayer(sel)) {
            return;
        }
        IEditorPart activeEditor = page2.getActiveEditor();
        if (activeEditor != null && this.findLayer(sel = activeEditor.getSite().getSelectionProvider().getSelection())) {
            return;
        }
        sel = page2.getSelection("net.refractions.udig.project.ui.layerManager");
        if (this.findLayer(sel)) {
            return;
        }
        sel = page2.getSelection("net.refractions.udig.project.ui.projectExplorer");
        if (this.findLayer(sel)) {
            return;
        }
    }

    private boolean findLayer(ISelection sel) {
        Layer layer = null;
        if (sel == null || sel.isEmpty()) {
            return false;
        }
        if (!(sel instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        for (Object e : selection) {
            IAdaptable adapter;
            Object adapted;
            if (e instanceof Layer) {
                layer = (Layer)e;
                break;
            }
            if (!(e instanceof IAdaptable) || (adapted = (adapter = (IAdaptable)e).getAdapter(Layer.class)) == null) continue;
            layer = (Layer)adapted;
            break;
        }
        if (layer != null) {
            this.setCurrentLayer(layer);
            return true;
        }
        return false;
    }

    public void setCurrentLayer(Layer layer) {
        if (this.currentLayer == null && layer == null) {
            return;
        }
        if (layer != null && layer.equals((Object)this.currentLayer)) {
            return;
        }
        if (this.currentLayer != null) {
            this.currentLayer.removeListener(this.layerListener);
        }
        if (layer == null) {
            this.currentLayer = null;
        } else {
            this.currentLayer = new StyleLayer(layer);
            this.currentLayer.addListener(this.layerListener);
        }
        this.enableActions(this.currentLayer != null);
        IStyleConfigurator config = null;
        if (layer == null) {
            config = null;
        } else if (this.currentConfig != null && this.currentConfig.canStyle(layer)) {
            config = this.currentConfig;
        } else {
            for (StyleViewSite site : this.sites) {
                if (!site.getConfig().canStyle(layer)) continue;
                config = site.getConfig();
                break;
            }
        }
        this.setStyleConfigurator(config);
        this.updateChooser();
    }

    void updateChooser() {
        if (this.configChooser == null) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        Set<IStyleConfigurator> configs = this.getStyleConfigurators();
        for (IStyleConfigurator config : configs) {
            String label = config.getLabel();
            items.add(label);
        }
        this.configChooser.setItems(items.toArray(new String[items.size()]));
        if (this.configChooser.getItemCount() == 0) {
            String message = Messages.StyleView_chooser_message;
            this.configChooser.add(message);
            this.configChooser.setEnabled(false);
            this.configChooser.setText(message);
            return;
        }
        if (this.configChooser.getItemCount() == 1) {
            this.configChooser.setVisibleItemCount(1);
            this.configChooser.setEnabled(true);
        } else {
            this.configChooser.setVisibleItemCount(Math.min(5, items.size()));
            this.configChooser.setEnabled(true);
        }
        if (this.currentConfig == null) {
            this.configChooser.setText("--");
        } else {
            this.configChooser.setText(this.currentConfig.getLabel());
        }
    }

    public Layer getCurrentLayer() {
        return this.currentLayer;
    }

    public Set<IStyleConfigurator> getStyleConfigurators() {
        Layer layer = this.getCurrentLayer();
        TreeSet<IStyleConfigurator> set = new TreeSet<IStyleConfigurator>(new Comparator<IStyleConfigurator>(){

            @Override
            public int compare(IStyleConfigurator a, IStyleConfigurator b) {
                if (a == b) {
                    return 0;
                }
                if (a == null || a.getLabel() == null) {
                    return -1;
                }
                if (b == null || b.getLabel() == null) {
                    return 1;
                }
                return a.getLabel().compareTo(b.getLabel());
            }
        });
        if (layer == null || this.sites == null || this.sites.size() == 0) {
            return set;
        }
        HashSet<IStyleConfigurator> badSites = new HashSet<IStyleConfigurator>();
        for (StyleViewSite site : this.sites) {
            try {
                IStyleConfigurator config = site.getConfig();
                if (!config.canStyle(layer)) continue;
                set.add(config);
            }
            catch (Throwable t) {
                t.printStackTrace();
                StylePlugin.getDefault().getLog().log((IStatus)new Status(1, site.getPluginId(), 0, null, t));
                badSites.add(site.config);
            }
        }
        if (!badSites.isEmpty()) {
            this.sites.removeAll(badSites);
        }
        return set;
    }

    void focusConfigurator(IStyleConfigurator config) {
        if (this.currentLayer == null) {
            return;
        }
        config.focus((Layer)this.currentLayer);
    }

    public void setFocus() {
        if (this.configChooser != null) {
            this.configChooser.setFocus();
        }
    }

    public void setStyleConfigurator(IStyleConfigurator config) {
        this.currentConfig = config;
        if (this.currentConfig != null) {
            this.currentConfig.setAction((IAction)this.applyAction);
            for (StyleViewSite site : this.sites) {
                if (site.getConfig() != this.currentConfig) continue;
                site.focus();
                return;
            }
        }
        this.book.showPage((Control)this.pleaseSelectLayer);
    }

    public IStyleConfigurator getStyleConfigurator() {
        return this.currentConfig;
    }

    private void enableActions(boolean enable) {
        this.applyAction.setEnabled(enable);
        this.cancelAction.setEnabled(enable);
    }

    private void createActions() {
        this.applyAction = new Action("apply"){

            public void run() {
                StyleView.this.apply();
            }
        };
        this.applyAction.setEnabled(false);
        this.applyAction.setToolTipText(Messages.StyleView_apply_tooltip);
        this.applyAction.setImageDescriptor(StylePlugin.getDefault().getImageDescriptor("elcl16/apply_co.gif"));
        this.cancelAction = new Action("cancel"){

            public void run() {
                StyleView.this.revert();
            }
        };
        this.cancelAction.setEnabled(false);
        this.cancelAction.setToolTipText(Messages.StyleView_cancel_tooltip);
        this.cancelAction.setImageDescriptor(StylePlugin.getDefault().getImageDescriptor("elcl16/reset_co.gif"));
    }

    void apply() {
        if (this.currentLayer == null) {
            return;
        }
        this.currentLayer.apply();
    }

    void revert() {
        if (this.currentLayer == null) {
            return;
        }
        this.currentLayer.revert();
        this.refresh();
    }

    public void refresh() {
        for (StyleViewSite site : this.sites) {
            site.config.focus((Layer)this.currentLayer);
        }
    }

    private void createToolBar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IContributionItem)new GroupMarker(CHOOSER_MENU_GROUP));
        mgr.appendToGroup(CHOOSER_MENU_GROUP, (IContributionItem)new ControlContribution("none"){

            protected Control createControl(Composite parent) {
                StyleView.this.configChooser = new Combo(parent, 12);
                StyleView.this.updateChooser();
                StyleView.this.configChooser.addSelectionListener(StyleView.this.chooserListener);
                return StyleView.this.configChooser;
            }

            protected int computeWidth(Control control) {
                return 125;
            }
        });
        mgr.add((IContributionItem)new GroupMarker(STYLE_MENU_GROUP));
        mgr.appendToGroup(STYLE_MENU_GROUP, (IContributionItem)new Separator());
        mgr.appendToGroup(STYLE_MENU_GROUP, (IAction)this.applyAction);
        mgr.appendToGroup(STYLE_MENU_GROUP, (IAction)this.cancelAction);
        mgr.add((IContributionItem)new GroupMarker(CONFIG_MENU_GROUP));
        mgr.add((IContributionItem)new Separator());
    }

    public void dispose() {
        if (this.sites != null) {
            for (StyleViewSite site : this.sites) {
                try {
                    site.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
        if (this.workbenchWatcher != null) {
            this.getSite().getPage().removeSelectionListener(this.workbenchWatcher);
        }
        super.dispose();
    }

    class StyleViewSite
    implements IViewSite {
        String idPlugin;
        String idExtention;
        String idStyle;
        IActionBars actionBars;
        IStyleConfigurator config;
        private Composite page;
        ToolBarManager toolbarManager;

        public StyleViewSite(IExtension extention, IConfigurationElement element, IStyleConfigurator part) {
            this.idPlugin = element.getNamespaceIdentifier();
            this.idExtention = extention.getUniqueIdentifier();
            this.idStyle = part.getStyleId();
            this.config = part;
            this.actionBars = null;
            this.toolbarManager = null;
        }

        public void createControl(Composite parent) {
            this.config.createControl(parent);
            this.page = parent;
        }

        public IActionBars getActionBars() {
            if (this.actionBars != null) {
                return this.actionBars;
            }
            final IActionBars global = StyleView.this.getViewSite().getActionBars();
            this.actionBars = new IActionBars(){

                public void clearGlobalActionHandlers() {
                    global.clearGlobalActionHandlers();
                }

                public IAction getGlobalActionHandler(String actionId) {
                    return global.getGlobalActionHandler(actionId);
                }

                public IMenuManager getMenuManager() {
                    return null;
                }

                public IStatusLineManager getStatusLineManager() {
                    return global.getStatusLineManager();
                }

                public IToolBarManager getToolBarManager() {
                    if (StyleViewSite.this.toolbarManager == null) {
                        StyleViewSite.this.toolbarManager = new ToolBarManager(){

                            public void update(boolean force) {
                                super.update(force);
                            }
                        };
                    }
                    return StyleViewSite.this.toolbarManager;
                }

                public void setGlobalActionHandler(String actionId, IAction handler) {
                    global.setGlobalActionHandler(actionId, handler);
                }

                public void updateActionBars() {
                    global.updateActionBars();
                }

                public IServiceLocator getServiceLocator() {
                    return global.getServiceLocator();
                }
            };
            return this.actionBars;
        }

        public String getSecondaryId() {
            return this.idStyle;
        }

        public String getId() {
            return this.idExtention;
        }

        public String getPluginId() {
            return this.idPlugin;
        }

        public String getRegisteredName() {
            return this.config.getLabel();
        }

        public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
        }

        public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
        }

        public IKeyBindingService getKeyBindingService() {
            return null;
        }

        public IWorkbenchPage getPage() {
            return StyleView.this.getViewSite().getPage();
        }

        public ISelectionProvider getSelectionProvider() {
            return StyleView.this.getViewSite().getSelectionProvider();
        }

        public Shell getShell() {
            return StyleView.this.getViewSite().getShell();
        }

        public IWorkbenchWindow getWorkbenchWindow() {
            return StyleView.this.getViewSite().getWorkbenchWindow();
        }

        public void setSelectionProvider(ISelectionProvider provider) {
            StyleView.this.getViewSite().setSelectionProvider(provider);
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public IStyleConfigurator getConfig() {
            return this.config;
        }

        public void dispose() {
            if (this.page != null && !this.page.isDisposed()) {
                this.page.dispose();
                this.page = null;
            }
            if (this.config != null) {
                this.config.dispose();
                this.config = null;
            }
        }

        public void focus() {
            if (StyleView.this.currentLayer == null) {
                StyleView.this.book.showPage((Control)StyleView.this.pleaseSelectLayer);
                return;
            }
            if (!this.getConfig().canStyle((Layer)StyleView.this.currentLayer)) {
                throw new IllegalStateException("Trying to use " + this.config + " with a layer it cannot style");
            }
            if (this.page == null || this.page.isDisposed()) {
                throw new IllegalStateException("Framework should have called createPartControl before trying to focus");
            }
            this.getConfig().focus((Layer)StyleView.this.currentLayer);
            StyleView.this.book.setVisible(true);
            StyleView.this.book.showPage((Control)this.page);
            this.page.setVisible(true);
            if (this.toolbarManager != null) {
                IToolBarManager mgr = StyleView.this.getViewSite().getActionBars().getToolBarManager();
                mgr.add((IContributionItem)new GroupMarker(StyleView.CONFIG_MENU_GROUP));
                IContributionItem[] iContributionItemArray = this.toolbarManager.getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    mgr.appendToGroup(StyleView.CONFIG_MENU_GROUP, item);
                    ++n2;
                }
            } else {
                IToolBarManager mgr = StyleView.this.getViewSite().getActionBars().getToolBarManager();
                mgr.removeAll();
                StyleView.this.createToolBar();
                mgr.remove(StyleView.CONFIG_MENU_GROUP);
            }
            StyleView.this.getViewSite().getActionBars().updateActionBars();
        }

        public String toString() {
            return "Site<" + this.config.getLabel() + ">";
        }

        public IWorkbenchPart getPart() {
            return StyleView.this;
        }

        public Object getService(Class api) {
            return null;
        }

        public boolean hasService(Class api) {
            return false;
        }
    }
}

