/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wfs;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.internal.CatalogImpl;
import net.refractions.udig.catalog.internal.ResolveChangeEvent;
import net.refractions.udig.catalog.internal.ResolveDelta;
import net.refractions.udig.catalog.internal.wfs.WFSGeoResourceImpl;
import net.refractions.udig.catalog.internal.wfs.WFSServiceInfo;
import net.refractions.udig.catalog.internal.wfs.WfsPlugin;
import net.refractions.udig.catalog.wfs.internal.Messages;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;

public class WFSServiceImpl
extends IService {
    private URL identifier = null;
    private Map<String, Serializable> params = null;
    private volatile List<WFSGeoResourceImpl> members = null;
    protected Lock rLock = new UDIGDisplaySafeLock();
    private Throwable msg = null;
    private volatile WFSDataStoreFactory dsf;
    private volatile WFSDataStore ds = null;
    private static final Lock dsLock = new UDIGDisplaySafeLock();

    public WFSServiceImpl(URL identifier, Map<String, Serializable> dsParams) {
        this.identifier = identifier;
        this.params = dsParams;
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(WFSDataStore.class)) {
            return adaptee.cast(this.getDS(monitor));
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(WFSDataStore.class) || super.canResolve(adaptee);
    }

    public void dispose(IProgressMonitor monitor) {
        super.dispose(monitor);
        if (this.members != null) {
            this.members = null;
        }
        if (this.ds != null) {
            this.ds.dispose();
            this.ds = null;
        }
    }

    public List<WFSGeoResourceImpl> resources(IProgressMonitor monitor) throws IOException {
        block7: {
            if (this.members == null) {
                this.rLock.lock();
                try {
                    if (this.members != null) break block7;
                    this.getDS(monitor);
                    this.members = new LinkedList<WFSGeoResourceImpl>();
                    String[] typenames = this.ds.getTypeNames();
                    if (typenames == null) break block7;
                    int i = 0;
                    while (i < typenames.length) {
                        try {
                            this.members.add(new WFSGeoResourceImpl(this, typenames[i]));
                        }
                        catch (Exception e) {
                            WfsPlugin.log("", e);
                        }
                        ++i;
                    }
                }
                finally {
                    this.rLock.unlock();
                }
            }
        }
        return this.members;
    }

    public IServiceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return super.getInfo(monitor);
    }

    protected IServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        WFSDataStore dataStore = this.getDS(monitor);
        if (dataStore == null) {
            return null;
        }
        this.rLock.lock();
        try {
            WFSServiceInfo wFSServiceInfo = new WFSServiceInfo(this, this.ds);
            return wFSServiceInfo;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public Map<String, Serializable> getConnectionParams() {
        return this.params;
    }

    WFSDataStore getDS(IProgressMonitor monitor) throws IOException {
        if (this.ds == null) {
            block8: {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(Messages.WFSServiceImpl_task_name, 3);
                dsLock.lock();
                monitor.worked(1);
                try {
                    if (this.ds != null) break block8;
                    if (this.dsf == null) {
                        this.dsf = new WFSDataStoreFactory();
                    }
                    monitor.worked(1);
                    if (!this.dsf.canProcess(this.params)) break block8;
                    monitor.worked(1);
                    try {
                        URL url = (URL)this.params.get(WFSDataStoreFactory.URL.key);
                        url = WFSDataStoreFactory.createGetCapabilitiesRequest((URL)url);
                        this.params = new HashMap<String, Serializable>(this.params);
                        this.params.put(WFSDataStoreFactory.URL.key, url);
                        this.ds = this.dsf.createDataStore(this.params);
                        monitor.worked(1);
                    }
                    catch (IOException e) {
                        this.msg = e;
                        throw e;
                    }
                }
                finally {
                    dsLock.unlock();
                    monitor.done();
                }
            }
            ResolveDelta delta = new ResolveDelta((IResolve)this, IResolveDelta.Kind.CHANGED);
            ((CatalogImpl)CatalogPlugin.getDefault().getLocalCatalog()).fire((IResolveChangeEvent)new ResolveChangeEvent((Object)this, IResolveChangeEvent.Type.POST_CHANGE, (IResolveDelta)delta));
        }
        return this.ds;
    }

    public IResolve.Status getStatus() {
        if (this.ds == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public URL getIdentifier() {
        return this.identifier;
    }
}

