/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wfs;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.wfs.WFSGeoResourceInfo;
import net.refractions.udig.catalog.internal.wfs.WFSServiceImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.wfs.WFSDataStore;

public class WFSGeoResourceImpl
extends IGeoResource {
    WFSServiceImpl parent;
    String typename = null;
    private URL identifier;

    private WFSGeoResourceImpl() {
    }

    public WFSGeoResourceImpl(WFSServiceImpl parent, String typename) {
        this.service = parent;
        this.parent = parent;
        this.typename = typename;
        try {
            this.identifier = new URL(String.valueOf(parent.getIdentifier().toString()) + "#" + typename);
        }
        catch (MalformedURLException malformedURLException) {
            this.identifier = parent.getIdentifier();
        }
    }

    public URL getIdentifier() {
        return this.identifier;
    }

    public IResolve.Status getStatus() {
        return this.parent.getStatus();
    }

    public Throwable getMessage() {
        return this.parent.getMessage();
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(WFSDataStore.class)) {
            return this.parent.resolve(adaptee, monitor);
        }
        if (adaptee.isAssignableFrom(IGeoResource.class)) {
            return adaptee.cast((Object)this);
        }
        if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
            return adaptee.cast((Object)this.createInfo(monitor));
        }
        if (adaptee.isAssignableFrom(SimpleFeatureSource.class)) {
            WFSDataStore wfs = this.parent.getDS(monitor);
            SimpleFeatureSource featureSource = wfs.getFeatureSource(this.typename);
            return adaptee.cast(featureSource);
        }
        if (adaptee.isAssignableFrom(FeatureStore.class)) {
            WFSDataStore wfs = this.parent.getDS(monitor);
            SimpleFeatureSource featureSource = wfs.getFeatureSource(this.typename);
            if (featureSource instanceof FeatureStore) {
                return adaptee.cast(featureSource);
            }
            return null;
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        if (adaptee.isAssignableFrom(SimpleFeatureSource.class)) {
            return true;
        }
        if (adaptee.isAssignableFrom(SimpleFeatureStore.class)) {
            if (this.info != null) {
                WFSGeoResourceInfo wfsInfo = (WFSGeoResourceInfo)this.info;
                return wfsInfo.isWritable();
            }
            return this.service.getID().toString().indexOf("1.1.0") == -1;
        }
        return adaptee.isAssignableFrom(IGeoResourceInfo.class) || adaptee.isAssignableFrom(WFSDataStore.class) || adaptee.isAssignableFrom(IService.class) || super.canResolve(adaptee);
    }

    public WFSGeoResourceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (WFSGeoResourceInfo)super.getInfo(monitor);
    }

    protected WFSGeoResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        if (this.getStatus() == IResolve.Status.BROKEN) {
            return null;
        }
        this.parent.rLock.lock();
        try {
            WFSGeoResourceInfo wFSGeoResourceInfo = new WFSGeoResourceInfo(this);
            return wFSGeoResourceInfo;
        }
        finally {
            this.parent.rLock.unlock();
        }
    }
}

