/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.gridcoverage.basic;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.HashMap;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.internal.render.impl.RendererImpl;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.render.gridcoverage.basic.internal.Messages;
import net.refractions.udig.render.internal.gridcoverage.basic.GridCoverageRenderState;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.filter.expression.Expression;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class GridCoverageReaderRenderer
extends RendererImpl {
    private GridCoverageRenderer renderer;

    public synchronized void render(Graphics2D graphics, IProgressMonitor monitor) throws RenderException {
        block22: {
            try {
                IRenderContext currentContext = this.getContext();
                IGeoResource geoResource = currentContext.getGeoResource();
                if (geoResource.canResolve(RendererImpl.class)) {
                    RendererImpl rendererImpl = (RendererImpl)geoResource.resolve(RendererImpl.class, monitor);
                    rendererImpl.setContext(currentContext);
                    rendererImpl.render(graphics, monitor);
                    rendererImpl.dispose();
                    return;
                }
                currentContext.setStatus(1);
                currentContext.setStatusMessage(Messages.BasicGridCoverageRenderer_rendering_status);
                ReferencedEnvelope envelope = this.getRenderBounds();
                if (envelope == null || envelope.isNull()) {
                    envelope = this.context.getImageBounds();
                }
                Point upperLeft = currentContext.worldToPixel(new Coordinate(envelope.getMinX(), envelope.getMinY()));
                Point bottomRight = currentContext.worldToPixel(new Coordinate(envelope.getMaxX(), envelope.getMaxY()));
                Rectangle screenSize = new Rectangle(upperLeft);
                screenSize.add(bottomRight);
                IMapDisplay mapDisplay = currentContext.getMapDisplay();
                AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)geoResource.resolve(AbstractGridCoverage2DReader.class, monitor);
                if (reader == null) {
                    return;
                }
                try {
                    ReferencedEnvelope env;
                    CoordinateReferenceSystem destinationCRS = currentContext.getCRS();
                    ReferencedEnvelope bounds = currentContext.getImageBounds();
                    bounds = bounds.transform(destinationCRS, true);
                    ParameterValueGroup group = (ParameterValueGroup)geoResource.resolve(ParameterValueGroup.class, monitor);
                    if (group == null) {
                        group = reader.getFormat().getReadParameters();
                    } else {
                        try {
                            ParameterValue jaiImageReaderParam = group.parameter(AbstractGridFormat.USE_JAI_IMAGEREAD.getName().toString());
                            if (jaiImageReaderParam != null) {
                                jaiImageReaderParam.setValue(false);
                            }
                        }
                        catch (ParameterNotFoundException parameterNotFoundException) {}
                    }
                    ParameterValue readGridGeometry2DParam = group.parameter(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString());
                    GridEnvelope2D gridEnvelope = new GridEnvelope2D(0, 0, mapDisplay.getWidth(), mapDisplay.getHeight());
                    double west = bounds.getMinX();
                    double east = bounds.getMaxX();
                    double south = bounds.getMinY();
                    double north = bounds.getMaxY();
                    if (destinationCRS != null) {
                        env = new ReferencedEnvelope(west, east, south, north, destinationCRS);
                    } else {
                        DirectPosition2D minDp = new DirectPosition2D(west, south);
                        DirectPosition2D maxDp = new DirectPosition2D(east, north);
                        env = new Envelope2D(minDp, maxDp);
                    }
                    readGridGeometry2DParam.setValue((Object)new GridGeometry2D((GridEnvelope)gridEnvelope, (org.opengis.geometry.Envelope)env));
                    currentContext.setStatus(5);
                    this.setState(32);
                    ParameterValue[] parameterValues = group.values().toArray(new ParameterValue[0]);
                    GridCoverage2D coverage = reader.read((GeneralParameterValue[])parameterValues);
                    if (coverage == null) break block22;
                    RenderingHints hints = new RenderingHints(new HashMap());
                    hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED));
                    hints.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE));
                    hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED));
                    hints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED));
                    hints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR));
                    hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
                    hints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF));
                    hints.add(new RenderingHints(JAI.KEY_INTERPOLATION, new InterpolationNearest()));
                    graphics.addRenderingHints(hints);
                    TileCache tempCache = currentContext.getTileCache();
                    hints.add(new RenderingHints(JAI.KEY_TILE_CACHE, tempCache));
                    if (CRS.getHorizontalCRS((CoordinateReferenceSystem)destinationCRS) == null) {
                        destinationCRS = coverage.getCoordinateReferenceSystem2D();
                    }
                    AffineTransform worldToScreen = null;
                    try {
                        Style style = this.grabStyle();
                        Rule rule = SLDs.getRasterSymbolizerRule((Style)style);
                        double currentScale = currentContext.getViewportModel().getScaleDenominator();
                        double minScale = rule.getMinScaleDenominator();
                        double maxScale = rule.getMaxScaleDenominator();
                        if (minScale <= currentScale && currentScale <= maxScale) {
                            GridCoverageRenderer paint = new GridCoverageRenderer(destinationCRS, (Envelope)envelope, screenSize, worldToScreen, hints);
                            RasterSymbolizer rasterSymbolizer = SLD.rasterSymbolizer((Style)style);
                            String maskColor = this.getContext().getLayer().getStyleBlackboard().getString("raster-color-mask");
                            if (maskColor instanceof String) {
                                String[] colorSplit = maskColor.split(":");
                                Color color = new Color(Integer.parseInt(colorSplit[0]), Integer.parseInt(colorSplit[1]), Integer.parseInt(colorSplit[2]));
                                RenderedImage image = coverage.getRenderedImage();
                                ImageWorker iw = new ImageWorker(image);
                                iw.makeColorTransparent(color);
                                image = iw.getRenderedImage();
                                GridCoverageFactory gcF = CoverageFactoryFinder.getGridCoverageFactory(null);
                                coverage = gcF.create((CharSequence)coverage.getName(), image, coverage.getCoordinateReferenceSystem(), coverage.getGridGeometry().getGridToCRS(), coverage.getSampleDimensions(), null, null);
                            }
                            paint.paint(graphics, coverage, rasterSymbolizer);
                            this.setState(4);
                        }
                    }
                    catch (Exception exception) {
                        GridCoverageRenderer paint = new GridCoverageRenderer(destinationCRS, (Envelope)envelope, screenSize, worldToScreen, hints);
                        RasterSymbolizer rasterSymbolizer = CommonFactoryFinder.getStyleFactory(null).createRasterSymbolizer();
                        paint.paint(graphics, coverage, rasterSymbolizer);
                        this.setState(4);
                    }
                }
                catch (Exception e1) {
                    throw new RenderException((Throwable)e1);
                }
            }
            finally {
                this.getContext().setStatus(0);
                this.getContext().setStatusMessage(null);
            }
        }
    }

    private Style grabStyle() {
        StyleBlackboard styleBlackboard = (StyleBlackboard)this.getContext().getLayer().getStyleBlackboard();
        Style style = (Style)styleBlackboard.lookup(Style.class);
        return style;
    }

    public synchronized void render2(Graphics2D graphics, IProgressMonitor monitor) throws RenderException {
        GridCoverageRenderState state = null;
        try {
            state = this.prepareRender(monitor);
        }
        catch (IOException e1) {
            throw new RenderException((Throwable)e1);
        }
        this.doRender(this.renderer, graphics, state);
    }

    public void doRender(GridCoverageRenderer renderer, Graphics2D graphics, GridCoverageRenderState state) {
        double scale = state.context.getViewportModel().getScaleDenominator();
        if (scale < state.minScale || scale > state.maxScale) {
            return;
        }
        state.context.setStatus(1);
        state.context.setStatusMessage(Messages.BasicGridCoverageRenderer_rendering_status);
        Composite oldComposite = graphics.getComposite();
        graphics.setComposite(AlphaComposite.getInstance(3, state.opacity));
        Rectangle displayArea = state.displayArea;
        AffineTransform at = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)state.bounds, (Rectangle)displayArea);
        AffineTransform tempTransform = graphics.getTransform();
        AffineTransform atg = new AffineTransform(tempTransform);
        atg.concatenate(at);
        graphics.setTransform(atg);
        try {
            GridCoverage coverage = (GridCoverage)this.getContext().getGeoResource().resolve(GridCoverage.class, null);
            StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
            RasterSymbolizer rasterSymbolizer = factory.createRasterSymbolizer();
            renderer.paint(graphics, (GridCoverage2D)coverage, rasterSymbolizer);
        }
        catch (IOException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (FactoryException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (TransformException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (NoninvertibleTransformException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        graphics.setComposite(oldComposite);
        graphics.setTransform(tempTransform);
        if (state.context.getStatus() == 1) {
            state.context.setStatus(0);
            state.context.setStatusMessage(null);
        }
    }

    public static GridCoverageRenderState getRenderState(IRenderContext context) {
        StyleBlackboard styleBlackboard = (StyleBlackboard)context.getLayer().getStyleBlackboard();
        Style style = (Style)styleBlackboard.lookup(Style.class);
        double minScale = Double.MIN_VALUE;
        double maxScale = Double.MAX_VALUE;
        float opacity = 1.0f;
        if (style != null) {
            try {
                FeatureTypeStyle featureStyle = (FeatureTypeStyle)style.featureTypeStyles().get(0);
                Rule rule = (Rule)featureStyle.rules().get(0);
                minScale = rule.getMinScaleDenominator();
                maxScale = rule.getMaxScaleDenominator();
                if (rule.getSymbolizers()[0] instanceof RasterSymbolizer) {
                    RasterSymbolizer rs = (RasterSymbolizer)rule.getSymbolizers()[0];
                    opacity = GridCoverageReaderRenderer.getOpacity(rs);
                }
            }
            catch (Exception e) {
                ProjectPlugin.getPlugin().log((Object)e);
            }
        } else {
            opacity = 1.0f;
            minScale = 0.0;
            maxScale = Double.MAX_VALUE;
        }
        Rectangle displayArea = new Rectangle(context.getMapDisplay().getWidth(), context.getMapDisplay().getHeight());
        return new GridCoverageRenderState(context, context.getImageBounds(), displayArea, opacity, minScale, maxScale);
    }

    private static float getOpacity(RasterSymbolizer sym) {
        float alpha = 1.0f;
        Expression exp = sym.getOpacity();
        if (exp == null) {
            return alpha;
        }
        Object obj = exp.evaluate(null);
        if (obj == null) {
            return alpha;
        }
        Number num = null;
        if (obj instanceof Number) {
            num = (Number)obj;
        }
        if (num == null) {
            return alpha;
        }
        return num.floatValue();
    }

    private GridCoverageRenderState prepareRender(IProgressMonitor monitor) throws IOException {
        try {
            CoordinateReferenceSystem contextCRS = this.getContext().getCRS();
            Rectangle rectangle = new Rectangle(this.getContext().getMapDisplay().getDisplaySize());
            ReferencedEnvelope bounds = this.getRenderBounds();
            if (bounds == null) {
                ReferencedEnvelope all;
                bounds = this.getContext().getImageBounds();
                if (bounds instanceof ReferencedEnvelope) {
                    all = bounds;
                    if (!contextCRS.equals(all.getCoordinateReferenceSystem())) {
                        bounds = all.transform(contextCRS, true, 10);
                    }
                } else {
                    all = new ReferencedEnvelope((Envelope)bounds, this.getContext().getViewportModel().getCRS());
                    bounds = all.transform(contextCRS, true, 10);
                }
            }
            AffineTransform world2screen = null;
            this.renderer = new GridCoverageRenderer(contextCRS, (Envelope)bounds, rectangle, world2screen);
        }
        catch (TransformException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (NoninvertibleTransformException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (FactoryException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        return GridCoverageReaderRenderer.getRenderState(this.getContext());
    }

    public void stopRendering() {
        this.setState(1);
    }

    public void dispose() {
    }

    public void render(IProgressMonitor monitor) throws RenderException {
        this.render(this.getContext().getImage().createGraphics(), monitor);
    }
}

