/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.gridcoverage.tool.info.internal;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.render.gridcoverage.basic.internal.Messages;
import net.refractions.udig.render.gridcoverage.tool.info.internal.MosaicInfoPanel;
import net.refractions.udig.render.internal.gridcoverage.basic.RendererPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MosaicInfoView
extends ViewPart {
    private static final String ICONS_DTOOL16_UNDO_EDIT = "icons/dtool16/undo_edit.gif";
    private static final String ICONS_ETOOL16_UNDO_EDIT = "icons/etool16/undo_edit.gif";
    public static final String VIEW_ID = "net.refractions.udig.render.gridcoverage.view.infoView";
    private Text information;
    private MosaicInfoPanel infoPanel;
    private Composite ctr;
    private PageBook book;
    private Action undoAction;

    public void createPartControl(Composite parent) {
        this.book = new PageBook(parent, 0);
        this.information = new Text((Composite)this.book, 64);
        this.information.setText(Messages.MosaicInfoView_DefaultViewText);
        this.book.showPage((Control)this.information);
        this.infoPanel = new MosaicInfoPanel();
        this.infoPanel.addFeatureSelectedListener(new MosaicInfoPanel.FeatureSelectedListener(){

            @Override
            public void fireFeatureSelected(SimpleFeature feature) {
                MosaicInfoView.this.enableUndoAction();
            }
        });
        this.infoPanel.addFeatureUpdatedListener(new MosaicInfoPanel.FeatureUpdatedListener(){

            @Override
            public void fireFeatureUpdated(SimpleFeature feature) {
                MosaicInfoView.this.enableUndoAction();
            }
        });
        this.ctr = this.infoPanel.createControl((Composite)this.book);
        this.createActions();
        this.createToolBar();
    }

    private void enableUndoAction() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MosaicInfoView.this.undoAction.setEnabled(MosaicInfoView.this.infoPanel.canUndo());
            }
        });
    }

    public void setFocus() {
    }

    public void updateInfo(InfoRequest request) {
        SimpleFeature selectedFeature = null;
        ILayer selectedLayer = null;
        int i = request.layers.size() - 1;
        while (i > -1) {
            ILayer layer = request.layers.get(i);
            if (layer.isVisible() && layer.hasResource(FeatureSource.class) && layer.getGeoResource().canResolve(AbstractGridCoverage2DReader.class)) {
                try {
                    selectedFeature = this.findFirstFeature(layer, request.bbox);
                    selectedLayer = layer;
                    if (selectedFeature != null) {
                        break;
                    }
                }
                catch (Throwable t) {
                    RendererPlugin.log("Information request " + layer.getName() + " failed " + t, t);
                }
            }
            --i;
        }
        this.updateFeatureInfo(selectedFeature, selectedLayer);
    }

    private void updateFeatureInfo(SimpleFeature selectedFeature, ILayer selectedLayer) {
        this.infoPanel.updateInfo(selectedFeature, selectedLayer);
        this.book.showPage((Control)this.ctr);
    }

    private SimpleFeature findFirstFeature(ILayer layer, ReferencedEnvelope bbox) throws Exception {
        FeatureSource source = (FeatureSource)layer.getResource(FeatureSource.class, null);
        SimpleFeatureType type = (SimpleFeatureType)source.getSchema();
        CoordinateReferenceSystem crs = layer.getCRS();
        if (!bbox.getCoordinateReferenceSystem().equals(crs)) {
            bbox = bbox.transform(crs, true);
        }
        FilterFactory2 factory = (FilterFactory2)CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Geometry geom = new GeometryFactory().toGeometry((Envelope)bbox);
        Intersects filter = factory.intersects((Expression)factory.property(type.getGeometryDescriptor().getName()), (Expression)factory.literal((Object)geom));
        layer.getQuery(false);
        FeatureCollection results = source.getFeatures((Filter)filter);
        FeatureIterator reader = results.features();
        try {
            if (reader.hasNext()) {
                SimpleFeature f;
                SimpleFeature simpleFeature = f = (SimpleFeature)reader.next();
                return simpleFeature;
            }
        }
        finally {
            reader.close();
        }
        return null;
    }

    private void createActions() {
        this.undoAction = new Action(Messages.MosaicInfoView_UndoAction){

            public void run() {
                if (MosaicInfoView.this.infoPanel.canUndo()) {
                    MosaicInfoView.this.infoPanel.undo();
                }
            }
        };
        this.undoAction.setDisabledImageDescriptor(RendererPlugin.getImageDescriptor(ICONS_DTOOL16_UNDO_EDIT));
        this.undoAction.setImageDescriptor(RendererPlugin.getImageDescriptor(ICONS_ETOOL16_UNDO_EDIT));
        this.undoAction.setToolTipText(Messages.MosaicInfoView_UndoActionToolTip);
        this.undoAction.setEnabled(false);
    }

    private void createToolBar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.undoAction);
    }

    public static class InfoRequest {
        public ReferencedEnvelope bbox;
        public List<ILayer> layers;
    }
}

