/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.gridcoverage.tool.info.internal;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.render.gridcoverage.basic.internal.Messages;
import net.refractions.udig.render.gridcoverage.tool.info.internal.ChannelViewer;
import net.refractions.udig.render.internal.gridcoverage.basic.RendererPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class MosaicInfoPanel {
    private Label txtFileName;
    private Label txtDate;
    private Label txtFileSize;
    private Label txtFileType;
    private ChannelViewer red;
    private ChannelViewer green;
    private ChannelViewer blue;
    private Composite grpBands;
    private ILayer currentLayer;
    private SimpleFeature currentFeature;
    private String currentColors;
    private String currentBands;
    private List<FeatureSelectedListener> selectionListeners;
    private List<FeatureUpdatedListener> updatelistener;
    private FilterFactory2 ff;
    private final UpdateImageMosaicJob updateJob = new UpdateImageMosaicJob();

    public MosaicInfoPanel() {
        this.selectionListeners = new ArrayList<FeatureSelectedListener>();
        this.updatelistener = new ArrayList<FeatureUpdatedListener>();
    }

    public Composite createControl(Composite parent) {
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MosaicInfoPanel.this.applyUpdates();
            }
        };
        Composite all = new Composite(parent, 0);
        all.setLayout((Layout)new GridLayout(1, false));
        Group g = new Group(all, 16);
        g.setText(Messages.MosaicInfoPanel_FileInformationHeader);
        g.setLayout((Layout)new GridLayout(4, false));
        GridData gd = new GridData(768);
        g.setLayoutData((Object)gd);
        this.createLabel((Composite)g, Messages.MosaicInfoPanel_FileLabel);
        this.txtFileName = this.createLabel((Composite)g);
        this.createLabel((Composite)g, Messages.MosaicInfoPanel_FileDateLabel);
        this.txtDate = this.createLabel((Composite)g);
        this.createLabel((Composite)g, Messages.MosaicInfoPanel_FileTypeLabel);
        this.txtFileType = this.createLabel((Composite)g);
        this.createLabel((Composite)g, Messages.MosaicInfoPanel_FileSizeLabel);
        this.txtFileSize = this.createLabel((Composite)g);
        this.grpBands = new Composite(all, 16);
        this.grpBands.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(768);
        this.grpBands.setLayoutData((Object)gd);
        this.red = new ChannelViewer(Messages.MosaicInfoPanel_RedBandLabel, listener);
        this.red.createControl(this.grpBands);
        this.green = new ChannelViewer(Messages.MosaicInfoPanel_GreenBandLabel, listener);
        this.green.createControl(this.grpBands);
        this.blue = new ChannelViewer(Messages.MosaicInfoPanel_BlueBandLabel, listener);
        this.blue.createControl(this.grpBands);
        return all;
    }

    private Label createLabel(Composite p) {
        Label l = new Label(p, 0);
        l.setText("");
        l.setLayoutData((Object)new GridData(768));
        return l;
    }

    private Label createLabel(Composite p, String text) {
        Label l = new Label(p, 0);
        l.setText(text);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        l.setLayoutData((Object)gd);
        return l;
    }

    public void updateInfo(SimpleFeature f, ILayer layer) {
        if (f == null) {
            this.txtFileName.setText("");
            this.txtFileType.setText("");
            this.txtFileSize.setText("");
            this.txtDate.setText("");
            this.red.setBands(null);
            this.green.setBands(null);
            this.blue.setBands(null);
            this.grpBands.setVisible(false);
        } else {
            try {
                ImageMosaicReader cfr_ignored_0 = (ImageMosaicReader)layer.getGeoResource().resolve(AbstractGridCoverage2DReader.class, null);
                String locationAttributeName = "location";
                Object attribute = f.getAttribute(locationAttributeName);
                Literal eq = this.getFilterFactory().literal(attribute);
                this.getFilterFactory().equals((Expression)this.getFilterFactory().property(locationAttributeName), (Expression)eq);
                File file = null;
                if (file == null) {
                    this.txtFileName.setText(Messages.MosaicInfoPanel_NoDataText);
                    this.txtFileType.setText("");
                    this.txtFileSize.setText("");
                    this.txtDate.setText("");
                } else {
                    this.txtFileName.setText(file.getName());
                    Date date = new Date(file.lastModified());
                    SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
                    this.txtDate.setText(format.format(date));
                    this.txtFileType.setText(file.getName().substring(file.getName().lastIndexOf(46)));
                    this.txtFileSize.setText(String.valueOf((double)file.length() / 1000.0) + "KB");
                }
                this.currentBands = null;
                this.currentColors = null;
                this.grpBands.setVisible(false);
            }
            catch (Exception ex) {
                RendererPlugin.log("Cannot update feature information", ex);
            }
        }
        this.fireFeatureSelected(f);
    }

    private void fireFeatureSelected(SimpleFeature feature) {
        for (FeatureSelectedListener type : this.selectionListeners) {
            type.fireFeatureSelected(feature);
        }
    }

    public void addFeatureSelectedListener(FeatureSelectedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void addFeatureUpdatedListener(FeatureUpdatedListener listener) {
        this.updatelistener.add(listener);
    }

    private int[] parseBands(String bands) {
        String[] sband = bands.split(",");
        int[] iband = new int[3];
        int i = 0;
        while (i < sband.length) {
            iband[i] = Integer.parseInt(sband[i]);
            ++i;
        }
        return iband;
    }

    private double[] parseColors(String bands) {
        String[] sband = bands.split(",");
        double[] colors = new double[3];
        int i = 0;
        while (i < sband.length) {
            colors[i] = Double.parseDouble(sband[i]);
            ++i;
        }
        return colors;
    }

    public boolean canUndo() {
        if (this.currentFeature != null && this.currentBands != null && this.currentColors != null) {
            int[] bands = this.parseBands(this.currentBands);
            double[] colors = this.parseColors(this.currentColors);
            return bands[0] != this.red.getBandIndex() || bands[1] != this.green.getBandIndex() || bands[2] != this.blue.getBandIndex() || colors[0] != (double)this.red.getColorCorrectionValue() || colors[1] != (double)this.green.getColorCorrectionValue() || colors[2] != (double)this.blue.getColorCorrectionValue();
        }
        return false;
    }

    public void undo() {
        try {
            if (this.canUndo()) {
                int[] bands = this.parseBands(this.currentBands);
                double[] colors = this.parseColors(this.currentColors);
                this.red.set(bands[0], colors[0]);
                this.green.set(bands[1], colors[1]);
                this.blue.set(bands[2], colors[2]);
                ImageMosaicReader imageReader = (ImageMosaicReader)this.currentLayer.getGeoResource().resolve(GridCoverageReader.class, null);
                this.updateJob.setData(imageReader, this.currentLayer, this.currentFeature, bands[0], bands[1], bands[2], colors[0], colors[1], colors[2], this.updatelistener);
                this.updateJob.schedule(100L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void applyUpdates() {
        int redBand = this.red.getBandIndex();
        int greenBand = this.green.getBandIndex();
        int blueBand = this.blue.getBandIndex();
        if (redBand == greenBand || redBand == blueBand || greenBand == blueBand) {
            String error = Messages.MosaicInfoPanel_InvalidBandSelectionMessage;
            this.red.setError(error);
            this.green.setError(error);
            this.blue.setError(error);
            return;
        }
        this.red.setError(null);
        this.green.setError(null);
        this.blue.setError(null);
        double redColor = this.red.getColorCorrectionValue();
        double greenColor = this.green.getColorCorrectionValue();
        double blueColor = this.blue.getColorCorrectionValue();
        try {
            ImageMosaicReader imageReader = (ImageMosaicReader)this.currentLayer.getGeoResource().resolve(GridCoverageReader.class, null);
            this.updateJob.setData(imageReader, this.currentLayer, this.currentFeature, redBand, greenBand, blueBand, redColor, greenColor, blueColor, this.updatelistener);
            this.updateJob.schedule(100L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public FilterFactory2 getFilterFactory() {
        if (this.ff == null) {
            this.ff = CommonFactoryFinder.getFilterFactory2(null);
        }
        return this.ff;
    }

    public static abstract class FeatureSelectedListener {
        public abstract void fireFeatureSelected(SimpleFeature var1);
    }

    public static abstract class FeatureUpdatedListener {
        public abstract void fireFeatureUpdated(SimpleFeature var1);
    }

    private class UpdateImageMosaicJob
    extends Job {
        private ImageMosaicReader imageReader;
        private int[] bands;
        private double[] colors;
        private ILayer layer;
        private SimpleFeature feature;
        private List<FeatureUpdatedListener> updateListener;

        public UpdateImageMosaicJob() {
            super("Update Image Moasic Job");
            this.imageReader = null;
        }

        public void setData(ImageMosaicReader reader, ILayer layer, SimpleFeature f, int redBand, int greenBand, int blueBand, double redColor, double greenColor, double blueColor, List<FeatureUpdatedListener> listener) {
            this.imageReader = reader;
            this.bands = new int[]{redBand, greenBand, blueBand};
            this.colors = new double[]{redColor, greenColor, blueColor};
            this.layer = layer;
            this.feature = f;
            this.updateListener = listener;
        }

        protected IStatus run(IProgressMonitor monitor) {
            String location = "location";
            MosaicInfoPanel.this.getFilterFactory().equals((Expression)MosaicInfoPanel.this.ff.property(location), (Expression)MosaicInfoPanel.this.ff.literal(this.feature.getAttribute(location)));
            this.layer.refresh(((Geometry)this.feature.getDefaultGeometry()).getEnvelopeInternal());
            this.fireUpdateListeners(this.feature);
            return Status.OK_STATUS;
        }

        private void fireUpdateListeners(SimpleFeature feature) {
            for (FeatureUpdatedListener listener : this.updateListener) {
                listener.fireFeatureUpdated(feature);
            }
        }
    }
}

