/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.renderer.jgttms;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import eu.udig.catalog.jgrass.core.JGTtmsGeoResource;
import eu.udig.catalog.jgrass.core.JGTtmsProperties;
import eu.udig.renderer.jgttms.GlobalMercator;
import eu.udig.renderer.jgttms.ImageCache;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.render.impl.RendererImpl;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.styling.RasterSymbolizer;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JGTtmsRenderer
extends RendererImpl {
    private static GlobalMercator gm = new GlobalMercator();
    private static final String EPSG_MERCATOR = "EPSG:3857";
    public static double[][] scaleList = new double[][]{{18.0, 1693.0, 0.597164, 0.844525, 1.194329}, {17.0, 3385.0, 1.194329, 1.689051, 2.388657}, {16.0, 6771.0, 2.388657, 3.378103, 4.777314}, {15.0, 14000.0, 4.777314, 6.756207, 9.554629}, {14.0, 27000.0, 9.554629, 13.512415, 19.109257}, {13.0, 54000.0, 19.109257, 27.024829, 38.218514}, {12.0, 108000.0, 38.218514, 54.049659, 76.437028}, {11.0, 217000.0, 76.437028, 108.099318, 152.874057}, {10.0, 433000.0, 152.874057, 216.198638, 305.748113}, {9.0, 867000.0, 305.748113, 432.397274, 611.496226}, {8.0, 2000000.0, 611.496226, 864.794549, 1222.992453}, {7.0, 3000000.0, 1222.992453, 1729.5891, 2445.984905}, {6.0, 7000000.0, 2445.984905, 3459.178199, 4891.96981}, {5.0, 1.4E7, 4891.96981, 6918.356399, 9783.939621}, {4.0, 2.8E7, 9783.939621, 13836.7128, 19567.879241}, {3.0, 5.5E7, 19567.879241, 27673.425598, 39135.758482}, {2.0, 1.11E8, 39135.758482, 55346.851197, 78271.516964}};

    public void render(Graphics2D g2d, IProgressMonitor monitor) throws RenderException {
        try {
            int j;
            IRenderContext currentContext = this.getContext();
            currentContext.setStatus(1);
            CoordinateReferenceSystem mercatorCrs = CRS.decode((String)EPSG_MERCATOR);
            DefaultGeographicCRS latLongCrs = DefaultGeographicCRS.WGS84;
            ReferencedEnvelope renderREnv = this.getRenderBounds();
            if (renderREnv == null || renderREnv.isNull()) {
                renderREnv = this.context.getImageBounds();
            }
            ReferencedEnvelope mercatorREnv = renderREnv.transform(mercatorCrs, true);
            ReferencedEnvelope latlongREnv = renderREnv.transform((CoordinateReferenceSystem)latLongCrs, true);
            Point upperLeft = currentContext.worldToPixel(new Coordinate(renderREnv.getMinX(), renderREnv.getMinY()));
            Point bottomRight = currentContext.worldToPixel(new Coordinate(renderREnv.getMaxX(), renderREnv.getMaxY()));
            Rectangle screenSize = new Rectangle(upperLeft);
            screenSize.add(bottomRight);
            IGeoResource resource = this.getContext().getGeoResource();
            if (resource == null || !resource.canResolve(JGTtmsGeoResource.class)) {
                this.getContext().setStatus(0);
                return;
            }
            JGTtmsGeoResource jgtTmsGeoResource = (JGTtmsGeoResource)((Object)resource.resolve(JGTtmsGeoResource.class, monitor));
            JGTtmsProperties tmsProperties = jgtTmsGeoResource.getTmsProperties();
            RasterSymbolizer rasterSymbolizer = CommonFactoryFinder.getStyleFactory(null).createRasterSymbolizer();
            double widthMeters = mercatorREnv.getWidth();
            int widthPixels = screenSize.width;
            double metersXPixel = widthMeters / (double)widthPixels;
            int nearestZoomLevel = this.getZoomLevelMetersXPixel(metersXPixel, latlongREnv.centre().y);
            double w = latlongREnv.getMinX();
            double s = latlongREnv.getMinY();
            double e = latlongREnv.getMaxX();
            double n = latlongREnv.getMaxY();
            int z = nearestZoomLevel;
            int[] llTileXY = gm.GoogleTile(s, w, z);
            int[] urTileXY = gm.GoogleTile(n, e, z);
            int startXTile = Math.min(llTileXY[0], urTileXY[0]);
            int endXTile = Math.max(llTileXY[0], urTileXY[0]);
            int startYTile = Math.min(llTileXY[1], urTileXY[1]);
            int endYTile = Math.max(llTileXY[1], urTileXY[1]);
            int tileNum = 0;
            int i = startXTile;
            while (i <= endXTile) {
                j = startYTile;
                while (j <= endYTile) {
                    ++tileNum;
                    ++j;
                }
                ++i;
            }
            if (tileNum > 30) {
                this.getContext().setStatus(0);
                this.getContext().setStatusMessage("Too many tiles needed for this zoomlevel");
                return;
            }
            try {
                i = startXTile;
                while (i <= endXTile) {
                    j = startYTile;
                    while (j <= endYTile) {
                        double south;
                        double west = (double)i / Math.pow(2.0, z) * 360.0 - 180.0;
                        double nn = Math.PI - Math.PI * 2 * (double)j / Math.pow(2.0, z);
                        double north = Math.toDegrees(Math.atan(Math.sinh(nn)));
                        double east = (double)(i + 1) / Math.pow(2.0, z) * 360.0 - 180.0;
                        ReferencedEnvelope tileBounds = new ReferencedEnvelope(west, east, south = Math.toDegrees(Math.atan(Math.sinh(nn = Math.PI - Math.PI * 2 * (double)(j + 1) / Math.pow(2.0, z)))), north, (CoordinateReferenceSystem)latLongCrs);
                        if (latlongREnv.intersects((BoundingBox)tileBounds)) {
                            int[] fileNameTileNumbers = new int[]{i, j};
                            if (tmsProperties.type == JGTtmsProperties.TILESCHEMA.tms) {
                                int[] tmsNUms = gm.TMSTileFromGoogleTile(i, j, z);
                                fileNameTileNumbers = tmsNUms;
                            } else {
                                JGTtmsProperties.TILESCHEMA cfr_ignored_0 = tmsProperties.type;
                            }
                            String tilePart = tmsProperties.tilePart.replaceFirst("ZZZ", String.valueOf(z));
                            tilePart = tilePart.replaceFirst("XXX", String.valueOf(fileNameTileNumbers[0]));
                            tilePart = tilePart.replaceFirst("YYY", String.valueOf(fileNameTileNumbers[1]));
                            File imageFile = new File(tmsProperties.HOST_NAME, tilePart);
                            if (imageFile.exists()) {
                                String imgPath = imageFile.getAbsolutePath();
                                BufferedImage image = ImageCache.getInstance().getImage(imgPath);
                                if (image == null) {
                                    image = ImageIO.read(imageFile);
                                    ImageCache.getInstance().addImage(imgPath, image);
                                }
                                ReferencedEnvelope mercatorTileBounds = tileBounds.transform(mercatorCrs, true);
                                this.renderTile(g2d, image, mercatorTileBounds, rasterSymbolizer);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        finally {
            this.getContext().setStatus(0);
            this.getContext().setStatusMessage(null);
        }
    }

    private void renderTile(Graphics2D graphics, BufferedImage image, ReferencedEnvelope tileEnvelope, RasterSymbolizer style) throws Exception {
        if (image == null) {
            return;
        }
        GridCoverageFactory factory = new GridCoverageFactory();
        GridCoverage2D coverage = factory.create((CharSequence)"GridCoverage", (RenderedImage)image, (org.opengis.geometry.Envelope)tileEnvelope);
        CoordinateReferenceSystem mapCrs = this.getContext().getCRS();
        ReferencedEnvelope tileMapCrsEnvelope = tileEnvelope.transform(mapCrs, true);
        Point upperLeft = this.getContext().worldToPixel(new Coordinate(tileMapCrsEnvelope.getMinX(), tileMapCrsEnvelope.getMinY()));
        Point bottomRight = this.getContext().worldToPixel(new Coordinate(tileMapCrsEnvelope.getMaxX(), tileMapCrsEnvelope.getMaxY()));
        Rectangle tileSize = new Rectangle(upperLeft);
        tileSize.add(bottomRight);
        try {
            AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)tileMapCrsEnvelope, (Rectangle)tileSize);
            GridCoverageRenderer paint = new GridCoverageRenderer(mapCrs, (Envelope)tileMapCrsEnvelope, tileSize, worldToScreen);
            paint.paint(graphics, coverage, style);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public int getZoomLevelMetersXPixel(double metersXPixel, double lat) {
        int column = 3;
        if (lat > -30.0 && lat < 30.0) {
            column = 2;
        }
        if (lat < -75.0 || lat > 75.0) {
            column = 4;
        }
        if (metersXPixel <= scaleList[0][column]) {
            return (int)scaleList[0][0];
        }
        if (metersXPixel >= scaleList[scaleList.length - 1][column]) {
            return (int)scaleList[scaleList.length - 1][0];
        }
        int i = 0;
        while (i < scaleList.length - 1) {
            double s1 = scaleList[i][column];
            double s2 = scaleList[i + 1][column];
            if (metersXPixel >= s1 && metersXPixel < s2) {
                return (int)scaleList[i + 1][0];
            }
            ++i;
        }
        throw new RuntimeException();
    }

    public void render(IProgressMonitor monitor) throws RenderException {
        Graphics2D g2d = this.getContext().getImage().createGraphics();
        this.render(g2d, monitor);
    }

    public void dispose() {
        ImageCache.getInstance().dispose();
    }
}

