/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.workspacecreation;

import eu.udig.catalog.jgrass.workspacecreation.NewJGrassLocationWizard;
import eu.udig.catalog.jgrass.workspacecreation.WorkspaceProperties;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class W03CreateLocationWizardPage
extends WizardPage {
    public static final String ID = "W03CreateLocationWizardPage";
    private final WorkspaceProperties properties;
    private TableViewer lv;
    private List<String> mapsetNames = null;

    public W03CreateLocationWizardPage(WorkspaceProperties properties) {
        super(ID);
        this.properties = properties;
        this.setTitle("Add mapsets to the location");
        this.setDescription("In this page the user is asked to supply additional mapsets to be used in the location.");
        this.mapsetNames = properties.mapsets;
    }

    public void createControl(Composite maxparent) {
        Composite parent = new Composite(maxparent, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        final Text newMapseText = new Text(parent, 2048);
        newMapseText.setLayoutData((Object)new GridData(768));
        Button addButton = new Button(parent, 8);
        addButton.setText("  add  ");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String mapset = newMapseText.getText();
                if (mapset.length() > 0) {
                    if (mapset.indexOf(32) != -1) {
                        MessageBox msgBox = new MessageBox(newMapseText.getShell(), 1);
                        msgBox.setMessage("Mapset names can't contain spaces. Please choose a name without spaces.");
                        msgBox.open();
                        return;
                    }
                    W03CreateLocationWizardPage.this.mapsetNames.add(mapset);
                    W03CreateLocationWizardPage.this.lv.setInput((Object)W03CreateLocationWizardPage.this.mapsetNames);
                    newMapseText.setText("");
                    if (W03CreateLocationWizardPage.this.mapsetNames.size() > 0) {
                        W03CreateLocationWizardPage.this.canDoFinish(true);
                    } else {
                        W03CreateLocationWizardPage.this.canDoFinish(false);
                    }
                }
            }
        });
        this.lv = new TableViewer(parent);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.lv.getControl().setLayoutData((Object)gd);
        this.lv.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.lv.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.lv.setInput(this.mapsetNames);
        MenuManager popManager = new MenuManager();
        Menu menu = popManager.createContextMenu((Control)this.lv.getTable());
        this.lv.getTable().setMenu(menu);
        Action clearAction = new Action(){

            public void run() {
                W03CreateLocationWizardPage.this.mapsetNames.clear();
                W03CreateLocationWizardPage.this.mapsetNames.add("PERMANENT");
                W03CreateLocationWizardPage.this.lv.setInput((Object)W03CreateLocationWizardPage.this.mapsetNames);
                W03CreateLocationWizardPage.this.canDoFinish(false);
            }
        };
        clearAction.setText("Clear all entries");
        popManager.add((IAction)clearAction);
        Action deleteSelectedAction = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)W03CreateLocationWizardPage.this.lv.getSelection();
                String sel = (String)selection.getFirstElement();
                if (sel.equals("PERMANENT")) {
                    return;
                }
                W03CreateLocationWizardPage.this.mapsetNames.remove(sel);
                W03CreateLocationWizardPage.this.lv.setInput((Object)W03CreateLocationWizardPage.this.mapsetNames);
                if (W03CreateLocationWizardPage.this.mapsetNames.size() > 0) {
                    W03CreateLocationWizardPage.this.canDoFinish(true);
                } else {
                    W03CreateLocationWizardPage.this.canDoFinish(false);
                }
            }
        };
        deleteSelectedAction.setText("Clear selected entries");
        popManager.add((IAction)deleteSelectedAction);
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.canDoFinish(false);
        }
        super.setVisible(visible);
    }

    private void canDoFinish(boolean canDoFinish) {
        ((NewJGrassLocationWizard)this.getWizard()).canFinish = canDoFinish;
        this.getWizard().getContainer().updateButtons();
    }
}

