/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.workspacecreation;

import eu.udig.catalog.jgrass.core.ChooseCoordinateReferenceSystemDialog;
import eu.udig.catalog.jgrass.workspacecreation.NewJGrassLocationWizard;
import eu.udig.catalog.jgrass.workspacecreation.WorkspaceProperties;
import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class W01CreateLocationWizardPage
extends WizardPage {
    public static final String ID = "W01CreateLocationWizardPage";
    private final WorkspaceProperties properties;

    public W01CreateLocationWizardPage(WorkspaceProperties properties) {
        super(ID);
        this.properties = properties;
        this.setTitle("Setting the location path and projection");
        this.setDescription("In this page the user is asked to supply the new location path and its coordinate reference system.");
    }

    public void createControl(Composite maxparent) {
        Composite parent = new Composite(maxparent, 0);
        parent.setLayout((Layout)new GridLayout());
        Group locPathGroup = new Group(parent, 0);
        locPathGroup.setLayout((Layout)new GridLayout(2, false));
        locPathGroup.setLayoutData((Object)new GridData(1808));
        locPathGroup.setText("choose the path for the new location");
        final Text locPathText = new Text((Composite)locPathGroup, 2048);
        locPathText.setLayoutData((Object)new GridData(1796));
        locPathText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                String path;
                ((W01CreateLocationWizardPage)W01CreateLocationWizardPage.this).properties.locationPath = path = locPathText.getText();
            }
        });
        final Button locationPathChooseButton = new Button((Composite)locPathGroup, 2048);
        locationPathChooseButton.setText("...");
        locationPathChooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(locationPathChooseButton.getShell(), 8192);
                String path = fileDialog.open();
                if (path == null || path.length() < 1) {
                    locPathText.setText("");
                } else {
                    File locationFile = new File(path);
                    String locationName = locationFile.getName();
                    if (locationName.indexOf(32) != -1) {
                        MessageBox msgBox = new MessageBox(locationPathChooseButton.getShell(), 1);
                        msgBox.setMessage("Location names can't contain spaces. Please choose a name without spaces.");
                        msgBox.open();
                        locPathText.setText("");
                        return;
                    }
                    locPathText.setText(path);
                    ((W01CreateLocationWizardPage)W01CreateLocationWizardPage.this).properties.locationPath = path;
                }
            }
        });
        Group crsGroup = new Group(parent, 0);
        crsGroup.setLayout((Layout)new GridLayout(2, false));
        crsGroup.setLayoutData((Object)new GridData(1808));
        crsGroup.setText("choose the coordinate reference system for the new location");
        final Text crsText = new Text((Composite)crsGroup, 2048);
        crsText.setLayoutData((Object)new GridData(1796));
        crsText.setEditable(false);
        Button crsButton = new Button((Composite)crsGroup, 2048);
        crsButton.setText(" Choose CRS ");
        crsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseCoordinateReferenceSystemDialog crsChooser = new ChooseCoordinateReferenceSystemDialog();
                crsChooser.open(new Shell(Display.getDefault()));
                CoordinateReferenceSystem readCrs = crsChooser.getCrs();
                if (readCrs == null) {
                    return;
                }
                ((W01CreateLocationWizardPage)W01CreateLocationWizardPage.this).properties.crs = readCrs;
                crsText.setText(readCrs.getName().toString());
            }
        });
        this.setControl((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            ((NewJGrassLocationWizard)this.getWizard()).canFinish = false;
            this.getWizard().getContainer().updateButtons();
        }
        super.setVisible(visible);
    }
}

