/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.workspacecreation;

import eu.udig.catalog.jgrass.JGrassPlugin;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import eu.udig.catalog.jgrass.workspacecreation.W01CreateLocationWizardPage;
import eu.udig.catalog.jgrass.workspacecreation.W02CreateLocationWizardPage;
import eu.udig.catalog.jgrass.workspacecreation.W03CreateLocationWizardPage;
import eu.udig.catalog.jgrass.workspacecreation.WorkspaceProperties;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.gce.grassraster.JGrassRegion;

public class NewJGrassLocationWizard
extends Wizard
implements INewWizard {
    public boolean canFinish = false;
    private WorkspaceProperties props;

    public NewJGrassLocationWizard() {
        this.setWindowTitle("Creation of a new JGrass location");
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/simulwizard.png"));
    }

    public void addPages() {
        this.props = new WorkspaceProperties();
        W01CreateLocationWizardPage page1 = new W01CreateLocationWizardPage(this.props);
        this.addPage((IWizardPage)page1);
        W02CreateLocationWizardPage page2 = new W02CreateLocationWizardPage(this.props);
        this.addPage((IWizardPage)page2);
        W03CreateLocationWizardPage page3 = new W03CreateLocationWizardPage(this.props);
        this.addPage((IWizardPage)page3);
    }

    public boolean performFinish() {
        for (String m : this.props.mapsets) {
            System.out.println(m);
        }
        System.out.println(this.props.locationPath);
        System.out.println(this.props.north);
        System.out.println(this.props.xres);
        System.out.println(this.props.crs.getName().toString());
        try {
            JGrassRegion window = new JGrassRegion(this.props.west, this.props.east, this.props.south, this.props.north, this.props.xres, this.props.yres);
            JGrassCatalogUtilities.createLocation(this.props.locationPath, this.props.crs, window);
            for (String mapset : this.props.mapsets) {
                JGrassCatalogUtilities.createMapset(this.props.locationPath, mapset, null, null);
                String mapsetPath = String.valueOf(this.props.locationPath) + File.separator + mapset;
                JGrassRegion.writeWINDToMapset((String)mapsetPath, (JGrassRegion)window);
            }
            JGrassCatalogUtilities.addServiceToCatalog(String.valueOf(this.props.locationPath) + File.separator + "wks.jgrass", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.workspacecreation.wizard#NewJGrassLocationWizard#performFinish", e);
            e.printStackTrace();
        }
        return true;
    }

    public boolean canFinish() {
        return this.canFinish;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

