/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.operations;

import com.vividsolutions.jts.geom.Envelope;
import eu.udig.catalog.jgrass.JGrassPlugin;
import eu.udig.catalog.jgrass.activeregion.ActiveRegionStyle;
import eu.udig.catalog.jgrass.activeregion.ActiveregionStyleContent;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.PlatformGIS;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.referencing.CRS;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SetActiveRegionToMapsAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate {
    IStructuredSelection selection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(final IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        List toList = (this).SetActiveRegionToMapsAction.this.selection.toList();
                        Envelope bounds = null;
                        try {
                            pm.beginTask("Set active region to maps bounds...", toList.size());
                            try {
                                JGrassRegion currentRegion = null;
                                JGrassMapEnvironment grassMapEnvironment = null;
                                for (Object object : toList) {
                                    if (object instanceof JGrassMapGeoResource) {
                                        JGrassMapGeoResource mr = (JGrassMapGeoResource)((Object)object);
                                        JGrassRegion fileWindow = mr.getFileWindow();
                                        if (currentRegion == null) {
                                            currentRegion = mr.getActiveWindow();
                                            grassMapEnvironment = mr.getjGrassMapEnvironment();
                                        }
                                        Envelope envelope = fileWindow.getEnvelope();
                                        if (bounds == null) {
                                            bounds = envelope;
                                        } else {
                                            bounds.expandToInclude(envelope);
                                        }
                                    }
                                    pm.worked(1);
                                }
                                String code = null;
                                try {
                                    CoordinateReferenceSystem jGrassCrs = grassMapEnvironment.getCoordinateReferenceSystem();
                                    try {
                                        Integer epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)jGrassCrs, (boolean)true);
                                        code = "EPSG:" + epsg;
                                    }
                                    catch (Exception exception) {
                                        code = CRS.lookupIdentifier((IdentifiedObject)jGrassCrs, (boolean)true);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                JGrassRegion newActiveRegion = JGrassRegion.adaptActiveRegionToEnvelope(bounds, currentRegion);
                                File windFile = grassMapEnvironment.getWIND();
                                JGrassRegion.writeWINDToMapset((String)windFile.getParent(), (JGrassRegion)newActiveRegion);
                                IMap activeMap = ApplicationGIS.getActiveMap();
                                IBlackboard blackboard = activeMap.getBlackboard();
                                ActiveRegionStyle style = (ActiveRegionStyle)blackboard.get("eu.udig.catalog.jgrass.activeregion.activeregionStyle");
                                if (style == null) {
                                    style = ActiveregionStyleContent.createDefault();
                                }
                                style.north = (float)newActiveRegion.getNorth();
                                style.south = (float)newActiveRegion.getSouth();
                                style.east = (float)newActiveRegion.getEast();
                                style.west = (float)newActiveRegion.getWest();
                                style.rows = newActiveRegion.getRows();
                                style.cols = newActiveRegion.getCols();
                                style.windPath = windFile.getAbsolutePath();
                                style.crsString = code;
                                blackboard.put("eu.udig.catalog.jgrass.activeregion.activeregionStyle", (Object)style);
                                ILayer activeRegionMapGraphic = JGrassPlugin.getDefault().getActiveRegionMapGraphic();
                                activeRegionMapGraphic.refresh(null);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                String message = "Problems occurred while setting the new active region.";
                                ExceptionDetailsDialog.openError((String)"Information", (String)message, (int)4, (String)"eu.udig.catalog.jgrass", (Throwable)e);
                            }
                        }
                        finally {
                            pm.done();
                        }
                    }
                });
            }
        };
        PlatformGIS.runInProgressDialog((String)"Set active region...", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public void removeGrassRasterMap(String mapsetPath, String mapName) throws IOException {
        String[] mappaths = this.filesOfRasterMap(mapsetPath, mapName);
        int j = 0;
        while (j < mappaths.length) {
            File filetoremove = new File(mappaths[j]);
            if (filetoremove.exists()) {
                FileUtils.forceDelete((File)filetoremove);
            }
            ++j;
        }
    }

    public String[] filesOfRasterMap(String mapsetPath, String mapname) {
        String[] filesOfRaster = new String[]{String.valueOf(mapsetPath) + File.separator + "fcell" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "cell" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "cats" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "hist" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "cellhd" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "colr" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "cell_misc" + File.separator + mapname, String.valueOf(mapsetPath) + File.separator + "cell_misc" + File.separator + mapname + File.separator + "f_format", String.valueOf(mapsetPath) + File.separator + "cell_misc" + File.separator + mapname + File.separator + "f_quant", String.valueOf(mapsetPath) + File.separator + "cell_misc" + File.separator + mapname + File.separator + "f_range", String.valueOf(mapsetPath) + File.separator + "cell_misc" + File.separator + mapname + File.separator + "null"};
        return filesOfRaster;
    }
}

