/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.operations;

import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.PlatformGIS;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.processing.Operations;
import org.geotools.gce.arcgrid.ArcGridReader;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.grassraster.GrassCoverageWriter;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.format.GrassCoverageFormat;
import org.geotools.gce.grassraster.format.GrassCoverageFormatFactory;
import org.geotools.referencing.CRS;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ImportEsriAsciiOrGeotiffAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate {
    IStructuredSelection selection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(final IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                        Object firstElement = (this).ImportEsriAsciiOrGeotiffAction.this.selection.getFirstElement();
                        if (firstElement instanceof JGrassMapsetGeoResource) {
                            try {
                                JGrassMapsetGeoResource mapsetResource = (JGrassMapsetGeoResource)firstElement;
                                File mapsetFile = mapsetResource.getFile();
                                FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 4098);
                                fileDialog.setFilterExtensions(new String[]{"*.asc", "*.ASC", "*.tif", "*.TIF", "*.tiff", "*.TIFF", "*.*"});
                                String selpath = fileDialog.open();
                                if (selpath == null) {
                                    return;
                                }
                                File mapFile = new File(selpath);
                                if (!mapFile.exists()) {
                                    return;
                                }
                                try {
                                    File folder = mapFile.getParentFile();
                                    String[] fileNames = fileDialog.getFileNames();
                                    pm.beginTask("Importing maps...", fileNames.length);
                                    int i = 0;
                                    while (i < fileNames.length) {
                                        mapFile = new File(folder, fileNames[i]);
                                        CoordinateReferenceSystem jGrassCrs = mapsetResource.getLocationCrs();
                                        GridCoverage2D geodata = null;
                                        CoordinateReferenceSystem fileCrs = null;
                                        if (mapFile.getName().toLowerCase().endsWith(".asc")) {
                                            ArcGridReader arcGridReader = new ArcGridReader((Object)mapFile);
                                            geodata = arcGridReader.read(null);
                                            geodata = geodata.view(ViewType.GEOPHYSICS);
                                            geodata = JGrassCatalogUtilities.removeNovalues(geodata);
                                            fileCrs = arcGridReader.getCrs();
                                        } else if (mapFile.getName().toLowerCase().endsWith(".tif") || mapFile.getName().toLowerCase().endsWith(".tiff")) {
                                            GeoTiffReader geotiffGridReader = new GeoTiffReader((Object)mapFile);
                                            geodata = geotiffGridReader.read(null);
                                            geodata = geodata.view(ViewType.GEOPHYSICS);
                                            geodata = JGrassCatalogUtilities.removeNovalues(geodata);
                                            fileCrs = geotiffGridReader.getCrs();
                                        }
                                        if (!CRS.equalsIgnoreMetadata((Object)jGrassCrs, fileCrs)) {
                                            geodata = (GridCoverage2D)Operations.DEFAULT.resample((Coverage)geodata, jGrassCrs);
                                        }
                                        String mapName = mapFile.getName();
                                        mapName = FilenameUtils.getBaseName((String)mapName);
                                        JGrassMapEnvironment mapEnvironment = new JGrassMapEnvironment(mapsetFile, mapName);
                                        GrassCoverageFormat format = new GrassCoverageFormatFactory().createFormat();
                                        GrassCoverageWriter writer = format.getWriter((Object)mapEnvironment.getCELL(), null);
                                        GeneralParameterValue[] readParams = null;
                                        writer.write((GridCoverage)geodata, readParams);
                                        JGrassCatalogUtilities.addMapToCatalog(mapsetFile.getParent(), mapsetFile.getName(), mapName, "grassbinaryraster");
                                        pm.worked(1);
                                        ++i;
                                    }
                                    MessageDialog.openInformation((Shell)shell, (String)"IMPORT", (String)"Maps successfully imported");
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    String message = "An error occurred while importing the map.";
                                    ExceptionDetailsDialog.openError((String)"ERROR", (String)message, (int)4, (String)"eu.udig.catalog.jgrass", (Throwable)e);
                                }
                            }
                            finally {
                                pm.done();
                            }
                        }
                    }
                });
            }
        };
        PlatformGIS.runInProgressDialog((String)"Import maps...", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public Menu getMenu(Control parent) {
        return null;
    }
}

