/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.operations;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import eu.udig.catalog.jgrass.core.ChooseCoordinateReferenceSystemDialog;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.Interpolation;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.processing.Operations;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class GrassReprojectAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate {
    IStructuredSelection selection = null;
    private String locationName;
    private String mapsetName;
    private String xRes;
    private String yRes;
    private CoordinateReferenceSystem crs;
    private File mapsetFile;
    private int open;
    private Shell shell;
    private List<JGrassMapGeoResource> maps = new ArrayList<JGrassMapGeoResource>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GrassReprojectAction.this.shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                GrassReprojectAction.this.maps.clear();
                List toList = GrassReprojectAction.this.selection.toList();
                try {
                    for (Object object : toList) {
                        if (!(object instanceof JGrassMapGeoResource)) continue;
                        JGrassMapGeoResource mr = (JGrassMapGeoResource)((Object)object);
                        GrassReprojectAction.this.maps.add(mr);
                    }
                    Dialog dialog = new Dialog(GrassReprojectAction.this.shell){
                        private Text locNameText;
                        private Text mapsetNameText;
                        private Text crsText;
                        private Text xresText;
                        private Text yresText;

                        protected Control createDialogArea(Composite maxparent) {
                            Composite parent = new Composite(maxparent, 0);
                            parent.setLayout((Layout)new GridLayout());
                            parent.setLayoutData((Object)new GridData(1808));
                            Group locNameGroup = new Group(parent, 0);
                            locNameGroup.setLayout((Layout)new GridLayout(2, false));
                            locNameGroup.setLayoutData((Object)new GridData(1808));
                            locNameGroup.setText("new location name");
                            this.locNameText = new Text((Composite)locNameGroup, 2048);
                            this.locNameText.setLayoutData((Object)new GridData(1796));
                            this.locNameText.setText("newLocation");
                            Group mapsetNameGroup = new Group(parent, 0);
                            mapsetNameGroup.setLayout((Layout)new GridLayout(2, false));
                            mapsetNameGroup.setLayoutData((Object)new GridData(1808));
                            mapsetNameGroup.setText("new mapset name");
                            this.mapsetNameText = new Text((Composite)mapsetNameGroup, 2048);
                            this.mapsetNameText.setLayoutData((Object)new GridData(1796));
                            this.mapsetNameText.setText("newMapset");
                            Group crsGroup = new Group(parent, 0);
                            crsGroup.setLayout((Layout)new GridLayout(2, false));
                            crsGroup.setLayoutData((Object)new GridData(1808));
                            crsGroup.setText("choose the coordinate reference system for the new location");
                            this.crsText = new Text((Composite)crsGroup, 2048);
                            this.crsText.setLayoutData((Object)new GridData(1796));
                            this.crsText.setEditable(false);
                            Button crsButton = new Button((Composite)crsGroup, 2048);
                            crsButton.setText(" Choose CRS ");
                            crsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    ChooseCoordinateReferenceSystemDialog crsChooser = new ChooseCoordinateReferenceSystemDialog();
                                    crsChooser.open(new Shell(Display.getDefault()));
                                    CoordinateReferenceSystem readCrs = crsChooser.getCrs();
                                    if (readCrs == null) {
                                        return;
                                    }
                                    crsText.setText(readCrs.getName().toString());
                                    crsText.setData((Object)readCrs);
                                }
                            });
                            Group resolutionGroup = new Group(parent, 0);
                            resolutionGroup.setLayout((Layout)new GridLayout(2, false));
                            resolutionGroup.setLayoutData((Object)new GridData(1808));
                            resolutionGroup.setText("output map resolution");
                            String res = "";
                            if (GrassReprojectAction.this.maps.size() > 0) {
                                try {
                                    JGrassRegion activeWindow = ((JGrassMapGeoResource)((Object)GrassReprojectAction.this.maps.get(0))).getActiveWindow();
                                    res = String.valueOf(activeWindow.getNSResolution());
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                            Label xresLabel = new Label((Composite)resolutionGroup, 0);
                            xresLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                            xresLabel.setText("X resolution");
                            this.xresText = new Text((Composite)resolutionGroup, 2048);
                            this.xresText.setLayoutData((Object)new GridData(1796));
                            this.xresText.setText(res);
                            Label yresLabel = new Label((Composite)resolutionGroup, 0);
                            yresLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                            yresLabel.setText("Y resolution");
                            this.yresText = new Text((Composite)resolutionGroup, 2048);
                            this.yresText.setLayoutData((Object)new GridData(1796));
                            this.yresText.setText(res);
                            return parent;
                        }

                        protected void okPressed() {
                            GrassReprojectAction.this.locationName = this.locNameText.getText();
                            if (GrassReprojectAction.this.locationName == null || GrassReprojectAction.this.locationName.length() < 1) {
                                GrassReprojectAction.this.locationName = "newLocation";
                            }
                            GrassReprojectAction.this.mapsetName = this.mapsetNameText.getText();
                            if (GrassReprojectAction.this.mapsetName == null || GrassReprojectAction.this.mapsetName.length() < 1) {
                                GrassReprojectAction.this.mapsetName = "newMapset";
                            }
                            GrassReprojectAction.this.xRes = this.xresText.getText();
                            GrassReprojectAction.this.yRes = this.yresText.getText();
                            Object crsData = this.crsText.getData();
                            if (crsData instanceof CoordinateReferenceSystem) {
                                GrassReprojectAction.this.crs = (CoordinateReferenceSystem)crsData;
                            }
                            super.okPressed();
                        }
                    };
                    dialog.setBlockOnOpen(true);
                    GrassReprojectAction.this.open = dialog.open();
                }
                catch (Exception e) {
                    String message = "An error occurred while exporting the maps.";
                    ExceptionDetailsDialog.openError((String)"ERROR", (String)message, (int)4, (String)"eu.udig.catalog.jgrass", (Throwable)e);
                }
            }
        });
        if (this.open == 256) {
            return;
        }
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (GrassReprojectAction.this.locationName == null || GrassReprojectAction.this.mapsetName == null || GrassReprojectAction.this.crs == null || GrassReprojectAction.this.maps.size() < 1) {
                    MessageBox msgBox = new MessageBox(GrassReprojectAction.this.shell, 1);
                    msgBox.setMessage("An error occurred in processing the user supplied data.");
                    msgBox.open();
                    return;
                }
                int mapNum = GrassReprojectAction.this.maps.size();
                monitor.beginTask("Reprojecting maps to new Location...", mapNum);
                int i = 0;
                while (i < mapNum) {
                    JGrassMapGeoResource tmpMap = (JGrassMapGeoResource)((Object)GrassReprojectAction.this.maps.get(i));
                    JGrassMapEnvironment jgMEnv = new JGrassMapEnvironment(tmpMap.getMapFile());
                    try {
                        JGrassRegion sourceRegion = jgMEnv.getActiveRegion();
                        CoordinateReferenceSystem sourceCrs = jgMEnv.getCoordinateReferenceSystem();
                        Envelope sourceEnvelope = sourceRegion.getEnvelope();
                        MathTransform tr = CRS.findMathTransform((CoordinateReferenceSystem)sourceCrs, (CoordinateReferenceSystem)GrassReprojectAction.this.crs);
                        Envelope outputEnvelope = JTS.transform((Envelope)sourceEnvelope, (MathTransform)tr);
                        double west = outputEnvelope.getMinX();
                        double east = outputEnvelope.getMaxX();
                        double south = outputEnvelope.getMinY();
                        double north = outputEnvelope.getMaxY();
                        double xResolution = Double.parseDouble(GrassReprojectAction.this.xRes);
                        double yResolution = Double.parseDouble(GrassReprojectAction.this.yRes);
                        Coordinate tmp1 = new Coordinate(west, south);
                        Coordinate tmp2 = new Coordinate(west + xResolution, south + yResolution);
                        JTS.transform((Coordinate)tmp1, (Coordinate)tmp1, (MathTransform)tr);
                        JTS.transform((Coordinate)tmp2, (Coordinate)tmp2, (MathTransform)tr);
                        xResolution = tmp2.x - tmp1.x;
                        yResolution = tmp2.y - tmp1.y;
                        int intWest = (int)Math.floor(west);
                        int intSouth = (int)Math.floor(south);
                        if (west - (double)intWest < xResolution && south - (double)intSouth < yResolution) {
                            west = intWest;
                            south = intSouth;
                        }
                        double w = east - west;
                        double h = north - south;
                        double cols = Math.floor(w / xResolution) + 1.0;
                        double rows = Math.floor(h / yResolution) + 1.0;
                        double newEast = west + cols * xResolution;
                        double newNorth = south + rows * yResolution;
                        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(west, newEast, south, newNorth, GrassReprojectAction.this.crs);
                        GridToEnvelopeMapper g2eMapper = new GridToEnvelopeMapper();
                        g2eMapper.setEnvelope((org.opengis.geometry.Envelope)referencedEnvelope);
                        GridEnvelope2D gridEnvelope2D = new GridEnvelope2D(0, 0, (int)cols, (int)rows);
                        g2eMapper.setGridRange((GridEnvelope)gridEnvelope2D);
                        g2eMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
                        MathTransform gridToEnvelopeTransform = g2eMapper.createTransform();
                        GridGeometry2D outputGridGeometry = new GridGeometry2D((GridEnvelope)gridEnvelope2D, gridToEnvelopeTransform, GrassReprojectAction.this.crs);
                        GridCoverage2D coverage2D = JGrassCatalogUtilities.getGridcoverageFromGrassraster(jgMEnv, sourceRegion);
                        GridCoverage2D reprojected = (GridCoverage2D)Operations.DEFAULT.resample((GridCoverage)coverage2D, GrassReprojectAction.this.crs, (GridGeometry)outputGridGeometry, Interpolation.getInstance((int)2));
                        JGrassRegion jgRegion = new JGrassRegion(west, newEast, south, newNorth, xResolution, yResolution);
                        if (i == 0) {
                            File grassDbFile = jgMEnv.getLOCATION().getParentFile();
                            File newLocationFile = new File(grassDbFile, GrassReprojectAction.this.locationName);
                            try {
                                JGrassCatalogUtilities.createLocation(newLocationFile.getAbsolutePath(), GrassReprojectAction.this.crs, jgRegion);
                                JGrassCatalogUtilities.createMapset(newLocationFile.getAbsolutePath(), GrassReprojectAction.this.mapsetName, null, jgRegion);
                            }
                            catch (Exception exception) {}
                            GrassReprojectAction.this.mapsetFile = new File(newLocationFile, GrassReprojectAction.this.mapsetName);
                        }
                        File newMapFile = new File(GrassReprojectAction.this.mapsetFile, "cell" + File.separator + tmpMap.getMapFile().getName());
                        JGrassCatalogUtilities.writeGridCoverageFromGrassraster(newMapFile, jgRegion, reprojected);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    monitor.worked(1);
                    ++i;
                }
                monitor.done();
                JGrassCatalogUtilities.addServiceToCatalog(String.valueOf(GrassReprojectAction.this.mapsetFile.getParent()) + File.separator + "wks.jgrass", (IProgressMonitor)new NullProgressMonitor());
            }
        };
        PlatformGIS.runInProgressDialog((String)"Reprojecting maps to new Location...", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public static GeneralParameterValue[] createGridGeometryGeneralParameter(int width, int height, double north, double south, double east, double west, CoordinateReferenceSystem crs) {
        ReferencedEnvelope env;
        GeneralParameterValue[] readParams = new GeneralParameterValue[1];
        Parameter readGG = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
        GridEnvelope2D gridEnvelope = new GridEnvelope2D(0, 0, width, height);
        if (crs != null) {
            env = new ReferencedEnvelope(west, east, south, north, crs);
        } else {
            DirectPosition2D minDp = new DirectPosition2D(west, south);
            DirectPosition2D maxDp = new DirectPosition2D(east, north);
            env = new Envelope2D(minDp, maxDp);
        }
        readGG.setValue((Object)new GridGeometry2D((GridEnvelope)gridEnvelope, (org.opengis.geometry.Envelope)env));
        readParams[0] = readGG;
        return readParams;
    }
}

