/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.operations;

import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.arcgrid.ArcGridFormat;
import org.geotools.gce.arcgrid.ArcGridWriteParams;
import org.geotools.gce.arcgrid.ArcGridWriter;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.format.GrassCoverageFormat;
import org.geotools.gce.grassraster.format.GrassCoverageFormatFactory;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ExportEsriAsciiAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate {
    IStructuredSelection selection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(final IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                        DirectoryDialog folderDialog = new DirectoryDialog(shell, 4096);
                        String selpath = folderDialog.open();
                        if (selpath == null) {
                            return;
                        }
                        File folderFile = new File(selpath);
                        if (!folderFile.exists()) {
                            return;
                        }
                        List toList = (this).ExportEsriAsciiAction.this.selection.toList();
                        try {
                            try {
                                pm.beginTask("Exporting maps...", toList.size());
                                for (Object object : toList) {
                                    if (object instanceof JGrassMapGeoResource) {
                                        JGrassMapGeoResource mr = (JGrassMapGeoResource)((Object)object);
                                        File mapFile = mr.getMapFile();
                                        JGrassMapEnvironment mapEnvironment = new JGrassMapEnvironment(mapFile);
                                        JGrassRegion jGrassRegion = mapEnvironment.getActiveRegion();
                                        GeneralParameterValue[] readParams = ExportEsriAsciiAction.createGridGeometryGeneralParameter(jGrassRegion.getCols(), jGrassRegion.getRows(), jGrassRegion.getNorth(), jGrassRegion.getSouth(), jGrassRegion.getEast(), jGrassRegion.getWest(), mapEnvironment.getCoordinateReferenceSystem());
                                        GrassCoverageFormat format = new GrassCoverageFormatFactory().createFormat();
                                        AbstractGridCoverage2DReader reader = format.getReader((Object)mapEnvironment.getCELL());
                                        GridCoverage2D geodata = (GridCoverage2D)reader.read(readParams);
                                        geodata = geodata.view(ViewType.GEOPHYSICS);
                                        ArcGridFormat format1 = new ArcGridFormat();
                                        ArcGridWriteParams wp = new ArcGridWriteParams();
                                        ParameterValueGroup paramWrite = format1.getWriteParameters();
                                        paramWrite.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
                                        ArcGridWriter gtw = (ArcGridWriter)format1.getWriter((Object)new File(folderFile, String.valueOf(mapFile.getName()) + ".asc"));
                                        gtw.write((GridCoverage)geodata, paramWrite.values().toArray(new GeneralParameterValue[1]));
                                        gtw.dispose();
                                    }
                                    pm.worked(1);
                                }
                            }
                            catch (Exception e) {
                                String message = "An error occurred while exporting the maps.";
                                ExceptionDetailsDialog.openError((String)"ERROR", (String)message, (int)4, (String)"eu.udig.catalog.jgrass", (Throwable)e);
                                pm.done();
                            }
                        }
                        finally {
                            pm.done();
                        }
                    }
                });
            }
        };
        PlatformGIS.runInProgressDialog((String)"Export maps...", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public static GeneralParameterValue[] createGridGeometryGeneralParameter(int width, int height, double north, double south, double east, double west, CoordinateReferenceSystem crs) {
        ReferencedEnvelope env;
        GeneralParameterValue[] readParams = new GeneralParameterValue[1];
        Parameter readGG = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
        GridEnvelope2D gridEnvelope = new GridEnvelope2D(0, 0, width, height);
        if (crs != null) {
            env = new ReferencedEnvelope(west, east, south, north, crs);
        } else {
            DirectPosition2D minDp = new DirectPosition2D(west, south);
            DirectPosition2D maxDp = new DirectPosition2D(east, north);
            env = new Envelope2D(minDp, maxDp);
        }
        readGG.setValue((Object)new GridGeometry2D((GridEnvelope)gridEnvelope, (Envelope)env));
        readParams[0] = readGG;
        return readParams;
    }
}

