/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.operations;

import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.format.GrassCoverageFormat;
import org.geotools.gce.grassraster.format.GrassCoverageFormatFactory;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CopyOnActiveRegionAction
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate {
    IStructuredSelection selection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(final IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                        Object object = (this).CopyOnActiveRegionAction.this.selection.getFirstElement();
                        try {
                            try {
                                pm.beginTask("Duplicating map...", -1);
                                pm.worked(1);
                                if (object instanceof JGrassMapGeoResource) {
                                    JGrassMapGeoResource mr = (JGrassMapGeoResource)((Object)object);
                                    File oldMapFile = mr.getMapFile();
                                    String oldMapName = oldMapFile.getName();
                                    InputDialog iDialog = new InputDialog(shell, "New map name", "Please enter the new name for the map: " + oldMapName, String.valueOf(oldMapName) + "_new", null);
                                    iDialog.open();
                                    String newMapName = iDialog.getValue();
                                    if (newMapName != null && newMapName.length() > 0) {
                                        newMapName = newMapName.replaceAll("\\s+", "_");
                                        JGrassMapEnvironment oldMapEnvironment = new JGrassMapEnvironment(oldMapFile);
                                        JGrassRegion jGrassRegion = oldMapEnvironment.getActiveRegion();
                                        GeneralParameterValue[] readParams = CopyOnActiveRegionAction.createGridGeometryGeneralParameter(jGrassRegion.getCols(), jGrassRegion.getRows(), jGrassRegion.getNorth(), jGrassRegion.getSouth(), jGrassRegion.getEast(), jGrassRegion.getWest(), oldMapEnvironment.getCoordinateReferenceSystem());
                                        GrassCoverageFormat format = new GrassCoverageFormatFactory().createFormat();
                                        AbstractGridCoverage2DReader reader = format.getReader((Object)oldMapEnvironment.getCELL());
                                        GridCoverage2D geodata = reader.read(readParams);
                                        geodata = geodata.view(ViewType.GEOPHYSICS);
                                        File mapsetFile = oldMapEnvironment.getMAPSET();
                                        JGrassMapEnvironment newMapEnvironment = new JGrassMapEnvironment(mapsetFile, newMapName);
                                        format = new GrassCoverageFormatFactory().createFormat();
                                        GridCoverageWriter writer = format.getWriter((Object)newMapEnvironment.getCELL(), null);
                                        writer.write((GridCoverage)geodata, null);
                                        JGrassCatalogUtilities.addMapToCatalog(mapsetFile.getParent(), mapsetFile.getName(), newMapName, "grassbinaryraster");
                                    }
                                }
                            }
                            catch (Exception e) {
                                String message = "An error occurred while duplicating the map.";
                                ExceptionDetailsDialog.openError((String)"ERROR", (String)message, (int)4, (String)"eu.udig.catalog.jgrass", (Throwable)e);
                                pm.done();
                            }
                        }
                        finally {
                            pm.done();
                        }
                    }
                });
            }
        };
        PlatformGIS.runInProgressDialog((String)"Duplicate map...", (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public static GeneralParameterValue[] createGridGeometryGeneralParameter(int width, int height, double north, double south, double east, double west, CoordinateReferenceSystem crs) {
        ReferencedEnvelope env;
        GeneralParameterValue[] readParams = new GeneralParameterValue[1];
        Parameter readGG = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
        GridEnvelope2D gridEnvelope = new GridEnvelope2D(0, 0, width, height);
        if (crs != null) {
            env = new ReferencedEnvelope(west, east, south, north, crs);
        } else {
            DirectPosition2D minDp = new DirectPosition2D(west, south);
            DirectPosition2D maxDp = new DirectPosition2D(east, north);
            env = new Envelope2D(minDp, maxDp);
        }
        readGG.setValue((Object)new GridGeometry2D((GridEnvelope)gridEnvelope, (Envelope)env));
        readParams[0] = readGG;
        return readParams;
    }
}

