/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.core;

import eu.udig.catalog.jgrass.JGrassPlugin;
import eu.udig.catalog.jgrass.core.JGrassService;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveAdapterFactory;
import net.refractions.udig.catalog.ServiceMover;
import net.refractions.udig.catalog.URLUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class JGrassServiceMover
implements IResolveAdapterFactory,
ServiceMover {
    private IResolve resolve;
    private IProgressMonitor monitor;

    public JGrassServiceMover() {
    }

    public JGrassServiceMover(IResolve resolve) {
        this.resolve = resolve;
    }

    public <T> T adapt(IResolve resolve, Class<T> adapter, IProgressMonitor monitor) throws IOException {
        if (adapter.isAssignableFrom(JGrassServiceMover.class)) {
            this.resolve = resolve;
            this.monitor = monitor;
            return adapter.cast(new JGrassServiceMover(resolve));
        }
        return null;
    }

    public boolean canAdapt(IResolve resolve, Class<?> adapter) {
        return adapter.isAssignableFrom(JGrassServiceMover.class);
    }

    public String move(File destinationFolder) {
        if (destinationFolder.isDirectory() && destinationFolder.exists()) {
            boolean success;
            JGrassService jgrassServiceImpl = (JGrassService)this.resolve;
            String locationName = null;
            try {
                locationName = jgrassServiceImpl.getInfo(this.monitor).getTitle();
            }
            catch (IOException e) {
                JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.internal.jgrass#JGrassServiceMover#move", e);
                e.printStackTrace();
            }
            String dataPath = destinationFolder.getAbsolutePath();
            File newJGrassLocationFile = new File(String.valueOf(dataPath) + File.separator + locationName);
            if (newJGrassLocationFile.exists()) {
                return "JGrass Location already existing inside the workspace. Not overwriting.";
            }
            Map<String, Serializable> parametersMap = jgrassServiceImpl.getConnectionParams();
            URL url = (URL)parametersMap.get("eu.udig.catalog.jgrass.urlKey");
            if (url == null) {
                return "No JGrass Service existing at " + locationName;
            }
            File jgrassLocationeFile = URLUtils.urlToFile((URL)url);
            if ((jgrassLocationeFile.exists() || jgrassLocationeFile.isDirectory()) && !(success = jgrassLocationeFile.renameTo(newJGrassLocationFile))) {
                return "Problems occured during consolidation of JGrass Location: " + locationName;
            }
            return null;
        }
        return "Problems in preparing the consolidation environment.";
    }
}

