/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.core;

import eu.udig.catalog.jgrass.JGrassPlugin;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.internal.CatalogImpl;
import net.refractions.udig.catalog.internal.ResolveChangeEvent;
import net.refractions.udig.catalog.internal.ResolveDelta;
import net.refractions.udig.ui.ProgressManager;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JGrassService
extends IService {
    private URL url = null;
    private Map<String, Serializable> params = null;
    private JGrassServiceInfo info = null;
    private volatile List<IResolve> mapsetMembers = null;
    private Throwable msg = null;
    private ID id;
    private File locationFolderFile;
    private CoordinateReferenceSystem locationCrs;

    public JGrassService(Map<String, Serializable> params) {
        this.params = params;
        this.url = (URL)this.params.get("eu.udig.catalog.jgrass.urlKey");
        this.id = new ID(this.url);
        this.locationFolderFile = URLUtils.urlToFile((URL)this.url);
        if (!this.locationFolderFile.isDirectory()) {
            throw new IllegalArgumentException("The GRASS location has to be a folder: " + this.locationFolderFile.getAbsolutePath());
        }
        this.locationCrs = JGrassCatalogUtilities.getLocationCrs(this.locationFolderFile.getAbsolutePath());
    }

    public Map<String, Serializable> getConnectionParams() {
        return this.params;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(IServiceInfo.class) || adaptee.isAssignableFrom(List.class) || adaptee.isAssignableFrom(File.class) || super.canResolve(adaptee);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IServiceInfo.class)) {
            return adaptee.cast(this.getInfo(monitor));
        }
        if (adaptee.isAssignableFrom(List.class)) {
            return adaptee.cast(this.members(monitor));
        }
        if (adaptee.isAssignableFrom(File.class)) {
            return adaptee.cast(this.locationFolderFile);
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public List<? extends IGeoResource> resources(IProgressMonitor monitor) throws IOException {
        this.members(monitor);
        ArrayList<JGrassMapGeoResource> children = new ArrayList<JGrassMapGeoResource>();
        this.collectChildren((IResolve)this, children, monitor);
        return children;
    }

    private void collectChildren(IResolve resolve, List<JGrassMapGeoResource> children, IProgressMonitor monitor) throws IOException {
        List resolves = resolve.members(monitor);
        if (resolve instanceof JGrassMapGeoResource && resolves.isEmpty()) {
            children.add((JGrassMapGeoResource)resolve);
        } else {
            for (IResolve resolve2 : resolves) {
                this.collectChildren(resolve2, children, monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IResolve> members(IProgressMonitor monitor) throws IOException {
        block6: {
            if (this.mapsetMembers != null) break block6;
            JGrassService jGrassService = this;
            synchronized (jGrassService) {
                Map<String, String> mapsetNamesAndPaths;
                block5: {
                    if (this.mapsetMembers != null) break block6;
                    mapsetNamesAndPaths = this.loadMapsets(monitor);
                    if (mapsetNamesAndPaths != null) break block5;
                    return null;
                }
                this.mapsetMembers = new ArrayList<IResolve>();
                for (Map.Entry<String, String> item : mapsetNamesAndPaths.entrySet()) {
                    JGrassMapsetGeoResource jgrassMapsetGeoResource = new JGrassMapsetGeoResource(this, item.getKey(), item.getValue());
                    this.mapsetMembers.add((IResolve)jgrassMapsetGeoResource);
                }
                return this.mapsetMembers;
            }
        }
        return this.mapsetMembers;
    }

    private Map<String, String> loadMapsets(IProgressMonitor monitor) {
        File[] mapsetFiles;
        HashMap<String, String> props;
        block8: {
            props = new HashMap<String, String>();
            mapsetFiles = this.locationFolderFile.listFiles();
            if (mapsetFiles != null) break block8;
            this.msg = new Throwable("Either dir does not exist or is not a directory");
            return null;
        }
        try {
            File permanentMapsetFile = null;
            File[] fileArray = mapsetFiles;
            int n = mapsetFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File mapsetFile = fileArray[n2];
                if (mapsetFile.getName().equals("PERMANENT")) {
                    permanentMapsetFile = mapsetFile;
                } else {
                    File windInMapsetFile = new File(mapsetFile, "WIND");
                    if (mapsetFile.exists() && mapsetFile.isDirectory() && windInMapsetFile.exists()) {
                        props.put(mapsetFile.getName(), mapsetFile.getAbsolutePath());
                    }
                }
                ++n2;
            }
            if (props.size() == 0 && permanentMapsetFile != null) {
                props.put("PERMANENT", permanentMapsetFile.getAbsolutePath());
            }
            this.msg = null;
            return props;
        }
        catch (Throwable e) {
            this.msg = e;
            return null;
        }
    }

    public URL getIdentifier() {
        return this.url;
    }

    public ID getID() {
        return this.id;
    }

    public CoordinateReferenceSystem getLocationCrs() {
        return this.locationCrs;
    }

    public static URL createId(String locationPath) {
        try {
            URL locationUrl = new File(locationPath).toURI().toURL();
            return locationUrl;
        }
        catch (MalformedURLException e) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Url should always work this is a bug"))).initCause(e);
        }
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public IResolve.Status getStatus() {
        if (this.mapsetMembers == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    public File getFile() {
        return this.locationFolderFile;
    }

    public File getPermanetMapsetFile() {
        return new File(this.getFile(), "PERMANENT");
    }

    public File getProjWktFile() {
        return new File(this.getPermanetMapsetFile(), "PROJ_INFO.WKT");
    }

    public JGrassMapsetGeoResource addMapset(String mapsetName) {
        File mapsetFile = new File(this.getFile(), mapsetName);
        JGrassMapsetGeoResource resource = new JGrassMapsetGeoResource(this, mapsetName, mapsetFile.getAbsolutePath());
        if (this.mapsetMembers == null) {
            try {
                this.mapsetMembers = this.members(ProgressManager.instance().get(null));
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (!this.mapsetMembers.contains(resource)) {
            this.mapsetMembers.add((IResolve)resource);
            ICatalog catalog = this.parent(null);
            if (catalog instanceof CatalogImpl) {
                ResolveDelta delta = new ResolveDelta((IResolve)resource, IResolveDelta.Kind.ADDED);
                ResolveChangeEvent event = new ResolveChangeEvent((Object)this, IResolveChangeEvent.Type.POST_CHANGE, (IResolveDelta)delta);
                ((CatalogImpl)catalog).fire((IResolveChangeEvent)event);
            }
        }
        return resource;
    }

    public JGrassMapsetGeoResource removeMapset(String mapsetName) {
        File mapsetFile = new File(this.getFile(), mapsetName);
        JGrassMapsetGeoResource resource = new JGrassMapsetGeoResource(this, mapsetName, mapsetFile.getAbsolutePath());
        URL mapsetIdentifier = resource.getIdentifier();
        if (this.mapsetMembers == null) {
            try {
                this.mapsetMembers = this.members(ProgressManager.instance().get(null));
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        int i = 0;
        while (i < this.mapsetMembers.size()) {
            IResolve resolve = this.mapsetMembers.get(i);
            URL identifier = resolve.getIdentifier();
            if (mapsetIdentifier.toExternalForm().equals(identifier.toExternalForm())) {
                this.mapsetMembers.remove(i);
                ICatalog catalog = this.parent(null);
                if (!(catalog instanceof CatalogImpl)) break;
                ResolveDelta delta = new ResolveDelta((IResolve)resource, IResolveDelta.Kind.REMOVED);
                ResolveChangeEvent event = new ResolveChangeEvent((Object)this, IResolveChangeEvent.Type.POST_CHANGE, (IResolveDelta)delta);
                ((CatalogImpl)catalog).fire((IResolveChangeEvent)event);
                break;
            }
            ++i;
        }
        return resource;
    }

    public JGrassMapsetGeoResource getMapsetGeoresourceByName(String name) {
        if (this.mapsetMembers == null) {
            try {
                this.members((IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.internal.jgrass#JGrassService#getMapsetGeoresourceByName", e);
                e.printStackTrace();
                return null;
            }
        }
        for (IResolve mapsetResource : this.mapsetMembers) {
            JGrassMapsetGeoResource mapsetGR;
            String mapsetName;
            if (!(mapsetResource instanceof JGrassMapsetGeoResource) || !(mapsetName = (mapsetGR = (JGrassMapsetGeoResource)mapsetResource).getTitle()).equals(name)) continue;
            return mapsetGR;
        }
        return null;
    }

    protected IServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        if (this.info == null) {
            this.info = new JGrassServiceInfo();
        }
        return this.info;
    }

    class JGrassServiceInfo
    extends IServiceInfo {
        public JGrassServiceInfo() {
            File serviceFile = JGrassService.this.getFile();
            this.title = serviceFile.getName();
            this.description = "JGrass database service (" + this.title + ")";
        }

        public Icon getIcon() {
            ImageDescriptor imgD = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/jgrassloc_obj.gif");
            return AWTSWTImageUtils.imageDescriptor2awtIcon((ImageDescriptor)imgD);
        }

        public String getTitle() {
            return this.title;
        }
    }
}

