/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.core;

import eu.udig.catalog.jgrass.JGrassPlugin;
import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import eu.udig.renderer.jgrass.RasterRenderer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveFolder;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.project.internal.render.impl.RendererImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.gce.grassraster.GrassCoverageReader;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JGrassMapGeoResource
extends IGeoResource {
    public static final String READERID = "eu.hydrologis.udig.catalog.internal.jgrass.JGrassMapGeoResource.readerid";
    private IResolveFolder parent = null;
    private String name = null;
    private String type = null;
    private Throwable msg = null;
    private JGrassRegion fileWindow = null;
    private IGeoResourceInfo info = null;
    private final IService parentService;
    private JGrassMapEnvironment jGrassMapEnvironment;
    private CoordinateReferenceSystem locationCrs;
    private ImageDescriptor gridIconID;
    private ImageDescriptor gridMissingIconID;
    private ImageDescriptor problemIconID;

    public JGrassMapGeoResource(IService parentService, JGrassMapsetGeoResource parentMapset, String mapName, String mapTypeAndPath) {
        this.parentService = parentService;
        this.parent = parentMapset;
        this.name = mapName;
        String[] typeAndPath = mapTypeAndPath.split("\\|");
        this.type = typeAndPath[0].trim();
        this.jGrassMapEnvironment = new JGrassMapEnvironment(parentMapset.getFile(), this.name);
        this.locationCrs = parentMapset.getLocationCrs();
        this.gridIconID = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
        this.gridMissingIconID = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_missing_obj.gif");
        this.problemIconID = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/problem.gif");
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(IService.class) || adaptee.isAssignableFrom(IGeoResource.class) || adaptee.isAssignableFrom(JGrassMapGeoResource.class) || adaptee.isAssignableFrom(GridCoverage.class) || adaptee.isAssignableFrom(AbstractGridCoverage2DReader.class) || adaptee.isAssignableFrom(File.class) || adaptee.isAssignableFrom(RendererImpl.class) || adaptee.isAssignableFrom(CoordinateReferenceSystem.class) || adaptee.isAssignableFrom(GridGeometry2D.class) || super.canResolve(adaptee);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IService.class)) {
            return adaptee.cast(this.parent.parent(monitor));
        }
        if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
            return adaptee.cast(this.getInfo(monitor));
        }
        if (adaptee.isAssignableFrom(File.class)) {
            return adaptee.cast(this.jGrassMapEnvironment.getMapFile());
        }
        if (adaptee.isAssignableFrom(JGrassMapGeoResource.class)) {
            return adaptee.cast((Object)this);
        }
        if (adaptee.isAssignableFrom(IGeoResource.class)) {
            return adaptee.cast((Object)this);
        }
        if (adaptee.isAssignableFrom(RendererImpl.class)) {
            RasterRenderer renderer = new RasterRenderer();
            return adaptee.cast((Object)renderer);
        }
        if (adaptee.isAssignableFrom(AbstractGridCoverage2DReader.class)) {
            GrassCoverageReader reader = new GrassCoverageReader((Object)this.jGrassMapEnvironment.getMapFile());
            return adaptee.cast(reader);
        }
        if (adaptee.isAssignableFrom(CoordinateReferenceSystem.class)) {
            return adaptee.cast(this.locationCrs);
        }
        if (adaptee.isAssignableFrom(GridGeometry2D.class)) {
            try {
                JGrassRegion r = this.jGrassMapEnvironment.getFileRegion();
                Envelope2D envelope = new Envelope2D(this.locationCrs, r.getWest(), r.getSouth(), r.getEast() - r.getWest(), r.getNorth() - r.getSouth());
                GridEnvelope2D gridRange = new GridEnvelope2D(0, 0, r.getCols(), r.getRows());
                GridGeometry2D gridGeometry2D = new GridGeometry2D((GridEnvelope)gridRange, (Envelope)envelope);
                return adaptee.cast(gridGeometry2D);
            }
            catch (Exception e) {
                this.msg = e;
            }
        }
        if (adaptee.isAssignableFrom(GridCoverage.class)) {
            try {
                JGrassRegion jGrassRegion = this.jGrassMapEnvironment.getFileRegion();
                GridCoverage2D mapCoverage = JGrassCatalogUtilities.getGridcoverageFromGrassraster(this.jGrassMapEnvironment, jGrassRegion);
                return adaptee.cast(mapCoverage);
            }
            catch (Exception e) {
                this.msg = e;
            }
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public URL getIdentifier() {
        File mapFile = this.jGrassMapEnvironment.getMapFile();
        int mapsetPathLength = mapFile.getParentFile().getParent().length();
        String relativePath = mapFile.getAbsolutePath().substring(mapsetPathLength);
        try {
            String parenturlString = URLUtils.urlToString((URL)this.parent.getIdentifier(), (boolean)false);
            relativePath = relativePath.replace("\\", "/");
            return new URL(String.valueOf(parenturlString) + relativePath);
        }
        catch (MalformedURLException e) {
            JGrassPlugin.log("JGrassPlugin problem: eu.hydrologis.udig.catalog.internal.jgrass#JGrassMapGeoResource#getIdentifier", e);
            e.printStackTrace();
            return null;
        }
    }

    public ID getID() {
        File mapFile = this.jGrassMapEnvironment.getMapFile();
        try {
            URL identifier = this.getIdentifier();
            URI uri = identifier.toURI();
            String asciiString = uri.toASCIIString();
            return new ID(asciiString, identifier, mapFile, uri, "grass");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return new ID(mapFile, "grass");
        }
    }

    public IService service(IProgressMonitor monitor) throws IOException {
        return this.parentService;
    }

    public IResolve parent(IProgressMonitor monitor) throws IOException {
        return this.parent;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public IResolve.Status getStatus() {
        if (this.msg != null) {
            return IResolve.Status.BROKEN;
        }
        return IResolve.Status.CONNECTED;
    }

    public String getType() {
        return this.type;
    }

    public File getMapFile() {
        return this.jGrassMapEnvironment.getMapFile();
    }

    public File getMapsetFile() {
        return this.jGrassMapEnvironment.getMAPSET();
    }

    public File getLocationFile() {
        return this.jGrassMapEnvironment.getLOCATION();
    }

    public JGrassRegion getFileWindow() {
        return this.fileWindow;
    }

    public void resetBoundInfo() throws IOException {
        this.jGrassMapEnvironment = new JGrassMapEnvironment(this.jGrassMapEnvironment.getCELL());
        this.fileWindow = this.jGrassMapEnvironment.getFileRegion();
        ReferencedEnvelope newBounds = new ReferencedEnvelope(this.fileWindow.getEnvelope(), this.locationCrs);
        if (this.info != null) {
            ((JGrassMapGeoResourceInfo)this.info).setBounds(newBounds);
        }
        this.createInfo((IProgressMonitor)new NullProgressMonitor());
    }

    public String getTitle() {
        try {
            this.createInfo((IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.info.getTitle();
    }

    public JGrassRegion getActiveWindow() throws IOException {
        if (this.type.equals("grassbinaryraster")) {
            JGrassRegion activeRegion = this.jGrassMapEnvironment.getActiveRegion();
            return activeRegion;
        }
        return null;
    }

    public JGrassMapEnvironment getjGrassMapEnvironment() {
        return this.jGrassMapEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IGeoResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        JGrassMapGeoResource jGrassMapGeoResource = this;
        synchronized (jGrassMapGeoResource) {
            if (this.info == null) {
                this.info = new JGrassMapGeoResourceInfo(monitor);
            }
        }
        return this.info;
    }

    class JGrassMapGeoResourceInfo
    extends IGeoResourceInfo {
        public JGrassMapGeoResourceInfo(IProgressMonitor monitor) {
            this.title = this.name = JGrassMapGeoResource.this.name;
            this.description = JGrassMapGeoResource.this.type;
            try {
                if (JGrassMapGeoResource.this.type.equals("grassbinaryraster")) {
                    File cellhd = JGrassMapGeoResource.this.jGrassMapEnvironment.getCELLHD();
                    JGrassMapGeoResource.this.fileWindow = new JGrassRegion(cellhd.getAbsolutePath());
                    this.bounds = new ReferencedEnvelope(JGrassMapGeoResource.this.fileWindow.getEnvelope(), JGrassMapGeoResource.this.locationCrs);
                    this.icon = JGrassMapGeoResource.this.gridIconID;
                } else {
                    this.icon = JGrassMapGeoResource.this.gridMissingIconID;
                }
            }
            catch (Exception e) {
                this.icon = JGrassMapGeoResource.this.problemIconID;
                e.printStackTrace();
            }
        }

        public ReferencedEnvelope getBounds() {
            return this.bounds;
        }

        public void setBounds(ReferencedEnvelope newBounds) {
            this.bounds = newBounds;
        }
    }
}

