/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.core;

import eu.udig.catalog.jgrass.core.JGTtmsGeoResource;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JGTtmsService
extends IService {
    private URL url = null;
    private Map<String, Serializable> params = null;
    private JGTtmsServiceInfo info = null;
    private volatile List<IResolve> mapsetMembers = null;
    private Throwable msg = null;
    private ID id;
    private File tmsPropertiesFile;
    private CoordinateReferenceSystem tmsCrs;
    public static final String EPSG_MERCATOR = "EPSG:3857";

    public JGTtmsService(Map<String, Serializable> params) {
        this.params = params;
        this.url = (URL)this.params.get("eu.udig.catalog.jgrasstoolstms.urlKey");
        this.id = new ID(this.url);
        this.tmsPropertiesFile = URLUtils.urlToFile((URL)this.url);
        try {
            this.tmsCrs = CRS.decode((String)EPSG_MERCATOR);
        }
        catch (Exception e) {
            this.msg = e;
            e.printStackTrace();
        }
    }

    public Map<String, Serializable> getConnectionParams() {
        return this.params;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(IServiceInfo.class) || adaptee.isAssignableFrom(File.class) || super.canResolve(adaptee);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IServiceInfo.class)) {
            return adaptee.cast(this.getInfo(monitor));
        }
        if (adaptee.isAssignableFrom(File.class)) {
            return adaptee.cast(this.tmsPropertiesFile);
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public List<? extends IGeoResource> resources(IProgressMonitor monitor) throws IOException {
        ArrayList<JGTtmsGeoResource> children = new ArrayList<JGTtmsGeoResource>();
        JGTtmsGeoResource resource = new JGTtmsGeoResource(this, this.url);
        children.add(resource);
        return children;
    }

    public URL getIdentifier() {
        return this.id.toURL();
    }

    public ID getID() {
        return this.id;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.tmsCrs;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public IResolve.Status getStatus() {
        if (this.mapsetMembers == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    public File getFile() {
        return this.tmsPropertiesFile;
    }

    protected IServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        if (this.info == null) {
            this.info = new JGTtmsServiceInfo();
        }
        return this.info;
    }

    class JGTtmsServiceInfo
    extends IServiceInfo {
        public JGTtmsServiceInfo() {
            String baseName;
            File serviceFile = JGTtmsService.this.getFile();
            this.title = baseName = FilenameUtils.getBaseName((String)serviceFile.getName());
            this.description = "JGrassTools TMS service (" + this.title + ")";
        }

        public Icon getIcon() {
            ImageDescriptor imgD = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif");
            return AWTSWTImageUtils.imageDescriptor2awtIcon((ImageDescriptor)imgD);
        }

        public String getTitle() {
            return this.title;
        }
    }
}

