/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.activeregion.dialogs;

import eu.udig.catalog.jgrass.activeregion.dialogs.IResourcesSelector;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class JGRasterLayerTreeViewer
extends Composite
implements ISelectionChangedListener,
IResourcesSelector {
    public static final int GRASSRASTERLAYER = 1;
    private final HashMap<String, ILayer> itemsMap = new HashMap();
    private LabelProvider labelProvider = null;
    private List<IGeoResource> itemLayers;
    private String mapsetPath;

    public JGRasterLayerTreeViewer(Composite parent, int style, int selectionStyle, String mapsetPath) {
        super(parent, style);
        if (mapsetPath != null) {
            this.mapsetPath = mapsetPath;
        }
        this.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filter = new FilteredTree((Composite)this, selectionStyle, patternFilter);
        TreeViewer tv = filter.getViewer();
        tv.getTree().setLayoutData((Object)new GridData(1808));
        tv.setContentProvider((IContentProvider)new ContentProvider());
        this.labelProvider = new LabelProvider();
        tv.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tv.setInput((Object)"dummy");
        tv.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            return;
        }
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Vector<String> itemNames = new Vector<String>();
            for (Object domain : selection) {
                String value = this.labelProvider.getText(domain);
                itemNames.add(value);
            }
            this.itemLayers = new ArrayList<IGeoResource>();
            for (String name : itemNames) {
                ILayer tmpLayer = this.itemsMap.get(name);
                if (tmpLayer == null || !tmpLayer.getGeoResource().canResolve(JGrassMapGeoResource.class)) continue;
                JGrassMapGeoResource rasterMapResource = null;
                try {
                    rasterMapResource = (JGrassMapGeoResource)((Object)tmpLayer.getGeoResource().resolve(JGrassMapGeoResource.class, null));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (rasterMapResource == null) continue;
                this.itemLayers.add(rasterMapResource);
            }
        }
    }

    @Override
    public List<IGeoResource> getSelectedLayers() {
        return this.itemLayers;
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object arg0) {
            if (arg0 instanceof IMap) {
                IMap map = (IMap)arg0;
                List layers = map.getMapLayers();
                return this.filteredLayers(layers);
            }
            if (arg0 instanceof ILayer) {
                return null;
            }
            return null;
        }

        private Object[] filteredLayers(List<ILayer> layers) {
            Vector<ILayer> filteredLayers = new Vector<ILayer>();
            try {
                for (ILayer layer : layers) {
                    if (!layer.getGeoResource().canResolve(JGrassMapGeoResource.class) || !((JGrassMapGeoResource)((Object)layer.getGeoResource().resolve(JGrassMapGeoResource.class, null))).getType().equals("grassbinaryraster") && !((JGrassMapGeoResource)((Object)layer.getGeoResource().resolve(JGrassMapGeoResource.class, null))).getType().equals("grassasciiraster") && !((JGrassMapGeoResource)((Object)layer.getGeoResource().resolve(JGrassMapGeoResource.class, null))).getType().equals("fluidturtleasciiraster") && !((JGrassMapGeoResource)((Object)layer.getGeoResource().resolve(JGrassMapGeoResource.class, null))).getType().equals("esriasciigrid")) continue;
                    JGrassMapGeoResource mapResolve = (JGrassMapGeoResource)((Object)layer.getGeoResource().resolve(JGrassMapGeoResource.class, (IProgressMonitor)new NullProgressMonitor()));
                    IResolve mapsetResolve = mapResolve.parent((IProgressMonitor)new NullProgressMonitor());
                    if (JGRasterLayerTreeViewer.this.mapsetPath != null && mapsetResolve instanceof JGrassMapsetGeoResource) {
                        JGrassMapsetGeoResource map = (JGrassMapsetGeoResource)mapsetResolve;
                        File refFile = map.getFile();
                        File mapsetFile = new File(JGRasterLayerTreeViewer.this.mapsetPath);
                        if (!refFile.getAbsolutePath().equals(mapsetFile.getAbsolutePath())) continue;
                        filteredLayers.add(layer);
                        JGRasterLayerTreeViewer.this.itemsMap.put(layer.getName(), layer);
                        continue;
                    }
                    filteredLayers.add(layer);
                    JGRasterLayerTreeViewer.this.itemsMap.put(layer.getName(), layer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            HashMap<String, ILayer> tmp = new HashMap<String, ILayer>();
            for (ILayer resource : filteredLayers) {
                tmp.put(resource.getName(), resource);
            }
            TreeMap sortedMap = new TreeMap(tmp);
            filteredLayers.removeAllElements();
            for (ILayer value : sortedMap.values()) {
                filteredLayers.add(value);
            }
            return filteredLayers.toArray();
        }

        public Object getParent(Object arg0) {
            if (arg0 instanceof IMap) {
                return null;
            }
            if (arg0 instanceof ILayer) {
                return ((ILayer)arg0).getMap();
            }
            return null;
        }

        public boolean hasChildren(Object arg0) {
            if (arg0 instanceof IMap) {
                return true;
            }
            if (arg0 instanceof ILayer) {
                return false;
            }
            return false;
        }

        public Object[] getElements(Object arg0) {
            IMap map = ApplicationGIS.getActiveMap();
            return new Object[]{map};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private static class LabelProvider
    implements ILabelProvider {
        private final List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();
        private final Image rasterMaps = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/grid_obj.gif").createImage();
        private final Image mainRasterMaps = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/jgrass_obj.gif").createImage();
        private final Image grassasciiRasterMaps = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/grassascii.gif").createImage();
        private final Image esriasciiRasterMaps = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/esrigrid.gif").createImage();
        private final Image fluidturtleRasterMaps = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/ftraster.gif").createImage();
        private final Image problemRasterMaps = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/problem.gif").createImage();

        public Image getImage(Object arg0) {
            if (arg0 instanceof IMap) {
                return this.mainRasterMaps;
            }
            if (arg0 instanceof ILayer) {
                try {
                    if (((JGrassMapGeoResource)((Object)((ILayer)arg0).getGeoResource().resolve(JGrassMapGeoResource.class, null))).getType().equals("grassbinaryraster")) {
                        return this.rasterMaps;
                    }
                    if (((JGrassMapGeoResource)((Object)((ILayer)arg0).getGeoResource().resolve(JGrassMapGeoResource.class, null))).getType().equals("grassasciiraster")) {
                        return this.grassasciiRasterMaps;
                    }
                    if (((JGrassMapGeoResource)((Object)((ILayer)arg0).getGeoResource().resolve(JGrassMapGeoResource.class, null))).getType().equals("esriasciigrid")) {
                        return this.esriasciiRasterMaps;
                    }
                    if (((JGrassMapGeoResource)((Object)((ILayer)arg0).getGeoResource().resolve(JGrassMapGeoResource.class, null))).getType().equals("fluidturtleasciiraster")) {
                        return this.fluidturtleRasterMaps;
                    }
                    return this.problemRasterMaps;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }

        public String getText(Object arg0) {
            String text = null;
            if (arg0 instanceof IMap) {
                text = ((IMap)arg0).getName();
            } else if (arg0 instanceof ILayer) {
                text = ((ILayer)arg0).getName();
            }
            return text;
        }

        public void addListener(ILabelProviderListener arg0) {
            this.listeners.add(arg0);
        }

        public void dispose() {
            if (this.rasterMaps != null) {
                this.rasterMaps.dispose();
            }
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
            this.listeners.remove(arg0);
        }
    }
}

