/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.activeregion.dialogs;

import eu.udig.catalog.jgrass.activeregion.dialogs.IResourcesSelector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.refractions.udig.catalog.ui.CatalogUIPlugin;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.geotools.data.FeatureStore;

public class FeatureLayerTreeViewer
extends Composite
implements ISelectionChangedListener,
IResourcesSelector {
    public static final int SHAPELAYER = 0;
    private final HashMap<String, ILayer> itemsMap = new HashMap();
    private LabelProvider labelProvider = null;
    private List<FeatureStore> selectedLayers;

    public FeatureLayerTreeViewer(Composite parent, int style, int selectionStyle) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filter = new FilteredTree((Composite)this, selectionStyle, patternFilter);
        TreeViewer tv = filter.getViewer();
        tv.getTree().setLayoutData((Object)new GridData(1808));
        tv.setContentProvider((IContentProvider)new ContentProvider());
        this.labelProvider = new LabelProvider();
        tv.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tv.setInput((Object)"dummy");
        tv.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            return;
        }
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Vector<String> itemNames = new Vector<String>();
            for (Object domain : selection) {
                String value = this.labelProvider.getText(domain);
                itemNames.add(value);
            }
            this.selectedLayers = new ArrayList<FeatureStore>();
            for (String name : itemNames) {
                ILayer tmpLayer = this.itemsMap.get(name);
                if (tmpLayer == null) continue;
                try {
                    FeatureStore tmpStore = (FeatureStore)tmpLayer.getResource(FeatureStore.class, null);
                    if (tmpStore == null) continue;
                    this.selectedLayers.add(tmpStore);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public List<FeatureStore> getSelectedLayers() {
        return this.selectedLayers;
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object arg0) {
            if (arg0 instanceof IMap) {
                IMap map = (IMap)arg0;
                List layers = map.getMapLayers();
                return this.filteredLayers(layers);
            }
            if (arg0 instanceof ILayer) {
                return null;
            }
            return null;
        }

        private Object[] filteredLayers(List<ILayer> layers) {
            Vector<ILayer> filteredLayers = new Vector<ILayer>();
            for (ILayer layer : layers) {
                if (!layer.getGeoResource().canResolve(FeatureStore.class)) continue;
                filteredLayers.add(layer);
                FeatureLayerTreeViewer.this.itemsMap.put(layer.getName(), layer);
            }
            return filteredLayers.toArray();
        }

        public Object getParent(Object arg0) {
            if (arg0 instanceof IMap) {
                return null;
            }
            if (arg0 instanceof ILayer) {
                return ((ILayer)arg0).getMap();
            }
            return null;
        }

        public boolean hasChildren(Object arg0) {
            if (arg0 instanceof IMap) {
                return true;
            }
            if (arg0 instanceof ILayer) {
                return false;
            }
            return false;
        }

        public Object[] getElements(Object arg0) {
            IMap map = ApplicationGIS.getActiveMap();
            return new Object[]{map};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private static class LabelProvider
    implements ILabelProvider {
        private final List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();
        private final Image vectorMaps = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/feature_obj.gif").createImage();
        private final Image mainMaps = CatalogUIPlugin.getDefault().getImageDescriptor("obj16/repository_obj.gif").createImage();

        public Image getImage(Object arg0) {
            if (arg0 instanceof IMap) {
                return this.mainMaps;
            }
            if (arg0 instanceof ILayer) {
                return this.vectorMaps;
            }
            return null;
        }

        public String getText(Object arg0) {
            String text = null;
            if (arg0 instanceof IMap) {
                text = ((IMap)arg0).getName();
            } else if (arg0 instanceof ILayer) {
                text = ((ILayer)arg0).getName();
            }
            return text;
        }

        public void addListener(ILabelProviderListener arg0) {
            this.listeners.add(arg0);
        }

        public void dispose() {
            if (this.vectorMaps != null) {
                this.vectorMaps.dispose();
            }
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
            this.listeners.remove(arg0);
        }
    }
}

