/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.activeregion.dialogs;

import eu.udig.catalog.jgrass.activeregion.dialogs.AbstractChooserDialog;
import eu.udig.catalog.jgrass.activeregion.dialogs.FeatureCatalogTreeViewer;
import eu.udig.catalog.jgrass.activeregion.dialogs.FeatureLayerTreeViewer;
import eu.udig.catalog.jgrass.activeregion.dialogs.IResourcesSelector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.internal.impl.UDIGSimpleFeatureStore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.DataStore;

public class FeatureChooserDialog
extends AbstractChooserDialog {
    private IResourcesSelector active;
    private List<DataStore> selectedLayers;

    @Override
    public void open(Shell parentShell, final int selectionType) {
        Dialog dialog = new Dialog(parentShell){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText("Select vector map");
            }

            protected Point getInitialSize() {
                return new Point(280, 380);
            }

            protected Control createDialogArea(Composite parent) {
                FeatureChooserDialog.this.parentPanel = (Composite)super.createDialogArea(parent);
                GridLayout gLayout = (GridLayout)FeatureChooserDialog.this.parentPanel.getLayout();
                gLayout.numColumns = 1;
                FeatureChooserDialog.this.active = new FeatureLayerTreeViewer(FeatureChooserDialog.this.parentPanel, 2048, selectionType);
                FeatureChooserDialog.this.makeCheckPanel();
                return FeatureChooserDialog.this.parentPanel;
            }

            protected void buttonPressed(int buttonId) {
                if (buttonId == 0) {
                    Object tmp = null;
                    try {
                        tmp = ((List)FeatureChooserDialog.this.active.getSelectedLayers()).get(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        FeatureChooserDialog.this.selectedLayers = null;
                    }
                    if (tmp instanceof DataStore) {
                        FeatureChooserDialog.this.selectedLayers = (List)FeatureChooserDialog.this.active.getSelectedLayers();
                    } else if (tmp instanceof UDIGSimpleFeatureStore) {
                        List l = (List)FeatureChooserDialog.this.active.getSelectedLayers();
                        ArrayList<DataStore> ll = new ArrayList<DataStore>();
                        for (Object object : l) {
                            UDIGSimpleFeatureStore internal = (UDIGSimpleFeatureStore)object;
                            ll.add(internal.getDataStore());
                        }
                        FeatureChooserDialog.this.selectedLayers = ll;
                    }
                } else {
                    FeatureChooserDialog.this.selectedLayers = null;
                }
                super.buttonPressed(buttonId);
            }
        };
        dialog.setBlockOnOpen(true);
        dialog.open();
    }

    public void widgetSelected(SelectionEvent e) {
        Button selectedButton = (Button)e.getSource();
        if (!selectedButton.getSelection()) {
            return;
        }
        this.isCatalogType = !selectedButton.getData("type").equals("visiblelayertype");
        Control[] childrens = this.parentPanel.getChildren();
        int i = 0;
        while (i < childrens.length) {
            childrens[i].dispose();
            ++i;
        }
        if (this.isCatalogType) {
            this.active = new FeatureCatalogTreeViewer(this.parentPanel, 2048, 4);
        } else if (!this.isCatalogType) {
            this.active = new FeatureLayerTreeViewer(this.parentPanel, 2048, 4);
        }
        this.makeCheckPanel();
        this.parentPanel.layout();
    }

    public List<DataStore> getSelectedResources() {
        return this.selectedLayers;
    }

    @Override
    public String getNameOfResourceAtIndex(int index) {
        try {
            return this.selectedLayers.get(index).getTypeNames()[0];
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

