/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.activeregion.dialogs;

import eu.udig.catalog.jgrass.activeregion.dialogs.IResourcesSelector;
import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import eu.udig.catalog.jgrass.core.JGrassService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.IResolve;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CatalogJGrassMapsetsTreeViewer
extends Composite
implements ISelectionChangedListener,
IResourcesSelector {
    private final HashMap<String, JGrassMapsetGeoResource> itemsMap = new HashMap();
    private LabelProvider labelProvider = null;
    private List<JGrassMapsetGeoResource> itemLayers;

    public CatalogJGrassMapsetsTreeViewer(Composite parent, int style, int selectionStyle) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filter = new FilteredTree((Composite)this, selectionStyle, patternFilter);
        TreeViewer tv = filter.getViewer();
        tv.getTree().setLayoutData((Object)new GridData(1808));
        tv.setContentProvider((IContentProvider)new ContentProvider());
        this.labelProvider = new LabelProvider();
        tv.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tv.setInput((Object)"dummy");
        tv.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            return;
        }
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Vector<String> itemNames = new Vector<String>();
            for (Object domain : selection) {
                String value = this.labelProvider.getText(domain);
                itemNames.add(value);
            }
            this.itemLayers = new ArrayList<JGrassMapsetGeoResource>();
            for (String name : itemNames) {
                JGrassMapsetGeoResource tmpLayer = this.itemsMap.get(name);
                if (tmpLayer == null) continue;
                this.itemLayers.add(tmpLayer);
            }
        }
    }

    @Override
    public List<JGrassMapsetGeoResource> getSelectedLayers() {
        return this.itemLayers;
    }

    public int getType() {
        return 0;
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object arg0) {
            if (arg0 instanceof JGrassService) {
                JGrassService map = (JGrassService)((Object)arg0);
                List<IResolve> layers = null;
                try {
                    layers = map.members(null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (layers == null) {
                    return null;
                }
                return this.filteredLayers(layers);
            }
            if (arg0 instanceof JGrassMapsetGeoResource) {
                return null;
            }
            return null;
        }

        private Object[] filteredLayers(List<IResolve> layers) {
            Vector<JGrassMapsetGeoResource> filteredLayers = new Vector<JGrassMapsetGeoResource>();
            for (IResolve layer : layers) {
                if (!(layer instanceof JGrassMapsetGeoResource)) continue;
                filteredLayers.add((JGrassMapsetGeoResource)layer);
                CatalogJGrassMapsetsTreeViewer.this.itemsMap.put(((JGrassMapsetGeoResource)layer).getTitle(), (JGrassMapsetGeoResource)layer);
            }
            HashMap<String, JGrassMapsetGeoResource> tmp = new HashMap<String, JGrassMapsetGeoResource>();
            for (JGrassMapsetGeoResource resource : filteredLayers) {
                tmp.put(resource.getTitle(), resource);
            }
            TreeMap sortedMap = new TreeMap(tmp);
            filteredLayers.removeAllElements();
            for (JGrassMapsetGeoResource map : sortedMap.values()) {
                filteredLayers.add(map);
            }
            return filteredLayers.toArray();
        }

        public Object getParent(Object arg0) {
            if (arg0 instanceof JGrassMapsetGeoResource) {
                return null;
            }
            if (arg0 instanceof JGrassMapGeoResource) {
                try {
                    return ((JGrassMapGeoResource)((Object)arg0)).parent(null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public boolean hasChildren(Object arg0) {
            if (arg0 instanceof JGrassService) {
                return true;
            }
            if (arg0 instanceof JGrassMapsetGeoResource) {
                return false;
            }
            return false;
        }

        public Object[] getElements(Object arg0) {
            ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
            try {
                ArrayList<IResolve> finalCatalogMembers = new ArrayList<IResolve>();
                List allCatalogMembers = catalog.members(null);
                for (IResolve resolve : allCatalogMembers) {
                    if (!(resolve instanceof JGrassService)) continue;
                    finalCatalogMembers.add(resolve);
                }
                if (finalCatalogMembers.size() > 0) {
                    return finalCatalogMembers.toArray();
                }
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private static class LabelProvider
    implements ILabelProvider {
        private final List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();
        private final Image rasterMaps;
        private final Image mainRasterMaps = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/jgrassloc_obj.gif").createImage();

        public LabelProvider() {
            this.rasterMaps = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.catalog.jgrass", (String)"icons/obj16/jgrass_obj.gif").createImage();
        }

        public Image getImage(Object arg0) {
            if (arg0 instanceof JGrassService) {
                return this.mainRasterMaps;
            }
            if (arg0 instanceof JGrassMapsetGeoResource) {
                return this.rasterMaps;
            }
            return null;
        }

        public String getText(Object arg0) {
            String text = null;
            try {
                if (arg0 instanceof JGrassMapsetGeoResource) {
                    text = ((JGrassMapsetGeoResource)arg0).getTitle();
                } else if (arg0 instanceof JGrassService) {
                    text = ((JGrassService)((Object)arg0)).getInfo(null).getTitle();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return text;
        }

        public void addListener(ILabelProviderListener arg0) {
            this.listeners.add(arg0);
        }

        public void dispose() {
            if (this.rasterMaps != null) {
                this.rasterMaps.dispose();
            }
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
            this.listeners.remove(arg0);
        }
    }
}

