/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.activeregion;

import com.vividsolutions.jts.geom.Coordinate;
import eu.udig.catalog.jgrass.activeregion.ActiveRegionStyle;
import eu.udig.catalog.jgrass.activeregion.ActiveregionStyleContent;
import eu.udig.catalog.jgrass.activeregion.dialogs.CatalogJGrassMapsetTreeViewerDialog;
import eu.udig.catalog.jgrass.core.JGrassMapsetGeoResource;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.ui.graphics.AWTGraphics;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ActiveRegionMapGraphic
implements MapGraphic {
    public void draw(MapGraphicContext context) {
        context.getLayer().setStatus(5);
        ViewportGraphics g = context.getGraphics();
        if (g instanceof AWTGraphics) {
            AWTGraphics awtG = (AWTGraphics)g;
            Graphics2D g2D = awtG.g;
            RenderingHints hints = new RenderingHints(Collections.EMPTY_MAP);
            hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            g2D.addRenderingHints(hints);
        }
        Dimension screen = context.getMapDisplay().getDisplaySize();
        IBlackboard blackboard = context.getMap().getBlackboard();
        ActiveRegionStyle style = (ActiveRegionStyle)blackboard.get("eu.udig.catalog.jgrass.activeregion.activeregionStyle");
        if (style == null) {
            style = ActiveregionStyleContent.createDefault();
            blackboard.put("eu.udig.catalog.jgrass.activeregion.activeregionStyle", (Object)style);
        }
        if (style.windPath == null) {
            this.getMapset(blackboard);
        }
        CoordinateReferenceSystem destinationCRS = context.getCRS();
        try {
            File windFile;
            CoordinateReferenceSystem crs = CRS.decode((String)style.crsString);
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)destinationCRS, (boolean)true);
            Coordinate ul = new Coordinate((double)style.west, (double)style.north);
            Coordinate ur = new Coordinate((double)style.east, (double)style.north);
            Coordinate ll = new Coordinate((double)style.west, (double)style.south);
            Coordinate lr = new Coordinate((double)style.east, (double)style.south);
            Coordinate newUL = JTS.transform((Coordinate)ul, null, (MathTransform)transform);
            Coordinate newUR = JTS.transform((Coordinate)ur, null, (MathTransform)transform);
            Coordinate newLL = JTS.transform((Coordinate)ll, null, (MathTransform)transform);
            Coordinate newLR = JTS.transform((Coordinate)lr, null, (MathTransform)transform);
            float[] rgba = style.backgroundColor.getColorComponents(null);
            g.setColor(new Color(rgba[0], rgba[1], rgba[2], style.bAlpha));
            Point ulPoint = context.worldToPixel(newUL);
            Point urPoint = context.worldToPixel(newUR);
            Point llPoint = context.worldToPixel(newLL);
            Point lrPoint = context.worldToPixel(newLR);
            Point xyRes = new Point((urPoint.x - ulPoint.x) / style.cols, (llPoint.y - ulPoint.y) / style.rows);
            int screenWidth = screen.width;
            int screenHeight = screen.height;
            GeneralPath path = new GeneralPath(0);
            path.moveTo(0.0f, 0.0f);
            path.lineTo(screenWidth, 0.0f);
            path.lineTo(screenWidth, screenHeight);
            path.lineTo(0.0f, screenHeight);
            path.closePath();
            path.moveTo(ulPoint.x, ulPoint.y);
            path.lineTo(urPoint.x, urPoint.y);
            path.lineTo(lrPoint.x, lrPoint.y);
            path.lineTo(llPoint.x, llPoint.y);
            path.closePath();
            g.fill((Shape)path);
            if (style.doGrid && xyRes.x > 1 && xyRes.y > 1) {
                int x = ulPoint.x + xyRes.x;
                while (x < urPoint.x) {
                    g.drawLine(x, ulPoint.y, x, llPoint.y);
                    x += xyRes.x;
                }
                int y = ulPoint.y + xyRes.y;
                while (y < llPoint.y) {
                    g.drawLine(urPoint.x, y, ulPoint.x, y);
                    y += xyRes.y;
                }
            }
            rgba = style.foregroundColor.getColorComponents(null);
            g.setColor(new Color(rgba[0], rgba[1], rgba[2], style.fAlpha));
            g.setStroke(1, 2);
            g.draw((Shape)path);
            if (style.windPath != null && (windFile = new File(style.windPath)).exists()) {
                File mapsetFile = windFile.getParentFile();
                StringBuilder sb = new StringBuilder();
                sb.append(mapsetFile.getParentFile().getName());
                sb.append("/");
                sb.append(mapsetFile.getName());
                g.drawString(sb.toString(), 10, 10, -1, 0);
            }
        }
        catch (Exception e) {
            context.getLayer().setStatus(2);
            context.getLayer().setStatusMessage("Error in reprojection...");
            e.printStackTrace();
            return;
        }
        context.getLayer().setStatus(0);
        context.getLayer().setStatusMessage("Layer rendered");
    }

    private void getMapset(final IBlackboard styleBlackboard) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CatalogJGrassMapsetTreeViewerDialog mapsetDialog = new CatalogJGrassMapsetTreeViewerDialog();
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    mapsetDialog.open(shell);
                    List<JGrassMapsetGeoResource> selectedLayers = mapsetDialog.getSelectedLayers();
                    if (selectedLayers == null || selectedLayers.size() == 0) {
                        return;
                    }
                    JGrassMapsetGeoResource jGrassMapsetGeoResource = selectedLayers.get(0);
                    JGrassRegion activeRegionWindow = jGrassMapsetGeoResource.getActiveRegionWindow();
                    ActiveRegionStyle style = (ActiveRegionStyle)styleBlackboard.get("eu.udig.catalog.jgrass.activeregion.activeregionStyle");
                    style.windPath = jGrassMapsetGeoResource.getActiveRegionWindowPath();
                    style.north = (float)activeRegionWindow.getNorth();
                    style.south = (float)activeRegionWindow.getSouth();
                    style.east = (float)activeRegionWindow.getEast();
                    style.west = (float)activeRegionWindow.getWest();
                    style.rows = activeRegionWindow.getRows();
                    style.cols = activeRegionWindow.getCols();
                    CoordinateReferenceSystem jGrassCrs = jGrassMapsetGeoResource.getLocationCrs();
                    String code = null;
                    try {
                        Integer epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)jGrassCrs, (boolean)true);
                        code = "EPSG:" + epsg;
                    }
                    catch (Exception exception) {
                        code = CRS.lookupIdentifier((IdentifiedObject)jGrassCrs, (boolean)true);
                    }
                    style.crsString = code;
                    styleBlackboard.put("eu.udig.catalog.jgrass.activeregion.activeregionStyle", (Object)style);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

