/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.jgrass.activeregion;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import eu.udig.catalog.jgrass.JGrassPlugin;
import eu.udig.catalog.jgrass.activeregion.ActiveRegionStyle;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.File;
import java.io.IOException;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.commands.SelectionBoxCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.project.ui.tool.SimpleTool;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class ActiveRegionBBoxSelection
extends SimpleTool
implements ModalTool {
    public static final String ID = "eu.udig.catalog.jgrass.activeregion.ui.activeregionbbox";
    private Point start;
    private boolean selecting;
    private SelectionBoxCommand shapeCommand;

    public ActiveRegionBBoxSelection() {
        super(3);
        JGrassPlugin.getDefault().getActiveRegionMapGraphic();
    }

    protected void onMouseDragged(MapMouseEvent e) {
        Point end = e.getPoint();
        this.shapeCommand.setShape((Shape)new Rectangle(Math.min(this.start.x, end.x), Math.min(this.start.y, end.y), Math.abs(this.start.x - end.x), Math.abs(this.start.y - end.y)));
        this.context.getViewportPane().repaint();
    }

    public void onMousePressed(MapMouseEvent e) {
        this.shapeCommand = new SelectionBoxCommand();
        if ((e.button & 8) != 0) {
            this.selecting = true;
            this.start = e.getPoint();
            this.shapeCommand.setValid(true);
            this.shapeCommand.setShape((Shape)new Rectangle(this.start.x, this.start.y, 0, 0));
            this.context.sendASyncCommand((Command)this.shapeCommand);
        }
    }

    public void onMouseReleased(MapMouseEvent e) {
        if (this.selecting) {
            Point end = e.getPoint();
            if (this.start == null || this.start.equals(end)) {
                ReferencedEnvelope bounds = this.getContext().getBoundingBox(e.getPoint(), 3);
                this.sendSelectionCommand(e, (Envelope)bounds);
            } else {
                Coordinate c1 = this.context.getMap().getViewportModel().pixelToWorld(this.start.x, this.start.y);
                Coordinate c2 = this.context.getMap().getViewportModel().pixelToWorld(end.x, end.y);
                Envelope bounds = new Envelope(c1, c2);
                ILayer activeRegionLayer = JGrassPlugin.getDefault().getActiveRegionMapGraphic();
                IMap activeMap = ApplicationGIS.getActiveMap();
                IBlackboard blackboard = activeMap.getBlackboard();
                ActiveRegionStyle style = (ActiveRegionStyle)blackboard.get("eu.udig.catalog.jgrass.activeregion.activeregionStyle");
                if (style != null) {
                    try {
                        JGrassRegion activeRegion = new JGrassRegion(style.windPath);
                        JGrassRegion newActiveRegion = JGrassRegion.adaptActiveRegionToEnvelope((Envelope)bounds, (JGrassRegion)activeRegion);
                        JGrassRegion.writeWINDToMapset((String)new File(style.windPath).getParent(), (JGrassRegion)newActiveRegion);
                        style.north = (float)newActiveRegion.getNorth();
                        style.south = (float)newActiveRegion.getSouth();
                        style.east = (float)newActiveRegion.getEast();
                        style.west = (float)newActiveRegion.getWest();
                        style.rows = newActiveRegion.getRows();
                        style.cols = newActiveRegion.getCols();
                        blackboard.put("eu.udig.catalog.jgrass.activeregion.activeregionStyle", (Object)style);
                        activeRegionLayer.refresh(null);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                this.sendSelectionCommand(e, bounds);
            }
        }
    }

    protected void sendSelectionCommand(MapMouseEvent e, Envelope bounds) {
        UndoableMapCommand command = e.isModifierDown(MapMouseEvent.MOD2_DOWN_MASK) ? this.getContext().getSelectionFactory().createBBoxSelectionCommand(bounds, 1) : (e.isModifierDown(MapMouseEvent.MOD1_DOWN_MASK) ? this.getContext().getSelectionFactory().createBBoxSelectionCommand(bounds, -1) : this.getContext().getSelectionFactory().createBBoxSelectionCommand(bounds, 0));
        this.getContext().sendASyncCommand((Command)command);
        this.selecting = false;
        this.shapeCommand.setValid(false);
        this.getContext().getViewportPane().repaint();
    }
}

