/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.feature;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.DelegatingHandler;
import org.geotools.geojson.IContentHandler;
import org.geotools.geojson.feature.ArrayHandler;
import org.geotools.geojson.feature.AttributeIO;
import org.geotools.geojson.feature.CRSHandler;
import org.geotools.geojson.feature.DefaultAttributeIO;
import org.geotools.geojson.geom.GeometryCollectionHandler;
import org.geotools.geojson.geom.GeometryHandler;
import org.json.simple.parser.ParseException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureHandler
extends DelegatingHandler<SimpleFeature> {
    String id;
    Geometry geometry;
    List<Object> values;
    List<String> properties;
    CoordinateReferenceSystem crs;
    SimpleFeatureBuilder builder;
    AttributeIO attio;
    SimpleFeature feature;

    public FeatureHandler() {
        this(null, new DefaultAttributeIO());
    }

    public FeatureHandler(SimpleFeatureBuilder builder, AttributeIO attio) {
        this.builder = builder;
        this.attio = attio;
    }

    @Override
    public boolean startObject() throws ParseException, IOException {
        if (this.properties == NULL_LIST) {
            this.properties = new ArrayList<String>();
        } else if (this.properties != null) {
            this.delegate = new GeometryHandler(new GeometryFactory());
        }
        return super.startObject();
    }

    @Override
    public boolean startObjectEntry(String key) throws ParseException, IOException {
        if ("id".equals(key)) {
            this.id = "";
            return true;
        }
        if ("crs".equals(key)) {
            this.delegate = new CRSHandler();
            return true;
        }
        if ("geometry".equals(key)) {
            this.delegate = new GeometryHandler(new GeometryFactory());
            return true;
        }
        if ("properties".equals(key) && this.delegate == NULL) {
            this.properties = NULL_LIST;
            this.values = new ArrayList<Object>();
        } else if (this.properties != null && this.delegate == NULL) {
            this.properties.add(key);
            return true;
        }
        return super.startObjectEntry(key);
    }

    @Override
    public boolean startArray() throws ParseException, IOException {
        if (this.properties != null && this.delegate == NULL) {
            this.delegate = new ArrayHandler();
        }
        return super.startArray();
    }

    @Override
    public boolean endArray() throws ParseException, IOException {
        if (this.delegate instanceof ArrayHandler) {
            super.endArray();
            this.values.add(((ArrayHandler)this.delegate).getValue());
            this.delegate = NULL;
        }
        return super.endArray();
    }

    @Override
    public boolean endObject() throws ParseException, IOException {
        if (this.delegate instanceof IContentHandler) {
            ((IContentHandler)this.delegate).endObject();
            if (this.delegate instanceof GeometryHandler) {
                Geometry g = (Geometry)((IContentHandler)this.delegate).getValue();
                if (g != null || !(((GeometryHandler)this.delegate).getDelegate() instanceof GeometryCollectionHandler)) {
                    if (this.properties != null) {
                        this.values.add(g);
                    } else {
                        this.geometry = g;
                    }
                    this.delegate = NULL;
                }
            } else if (this.delegate instanceof CRSHandler) {
                this.crs = ((CRSHandler)this.delegate).getValue();
                this.delegate = UNINITIALIZED;
            }
            return true;
        }
        if (this.delegate == UNINITIALIZED) {
            this.delegate = NULL;
            return true;
        }
        if (this.properties != null) {
            if (this.builder == null) {
                this.builder = this.createBuilder();
            }
            for (int i = 0; i < this.properties.size(); ++i) {
                String att = this.properties.get(i);
                Object val = this.values.get(i);
                if (val instanceof String) {
                    val = this.attio.parse(att, (String)val);
                }
                this.builder.set(att, val);
            }
            this.properties = null;
            this.values = null;
            return true;
        }
        this.feature = this.buildFeature();
        this.id = null;
        this.geometry = null;
        this.properties = null;
        this.values = null;
        return true;
    }

    @Override
    public boolean primitive(Object value) throws ParseException, IOException {
        if ("".equals(this.id)) {
            this.id = value.toString();
            return true;
        }
        if (this.values != null && this.delegate == NULL) {
            this.values.add(value);
            return true;
        }
        return super.primitive(value);
    }

    @Override
    public SimpleFeature getValue() {
        return this.feature;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public void init() {
        this.feature = null;
    }

    SimpleFeatureBuilder createBuilder() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("feature");
        typeBuilder.setNamespaceURI("http://geotools.org");
        typeBuilder.setCRS(this.crs);
        if (this.properties != null) {
            for (int i = 0; i < this.properties.size(); ++i) {
                String prop = this.properties.get(i);
                Object valu = this.values.get(i);
                typeBuilder.add(prop, valu != null ? valu.getClass() : Object.class);
            }
        }
        if (this.geometry != null) {
            this.addGeometryType(typeBuilder, this.geometry);
        }
        return new SimpleFeatureBuilder(typeBuilder.buildFeatureType());
    }

    void addGeometryType(SimpleFeatureTypeBuilder typeBuilder, Geometry geometry) {
        typeBuilder.add("geometry", geometry != null ? geometry.getClass() : Geometry.class);
        typeBuilder.setDefaultGeometry("geometry");
    }

    SimpleFeature buildFeature() {
        SimpleFeatureBuilder builder = this.builder != null ? this.builder : this.createBuilder();
        SimpleFeatureType featureType = builder.getFeatureType();
        SimpleFeature f = builder.buildFeature(this.id);
        if (this.geometry != null) {
            if (featureType.getGeometryDescriptor() == null) {
                SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
                typeBuilder.init(featureType);
                this.addGeometryType(typeBuilder, this.geometry);
                featureType = typeBuilder.buildFeatureType();
                SimpleFeatureBuilder newBuilder = new SimpleFeatureBuilder(featureType);
                newBuilder.init(f);
                f = newBuilder.buildFeature(this.id);
            }
            f.setAttribute(featureType.getGeometryDescriptor().getLocalName(), (Object)this.geometry);
        }
        return f;
    }
}

