/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.refractions.udig.tools.edit.EditPlugin;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditBlackboardAdapter;
import net.refractions.udig.tools.edit.support.EditBlackboardEvent;
import net.refractions.udig.tools.edit.support.LazyCoord;
import net.refractions.udig.tools.edit.support.Point;

public class Selection
extends AbstractSet<Point>
implements Set<Point> {
    private static final long serialVersionUID = 3103252189848308511L;
    private EditBlackboard blackboard;
    protected Map<Point, Collection<LazyCoord>> coordMap = new ConcurrentHashMap<Point, Collection<LazyCoord>>();
    boolean notify = true;
    protected BlackboardListener blackboardListener = new BlackboardListener();

    public Selection(EditBlackboard blackboard) {
        this.blackboard = blackboard;
        blackboard.getListeners().add(this.getBlackboardListener());
    }

    public Selection(Selection selection2) {
        this(selection2.blackboard);
        this.coordMap.putAll(selection2.coordMap);
    }

    protected BlackboardListener getBlackboardListener() {
        return this.blackboardListener;
    }

    synchronized Collection<LazyCoord> getLazyCoordinates(Point point) {
        return Collections.unmodifiableCollection(this.coordMap.get(point));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doAdd(Point o) {
        boolean result;
        Selection selection = this;
        synchronized (selection) {
            result = this.addInternal(o);
        }
        if (result) {
            this.notifyListeners(Collections.singleton(o), null);
        }
        return result;
    }

    protected boolean addInternal(Point o) {
        List<LazyCoord> coords = this.blackboard.coordMapping.get(o);
        if (coords != null && coords.size() != 0 && !this.coordMap.containsKey(o)) {
            this.coordMap.put(o, new ArrayList<LazyCoord>(coords));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doAddAll(Collection<? extends Point> c) {
        HashSet<Point> added = new HashSet<Point>();
        boolean result = false;
        Selection selection = this;
        synchronized (selection) {
            for (Point point : c) {
                if (point == null) continue;
                boolean wasAdded = this.addInternal(point);
                if (wasAdded) {
                    added.add(point);
                }
                boolean bl = result = result || wasAdded;
            }
        }
        if (result) {
            this.notifyListeners(added, null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClear() {
        HashSet<Point> set = null;
        Selection selection = this;
        synchronized (selection) {
            set = new HashSet<Point>(this.coordMap.keySet());
            this.coordMap.clear();
        }
        if (set != null && !set.isEmpty()) {
            this.notifyListeners(null, set);
        }
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.coordMap.containsKey(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.coordMap.keySet().containsAll(c);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.coordMap.isEmpty();
    }

    @Override
    public Iterator<Point> iterator() {
        return new Iterator<Point>(){
            Iterator<Point> iter;
            Point lastPoint;
            {
                this.iter = Selection.this.coordMap.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Point next() {
                this.lastPoint = this.iter.next();
                return this.lastPoint;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doRemove(Object o) {
        boolean result;
        Selection selection = this;
        synchronized (selection) {
            result = this.coordMap.remove(o) != null;
        }
        if (result) {
            this.notifyListeners(null, Collections.singleton((Point)o));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doRetainAll(Collection<?> c) {
        boolean result;
        HashSet<Point> removed = new HashSet<Point>();
        Selection selection = this;
        synchronized (selection) {
            for (Point p : this.coordMap.keySet()) {
                if (p == null || c.contains(p)) continue;
                removed.add(p);
            }
            result = this.doRemoveAll(removed, false);
        }
        if (!removed.isEmpty()) {
            this.notifyListeners(null, removed);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doRemoveAll(Collection<?> c, boolean notify) {
        boolean result = false;
        HashSet<Point> removed = new HashSet<Point>();
        Selection selection = this;
        synchronized (selection) {
            for (Object point : c) {
                if (point == null || this.coordMap.remove(point) == null) continue;
                removed.add((Point)point);
                result = true;
            }
        }
        if (notify && result) {
            this.notifyListeners(null, removed);
        }
        return result;
    }

    @Override
    public synchronized int size() {
        return this.coordMap.size();
    }

    @Override
    public synchronized Object[] toArray() {
        return this.coordMap.keySet().toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.coordMap.keySet().toArray(a);
    }

    protected void notifyListeners(Set<Point> added, Set<Point> removed) {
        if (!this.notify) {
            return;
        }
        if (added == null) {
            added = Collections.emptySet();
        }
        if (removed == null) {
            removed = Collections.emptySet();
        }
        this.blackboard.notify(new EditBlackboardEvent(this.blackboard, this, EditBlackboardEvent.EventType.SELECTION, removed, added));
    }

    @Override
    public synchronized String toString() {
        return this.coordMap.keySet().toString();
    }

    void add(Point point, List<LazyCoord> coords) {
        Collection<LazyCoord> mappedCoords = this.coordMap.get(point);
        if (mappedCoords == null) {
            mappedCoords = new ArrayList<LazyCoord>();
            this.coordMap.put(point, mappedCoords);
        }
        mappedCoords.addAll(coords);
    }

    public void disconnect() {
        this.blackboard.getListeners().remove(this.blackboardListener);
        this.notify = false;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public void assertValid() {
        if (!EditPlugin.isDebugging("net.refractions.udig.tools.edit/debug/assertions")) {
            return;
        }
    }

    class BlackboardListener
    extends EditBlackboardAdapter {
        BlackboardListener() {
        }

        @Override
        public synchronized void changed(EditBlackboardEvent e) {
            Object oldValue = e.getOldValue();
            switch (e.getType()) {
                case SET_GEOMS: {
                    if (Selection.this.size() <= 0) break;
                    Selection.this.doClear();
                    break;
                }
                case MOVE_POINT: {
                    Point newValue = (Point)e.getNewValue();
                    if (!this.movePoint(oldValue, newValue)) break;
                    Selection.this.notifyListeners(Collections.singleton(newValue), Collections.singleton((Point)oldValue));
                    break;
                }
                case REMOVE_POINT: {
                    Selection.this.doRemove(oldValue);
                    break;
                }
                case TRANFORMATION: {
                    Map<Point, List<Point>> p = e.getTransformationMap();
                    HashSet<Point> added = new HashSet<Point>();
                    try {
                        Selection.this.notify = false;
                        for (Map.Entry<Point, List<Point>> entry : p.entrySet()) {
                            if (!Selection.this.doRemove(entry.getKey())) continue;
                            Selection.this.doAddAll((Collection<? extends Point>)entry.getValue());
                            added.addAll((Collection<Point>)entry.getValue());
                        }
                    }
                    finally {
                        Selection.this.notify = true;
                    }
                    Selection.this.notifyListeners(added, p.keySet());
                    break;
                }
            }
            Selection.this.assertValid();
        }

        private boolean movePoint(Object oldValue, Point newValue) {
            if (newValue.equals(oldValue)) {
                return false;
            }
            if (!Selection.this.contains(oldValue)) {
                return false;
            }
            Collection<LazyCoord> oldCoords = Selection.this.coordMap.get(oldValue);
            Collection<LazyCoord> newCoords = Selection.this.coordMap.get(newValue);
            Selection.this.coordMap.remove(oldValue);
            if (newCoords == null) {
                newCoords = new ArrayList<LazyCoord>();
                Selection.this.coordMap.put(newValue, newCoords);
            }
            newCoords.addAll(oldCoords);
            return true;
        }

        @Override
        public synchronized void batchChange(List<EditBlackboardEvent> e) {
            if (e.isEmpty()) {
                return;
            }
            e.get(0).getEditBlackboard().startBatchingEvents();
            for (EditBlackboardEvent event : e) {
                this.changed(event);
            }
            e.get(0).getEditBlackboard().fireBatchedEvents();
        }
    }
}

