/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.tools.edit.support.AbstractShapeIterator;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditBlackboardAdapter;
import net.refractions.udig.tools.edit.support.EditBlackboardEvent;
import net.refractions.udig.tools.edit.support.EditBlackboardListener;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.ShapeType;

public class PrimitiveShapeIterator
extends AbstractShapeIterator {
    private static final Map<PrimitiveShape, PrimitiveShapeIterator> map = new HashMap<PrimitiveShape, PrimitiveShapeIterator>();
    private static EditBlackboardListener bbListener = new EditBlackboardAdapter(){

        @Override
        public void changed(EditBlackboardEvent event) {
            switch (event.getType()) {
                case CLEARED: {
                    ((EditBlackboard)event.getSource()).getListeners().remove(this);
                    map.clear();
                    break;
                }
                case REMOVE_GEOMS: {
                    List geoms = (List)event.getOldValue();
                    for (EditGeom geom : geoms) {
                        map.remove(geom);
                    }
                    if (!map.isEmpty()) break;
                    ((EditBlackboard)event.getSource()).getListeners().remove(this);
                    break;
                }
            }
        }

        @Override
        public void batchChange(List<EditBlackboardEvent> e) {
            for (EditBlackboardEvent event : e) {
                this.changed(event);
            }
        }
    };
    private boolean isPolygon;

    protected PrimitiveShapeIterator(PrimitiveShape shape) {
        super(shape);
    }

    public static PrimitiveShapeIterator getPathIterator(PrimitiveShape shape) {
        PrimitiveShapeIterator iter = map.get(shape);
        if (iter == null) {
            iter = new PrimitiveShapeIterator(shape);
            shape.getEditBlackboard().getListeners().add(bbListener);
            map.put(shape, iter);
            iter.reset();
        } else {
            iter.reset();
        }
        return iter;
    }

    @Override
    public int currentSegment(float[] coords) {
        int result = super.currentSegment(coords);
        if ((this.isPolygon || this.shape.getEditGeom().getShapeType() == ShapeType.POLYGON) && result != 0 && !this.points.hasNext() && this.isClosed(this.shape)) {
            result = 4;
        }
        return result;
    }

    protected boolean isClosed(PrimitiveShape shape) {
        return shape.getPoint(0).equals(shape.getPoint(shape.getNumPoints() - 1));
    }

    public void setPolygon(boolean isPolygon) {
        this.isPolygon = isPolygon;
    }

    public boolean isPolygon() {
        return this.isPolygon;
    }
}

