/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.edit.support;

public class Point {
    private final int x;
    private final int y;
    private final int hashCode;
    private static final Point[][] cache = new Point[256][256];

    private Point(int x, int y) {
        this.x = x;
        this.y = y;
        this.hashCode = (17 + x) * 37 + y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public static synchronized Point valueOf(int x, int y) {
        if (x > -1 && x < 256 && y > -1 && y < 256) {
            if (cache[x][y] == null) {
                Point.cache[x][y] = new Point(x, y);
            }
            return cache[x][y];
        }
        return new Point(x, y);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Point)) {
            return false;
        }
        Point p = (Point)obj;
        return this.x == p.x && this.y == p.y;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

